/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backupsearch.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetSearchResultExportJobResponse extends BackupSearchResponse implements
        ToCopyableBuilder<GetSearchResultExportJobResponse.Builder, GetSearchResultExportJobResponse> {
    private static final SdkField<String> EXPORT_JOB_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExportJobIdentifier").getter(getter(GetSearchResultExportJobResponse::exportJobIdentifier))
            .setter(setter(Builder::exportJobIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportJobIdentifier").build())
            .build();

    private static final SdkField<String> EXPORT_JOB_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExportJobArn").getter(getter(GetSearchResultExportJobResponse::exportJobArn))
            .setter(setter(Builder::exportJobArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportJobArn").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(GetSearchResultExportJobResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(GetSearchResultExportJobResponse::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<Instant> COMPLETION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CompletionTime").getter(getter(GetSearchResultExportJobResponse::completionTime))
            .setter(setter(Builder::completionTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompletionTime").build()).build();

    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatusMessage").getter(getter(GetSearchResultExportJobResponse::statusMessage))
            .setter(setter(Builder::statusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").build()).build();

    private static final SdkField<ExportSpecification> EXPORT_SPECIFICATION_FIELD = SdkField
            .<ExportSpecification> builder(MarshallingType.SDK_POJO).memberName("ExportSpecification")
            .getter(getter(GetSearchResultExportJobResponse::exportSpecification)).setter(setter(Builder::exportSpecification))
            .constructor(ExportSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportSpecification").build())
            .build();

    private static final SdkField<String> SEARCH_JOB_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SearchJobArn").getter(getter(GetSearchResultExportJobResponse::searchJobArn))
            .setter(setter(Builder::searchJobArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SearchJobArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPORT_JOB_IDENTIFIER_FIELD,
            EXPORT_JOB_ARN_FIELD, STATUS_FIELD, CREATION_TIME_FIELD, COMPLETION_TIME_FIELD, STATUS_MESSAGE_FIELD,
            EXPORT_SPECIFICATION_FIELD, SEARCH_JOB_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String exportJobIdentifier;

    private final String exportJobArn;

    private final String status;

    private final Instant creationTime;

    private final Instant completionTime;

    private final String statusMessage;

    private final ExportSpecification exportSpecification;

    private final String searchJobArn;

    private GetSearchResultExportJobResponse(BuilderImpl builder) {
        super(builder);
        this.exportJobIdentifier = builder.exportJobIdentifier;
        this.exportJobArn = builder.exportJobArn;
        this.status = builder.status;
        this.creationTime = builder.creationTime;
        this.completionTime = builder.completionTime;
        this.statusMessage = builder.statusMessage;
        this.exportSpecification = builder.exportSpecification;
        this.searchJobArn = builder.searchJobArn;
    }

    /**
     * <p>
     * This is the unique string that identifies the specified export job.
     * </p>
     * 
     * @return This is the unique string that identifies the specified export job.
     */
    public final String exportJobIdentifier() {
        return exportJobIdentifier;
    }

    /**
     * <p>
     * The unique Amazon Resource Name (ARN) that uniquely identifies the export job.
     * </p>
     * 
     * @return The unique Amazon Resource Name (ARN) that uniquely identifies the export job.
     */
    public final String exportJobArn() {
        return exportJobArn;
    }

    /**
     * <p>
     * This is the current status of the export job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ExportJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return This is the current status of the export job.
     * @see ExportJobStatus
     */
    public final ExportJobStatus status() {
        return ExportJobStatus.fromValue(status);
    }

    /**
     * <p>
     * This is the current status of the export job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ExportJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return This is the current status of the export job.
     * @see ExportJobStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The date and time that an export job was created, in Unix format and Coordinated Universal Time (UTC). The value
     * of <code>CreationTime</code> is accurate to milliseconds. For example, the value 1516925490.087 represents
     * Friday, January 26, 2018 12:11:30.087 AM.
     * </p>
     * 
     * @return The date and time that an export job was created, in Unix format and Coordinated Universal Time (UTC).
     *         The value of <code>CreationTime</code> is accurate to milliseconds. For example, the value 1516925490.087
     *         represents Friday, January 26, 2018 12:11:30.087 AM.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The date and time that an export job completed, in Unix format and Coordinated Universal Time (UTC). The value of
     * <code>CreationTime</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday,
     * January 26, 2018 12:11:30.087 AM.
     * </p>
     * 
     * @return The date and time that an export job completed, in Unix format and Coordinated Universal Time (UTC). The
     *         value of <code>CreationTime</code> is accurate to milliseconds. For example, the value 1516925490.087
     *         represents Friday, January 26, 2018 12:11:30.087 AM.
     */
    public final Instant completionTime() {
        return completionTime;
    }

    /**
     * <p>
     * A status message is a string that is returned for search job with a status of <code>FAILED</code>, along with
     * steps to remedy and retry the operation.
     * </p>
     * 
     * @return A status message is a string that is returned for search job with a status of <code>FAILED</code>, along
     *         with steps to remedy and retry the operation.
     */
    public final String statusMessage() {
        return statusMessage;
    }

    /**
     * <p>
     * The export specification consists of the destination S3 bucket to which the search results were exported, along
     * with the destination prefix.
     * </p>
     * 
     * @return The export specification consists of the destination S3 bucket to which the search results were exported,
     *         along with the destination prefix.
     */
    public final ExportSpecification exportSpecification() {
        return exportSpecification;
    }

    /**
     * <p>
     * The unique string that identifies the Amazon Resource Name (ARN) of the specified search job.
     * </p>
     * 
     * @return The unique string that identifies the Amazon Resource Name (ARN) of the specified search job.
     */
    public final String searchJobArn() {
        return searchJobArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(exportJobIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(exportJobArn());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(completionTime());
        hashCode = 31 * hashCode + Objects.hashCode(statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(exportSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(searchJobArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSearchResultExportJobResponse)) {
            return false;
        }
        GetSearchResultExportJobResponse other = (GetSearchResultExportJobResponse) obj;
        return Objects.equals(exportJobIdentifier(), other.exportJobIdentifier())
                && Objects.equals(exportJobArn(), other.exportJobArn())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(completionTime(), other.completionTime())
                && Objects.equals(statusMessage(), other.statusMessage())
                && Objects.equals(exportSpecification(), other.exportSpecification())
                && Objects.equals(searchJobArn(), other.searchJobArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetSearchResultExportJobResponse").add("ExportJobIdentifier", exportJobIdentifier())
                .add("ExportJobArn", exportJobArn()).add("Status", statusAsString()).add("CreationTime", creationTime())
                .add("CompletionTime", completionTime()).add("StatusMessage", statusMessage())
                .add("ExportSpecification", exportSpecification()).add("SearchJobArn", searchJobArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ExportJobIdentifier":
            return Optional.ofNullable(clazz.cast(exportJobIdentifier()));
        case "ExportJobArn":
            return Optional.ofNullable(clazz.cast(exportJobArn()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "CompletionTime":
            return Optional.ofNullable(clazz.cast(completionTime()));
        case "StatusMessage":
            return Optional.ofNullable(clazz.cast(statusMessage()));
        case "ExportSpecification":
            return Optional.ofNullable(clazz.cast(exportSpecification()));
        case "SearchJobArn":
            return Optional.ofNullable(clazz.cast(searchJobArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ExportJobIdentifier", EXPORT_JOB_IDENTIFIER_FIELD);
        map.put("ExportJobArn", EXPORT_JOB_ARN_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("CompletionTime", COMPLETION_TIME_FIELD);
        map.put("StatusMessage", STATUS_MESSAGE_FIELD);
        map.put("ExportSpecification", EXPORT_SPECIFICATION_FIELD);
        map.put("SearchJobArn", SEARCH_JOB_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetSearchResultExportJobResponse, T> g) {
        return obj -> g.apply((GetSearchResultExportJobResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BackupSearchResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetSearchResultExportJobResponse> {
        /**
         * <p>
         * This is the unique string that identifies the specified export job.
         * </p>
         * 
         * @param exportJobIdentifier
         *        This is the unique string that identifies the specified export job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exportJobIdentifier(String exportJobIdentifier);

        /**
         * <p>
         * The unique Amazon Resource Name (ARN) that uniquely identifies the export job.
         * </p>
         * 
         * @param exportJobArn
         *        The unique Amazon Resource Name (ARN) that uniquely identifies the export job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exportJobArn(String exportJobArn);

        /**
         * <p>
         * This is the current status of the export job.
         * </p>
         * 
         * @param status
         *        This is the current status of the export job.
         * @see ExportJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExportJobStatus
         */
        Builder status(String status);

        /**
         * <p>
         * This is the current status of the export job.
         * </p>
         * 
         * @param status
         *        This is the current status of the export job.
         * @see ExportJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExportJobStatus
         */
        Builder status(ExportJobStatus status);

        /**
         * <p>
         * The date and time that an export job was created, in Unix format and Coordinated Universal Time (UTC). The
         * value of <code>CreationTime</code> is accurate to milliseconds. For example, the value 1516925490.087
         * represents Friday, January 26, 2018 12:11:30.087 AM.
         * </p>
         * 
         * @param creationTime
         *        The date and time that an export job was created, in Unix format and Coordinated Universal Time (UTC).
         *        The value of <code>CreationTime</code> is accurate to milliseconds. For example, the value
         *        1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The date and time that an export job completed, in Unix format and Coordinated Universal Time (UTC). The
         * value of <code>CreationTime</code> is accurate to milliseconds. For example, the value 1516925490.087
         * represents Friday, January 26, 2018 12:11:30.087 AM.
         * </p>
         * 
         * @param completionTime
         *        The date and time that an export job completed, in Unix format and Coordinated Universal Time (UTC).
         *        The value of <code>CreationTime</code> is accurate to milliseconds. For example, the value
         *        1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder completionTime(Instant completionTime);

        /**
         * <p>
         * A status message is a string that is returned for search job with a status of <code>FAILED</code>, along with
         * steps to remedy and retry the operation.
         * </p>
         * 
         * @param statusMessage
         *        A status message is a string that is returned for search job with a status of <code>FAILED</code>,
         *        along with steps to remedy and retry the operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusMessage(String statusMessage);

        /**
         * <p>
         * The export specification consists of the destination S3 bucket to which the search results were exported,
         * along with the destination prefix.
         * </p>
         * 
         * @param exportSpecification
         *        The export specification consists of the destination S3 bucket to which the search results were
         *        exported, along with the destination prefix.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exportSpecification(ExportSpecification exportSpecification);

        /**
         * <p>
         * The export specification consists of the destination S3 bucket to which the search results were exported,
         * along with the destination prefix.
         * </p>
         * This is a convenience method that creates an instance of the {@link ExportSpecification.Builder} avoiding the
         * need to create one manually via {@link ExportSpecification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ExportSpecification.Builder#build()} is called immediately and
         * its result is passed to {@link #exportSpecification(ExportSpecification)}.
         * 
         * @param exportSpecification
         *        a consumer that will call methods on {@link ExportSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #exportSpecification(ExportSpecification)
         */
        default Builder exportSpecification(Consumer<ExportSpecification.Builder> exportSpecification) {
            return exportSpecification(ExportSpecification.builder().applyMutation(exportSpecification).build());
        }

        /**
         * <p>
         * The unique string that identifies the Amazon Resource Name (ARN) of the specified search job.
         * </p>
         * 
         * @param searchJobArn
         *        The unique string that identifies the Amazon Resource Name (ARN) of the specified search job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder searchJobArn(String searchJobArn);
    }

    static final class BuilderImpl extends BackupSearchResponse.BuilderImpl implements Builder {
        private String exportJobIdentifier;

        private String exportJobArn;

        private String status;

        private Instant creationTime;

        private Instant completionTime;

        private String statusMessage;

        private ExportSpecification exportSpecification;

        private String searchJobArn;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSearchResultExportJobResponse model) {
            super(model);
            exportJobIdentifier(model.exportJobIdentifier);
            exportJobArn(model.exportJobArn);
            status(model.status);
            creationTime(model.creationTime);
            completionTime(model.completionTime);
            statusMessage(model.statusMessage);
            exportSpecification(model.exportSpecification);
            searchJobArn(model.searchJobArn);
        }

        public final String getExportJobIdentifier() {
            return exportJobIdentifier;
        }

        public final void setExportJobIdentifier(String exportJobIdentifier) {
            this.exportJobIdentifier = exportJobIdentifier;
        }

        @Override
        public final Builder exportJobIdentifier(String exportJobIdentifier) {
            this.exportJobIdentifier = exportJobIdentifier;
            return this;
        }

        public final String getExportJobArn() {
            return exportJobArn;
        }

        public final void setExportJobArn(String exportJobArn) {
            this.exportJobArn = exportJobArn;
        }

        @Override
        public final Builder exportJobArn(String exportJobArn) {
            this.exportJobArn = exportJobArn;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ExportJobStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getCompletionTime() {
            return completionTime;
        }

        public final void setCompletionTime(Instant completionTime) {
            this.completionTime = completionTime;
        }

        @Override
        public final Builder completionTime(Instant completionTime) {
            this.completionTime = completionTime;
            return this;
        }

        public final String getStatusMessage() {
            return statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final ExportSpecification.Builder getExportSpecification() {
            return exportSpecification != null ? exportSpecification.toBuilder() : null;
        }

        public final void setExportSpecification(ExportSpecification.BuilderImpl exportSpecification) {
            this.exportSpecification = exportSpecification != null ? exportSpecification.build() : null;
        }

        @Override
        public final Builder exportSpecification(ExportSpecification exportSpecification) {
            this.exportSpecification = exportSpecification;
            return this;
        }

        public final String getSearchJobArn() {
            return searchJobArn;
        }

        public final void setSearchJobArn(String searchJobArn) {
            this.searchJobArn = searchJobArn;
        }

        @Override
        public final Builder searchJobArn(String searchJobArn) {
            this.searchJobArn = searchJobArn;
            return this;
        }

        @Override
        public GetSearchResultExportJobResponse build() {
            return new GetSearchResultExportJobResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
