/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backupsearch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Item Filters represent all input item properties specified when the search was created.
 * </p>
 * <p>
 * Contains either EBSItemFilters or S3ItemFilters
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ItemFilters implements SdkPojo, Serializable, ToCopyableBuilder<ItemFilters.Builder, ItemFilters> {
    private static final SdkField<List<S3ItemFilter>> S3_ITEM_FILTERS_FIELD = SdkField
            .<List<S3ItemFilter>> builder(MarshallingType.LIST)
            .memberName("S3ItemFilters")
            .getter(getter(ItemFilters::s3ItemFilters))
            .setter(setter(Builder::s3ItemFilters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3ItemFilters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<S3ItemFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(S3ItemFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<EBSItemFilter>> EBS_ITEM_FILTERS_FIELD = SdkField
            .<List<EBSItemFilter>> builder(MarshallingType.LIST)
            .memberName("EBSItemFilters")
            .getter(getter(ItemFilters::ebsItemFilters))
            .setter(setter(Builder::ebsItemFilters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EBSItemFilters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EBSItemFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(EBSItemFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_ITEM_FILTERS_FIELD,
            EBS_ITEM_FILTERS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<S3ItemFilter> s3ItemFilters;

    private final List<EBSItemFilter> ebsItemFilters;

    private ItemFilters(BuilderImpl builder) {
        this.s3ItemFilters = builder.s3ItemFilters;
        this.ebsItemFilters = builder.ebsItemFilters;
    }

    /**
     * For responses, this returns true if the service returned a value for the S3ItemFilters property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasS3ItemFilters() {
        return s3ItemFilters != null && !(s3ItemFilters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * This array can contain CreationTimes, ETags, ObjectKeys, Sizes, or VersionIds objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasS3ItemFilters} method.
     * </p>
     * 
     * @return This array can contain CreationTimes, ETags, ObjectKeys, Sizes, or VersionIds objects.
     */
    public final List<S3ItemFilter> s3ItemFilters() {
        return s3ItemFilters;
    }

    /**
     * For responses, this returns true if the service returned a value for the EBSItemFilters property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEbsItemFilters() {
        return ebsItemFilters != null && !(ebsItemFilters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * This array can contain CreationTimes, FilePaths, LastModificationTimes, or Sizes objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEbsItemFilters} method.
     * </p>
     * 
     * @return This array can contain CreationTimes, FilePaths, LastModificationTimes, or Sizes objects.
     */
    public final List<EBSItemFilter> ebsItemFilters() {
        return ebsItemFilters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasS3ItemFilters() ? s3ItemFilters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasEbsItemFilters() ? ebsItemFilters() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ItemFilters)) {
            return false;
        }
        ItemFilters other = (ItemFilters) obj;
        return hasS3ItemFilters() == other.hasS3ItemFilters() && Objects.equals(s3ItemFilters(), other.s3ItemFilters())
                && hasEbsItemFilters() == other.hasEbsItemFilters() && Objects.equals(ebsItemFilters(), other.ebsItemFilters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ItemFilters").add("S3ItemFilters", hasS3ItemFilters() ? s3ItemFilters() : null)
                .add("EBSItemFilters", hasEbsItemFilters() ? ebsItemFilters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "S3ItemFilters":
            return Optional.ofNullable(clazz.cast(s3ItemFilters()));
        case "EBSItemFilters":
            return Optional.ofNullable(clazz.cast(ebsItemFilters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("S3ItemFilters", S3_ITEM_FILTERS_FIELD);
        map.put("EBSItemFilters", EBS_ITEM_FILTERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ItemFilters, T> g) {
        return obj -> g.apply((ItemFilters) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ItemFilters> {
        /**
         * <p>
         * This array can contain CreationTimes, ETags, ObjectKeys, Sizes, or VersionIds objects.
         * </p>
         * 
         * @param s3ItemFilters
         *        This array can contain CreationTimes, ETags, ObjectKeys, Sizes, or VersionIds objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3ItemFilters(Collection<S3ItemFilter> s3ItemFilters);

        /**
         * <p>
         * This array can contain CreationTimes, ETags, ObjectKeys, Sizes, or VersionIds objects.
         * </p>
         * 
         * @param s3ItemFilters
         *        This array can contain CreationTimes, ETags, ObjectKeys, Sizes, or VersionIds objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3ItemFilters(S3ItemFilter... s3ItemFilters);

        /**
         * <p>
         * This array can contain CreationTimes, ETags, ObjectKeys, Sizes, or VersionIds objects.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.backupsearch.model.S3ItemFilter.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.backupsearch.model.S3ItemFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.backupsearch.model.S3ItemFilter.Builder#build()} is called immediately
         * and its result is passed to {@link #s3ItemFilters(List<S3ItemFilter>)}.
         * 
         * @param s3ItemFilters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.backupsearch.model.S3ItemFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3ItemFilters(java.util.Collection<S3ItemFilter>)
         */
        Builder s3ItemFilters(Consumer<S3ItemFilter.Builder>... s3ItemFilters);

        /**
         * <p>
         * This array can contain CreationTimes, FilePaths, LastModificationTimes, or Sizes objects.
         * </p>
         * 
         * @param ebsItemFilters
         *        This array can contain CreationTimes, FilePaths, LastModificationTimes, or Sizes objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ebsItemFilters(Collection<EBSItemFilter> ebsItemFilters);

        /**
         * <p>
         * This array can contain CreationTimes, FilePaths, LastModificationTimes, or Sizes objects.
         * </p>
         * 
         * @param ebsItemFilters
         *        This array can contain CreationTimes, FilePaths, LastModificationTimes, or Sizes objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ebsItemFilters(EBSItemFilter... ebsItemFilters);

        /**
         * <p>
         * This array can contain CreationTimes, FilePaths, LastModificationTimes, or Sizes objects.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.backupsearch.model.EBSItemFilter.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.backupsearch.model.EBSItemFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.backupsearch.model.EBSItemFilter.Builder#build()} is called
         * immediately and its result is passed to {@link #ebsItemFilters(List<EBSItemFilter>)}.
         * 
         * @param ebsItemFilters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.backupsearch.model.EBSItemFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ebsItemFilters(java.util.Collection<EBSItemFilter>)
         */
        Builder ebsItemFilters(Consumer<EBSItemFilter.Builder>... ebsItemFilters);
    }

    static final class BuilderImpl implements Builder {
        private List<S3ItemFilter> s3ItemFilters = DefaultSdkAutoConstructList.getInstance();

        private List<EBSItemFilter> ebsItemFilters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ItemFilters model) {
            s3ItemFilters(model.s3ItemFilters);
            ebsItemFilters(model.ebsItemFilters);
        }

        public final List<S3ItemFilter.Builder> getS3ItemFilters() {
            List<S3ItemFilter.Builder> result = S3ItemFiltersCopier.copyToBuilder(this.s3ItemFilters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setS3ItemFilters(Collection<S3ItemFilter.BuilderImpl> s3ItemFilters) {
            this.s3ItemFilters = S3ItemFiltersCopier.copyFromBuilder(s3ItemFilters);
        }

        @Override
        public final Builder s3ItemFilters(Collection<S3ItemFilter> s3ItemFilters) {
            this.s3ItemFilters = S3ItemFiltersCopier.copy(s3ItemFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder s3ItemFilters(S3ItemFilter... s3ItemFilters) {
            s3ItemFilters(Arrays.asList(s3ItemFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder s3ItemFilters(Consumer<S3ItemFilter.Builder>... s3ItemFilters) {
            s3ItemFilters(Stream.of(s3ItemFilters).map(c -> S3ItemFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<EBSItemFilter.Builder> getEbsItemFilters() {
            List<EBSItemFilter.Builder> result = EBSItemFiltersCopier.copyToBuilder(this.ebsItemFilters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEbsItemFilters(Collection<EBSItemFilter.BuilderImpl> ebsItemFilters) {
            this.ebsItemFilters = EBSItemFiltersCopier.copyFromBuilder(ebsItemFilters);
        }

        @Override
        public final Builder ebsItemFilters(Collection<EBSItemFilter> ebsItemFilters) {
            this.ebsItemFilters = EBSItemFiltersCopier.copy(ebsItemFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ebsItemFilters(EBSItemFilter... ebsItemFilters) {
            ebsItemFilters(Arrays.asList(ebsItemFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ebsItemFilters(Consumer<EBSItemFilter.Builder>... ebsItemFilters) {
            ebsItemFilters(Stream.of(ebsItemFilters).map(c -> EBSItemFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ItemFilters build() {
            return new ItemFilters(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
