/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backupsearch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This is an object representing the item returned in the results of a search for a specific resource type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResultItem implements SdkPojo, Serializable, ToCopyableBuilder<ResultItem.Builder, ResultItem> {
    private static final SdkField<S3ResultItem> S3_RESULT_ITEM_FIELD = SdkField.<S3ResultItem> builder(MarshallingType.SDK_POJO)
            .memberName("S3ResultItem").getter(getter(ResultItem::s3ResultItem)).setter(setter(Builder::s3ResultItem))
            .constructor(S3ResultItem::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3ResultItem").build()).build();

    private static final SdkField<EBSResultItem> EBS_RESULT_ITEM_FIELD = SdkField
            .<EBSResultItem> builder(MarshallingType.SDK_POJO).memberName("EBSResultItem")
            .getter(getter(ResultItem::ebsResultItem)).setter(setter(Builder::ebsResultItem)).constructor(EBSResultItem::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EBSResultItem").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_RESULT_ITEM_FIELD,
            EBS_RESULT_ITEM_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final S3ResultItem s3ResultItem;

    private final EBSResultItem ebsResultItem;

    private final Type type;

    private ResultItem(BuilderImpl builder) {
        this.s3ResultItem = builder.s3ResultItem;
        this.ebsResultItem = builder.ebsResultItem;
        this.type = builder.type;
    }

    /**
     * <p>
     * These are items returned in the search results of an Amazon S3 search.
     * </p>
     * 
     * @return These are items returned in the search results of an Amazon S3 search.
     */
    public final S3ResultItem s3ResultItem() {
        return s3ResultItem;
    }

    /**
     * <p>
     * These are items returned in the search results of an Amazon EBS search.
     * </p>
     * 
     * @return These are items returned in the search results of an Amazon EBS search.
     */
    public final EBSResultItem ebsResultItem() {
        return ebsResultItem;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(s3ResultItem());
        hashCode = 31 * hashCode + Objects.hashCode(ebsResultItem());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResultItem)) {
            return false;
        }
        ResultItem other = (ResultItem) obj;
        return Objects.equals(s3ResultItem(), other.s3ResultItem()) && Objects.equals(ebsResultItem(), other.ebsResultItem());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ResultItem").add("S3ResultItem", s3ResultItem()).add("EBSResultItem", ebsResultItem()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "S3ResultItem":
            return Optional.ofNullable(clazz.cast(s3ResultItem()));
        case "EBSResultItem":
            return Optional.ofNullable(clazz.cast(ebsResultItem()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #s3ResultItem()} initialized to the given value.
     *
     * <p>
     * These are items returned in the search results of an Amazon S3 search.
     * </p>
     * 
     * @param s3ResultItem
     *        These are items returned in the search results of an Amazon S3 search.
     */
    public static ResultItem fromS3ResultItem(S3ResultItem s3ResultItem) {
        return builder().s3ResultItem(s3ResultItem).build();
    }

    /**
     * Create an instance of this class with {@link #s3ResultItem()} initialized to the given value.
     *
     * <p>
     * These are items returned in the search results of an Amazon S3 search.
     * </p>
     * 
     * @param s3ResultItem
     *        These are items returned in the search results of an Amazon S3 search.
     */
    public static ResultItem fromS3ResultItem(Consumer<S3ResultItem.Builder> s3ResultItem) {
        S3ResultItem.Builder builder = S3ResultItem.builder();
        s3ResultItem.accept(builder);
        return fromS3ResultItem(builder.build());
    }

    /**
     * Create an instance of this class with {@link #ebsResultItem()} initialized to the given value.
     *
     * <p>
     * These are items returned in the search results of an Amazon EBS search.
     * </p>
     * 
     * @param ebsResultItem
     *        These are items returned in the search results of an Amazon EBS search.
     */
    public static ResultItem fromEbsResultItem(EBSResultItem ebsResultItem) {
        return builder().ebsResultItem(ebsResultItem).build();
    }

    /**
     * Create an instance of this class with {@link #ebsResultItem()} initialized to the given value.
     *
     * <p>
     * These are items returned in the search results of an Amazon EBS search.
     * </p>
     * 
     * @param ebsResultItem
     *        These are items returned in the search results of an Amazon EBS search.
     */
    public static ResultItem fromEbsResultItem(Consumer<EBSResultItem.Builder> ebsResultItem) {
        EBSResultItem.Builder builder = EBSResultItem.builder();
        ebsResultItem.accept(builder);
        return fromEbsResultItem(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("S3ResultItem", S3_RESULT_ITEM_FIELD);
        map.put("EBSResultItem", EBS_RESULT_ITEM_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ResultItem, T> g) {
        return obj -> g.apply((ResultItem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResultItem> {
        /**
         * <p>
         * These are items returned in the search results of an Amazon S3 search.
         * </p>
         * 
         * @param s3ResultItem
         *        These are items returned in the search results of an Amazon S3 search.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3ResultItem(S3ResultItem s3ResultItem);

        /**
         * <p>
         * These are items returned in the search results of an Amazon S3 search.
         * </p>
         * This is a convenience method that creates an instance of the {@link S3ResultItem.Builder} avoiding the need
         * to create one manually via {@link S3ResultItem#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link S3ResultItem.Builder#build()} is called immediately and its
         * result is passed to {@link #s3ResultItem(S3ResultItem)}.
         * 
         * @param s3ResultItem
         *        a consumer that will call methods on {@link S3ResultItem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3ResultItem(S3ResultItem)
         */
        default Builder s3ResultItem(Consumer<S3ResultItem.Builder> s3ResultItem) {
            return s3ResultItem(S3ResultItem.builder().applyMutation(s3ResultItem).build());
        }

        /**
         * <p>
         * These are items returned in the search results of an Amazon EBS search.
         * </p>
         * 
         * @param ebsResultItem
         *        These are items returned in the search results of an Amazon EBS search.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ebsResultItem(EBSResultItem ebsResultItem);

        /**
         * <p>
         * These are items returned in the search results of an Amazon EBS search.
         * </p>
         * This is a convenience method that creates an instance of the {@link EBSResultItem.Builder} avoiding the need
         * to create one manually via {@link EBSResultItem#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EBSResultItem.Builder#build()} is called immediately and its
         * result is passed to {@link #ebsResultItem(EBSResultItem)}.
         * 
         * @param ebsResultItem
         *        a consumer that will call methods on {@link EBSResultItem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ebsResultItem(EBSResultItem)
         */
        default Builder ebsResultItem(Consumer<EBSResultItem.Builder> ebsResultItem) {
            return ebsResultItem(EBSResultItem.builder().applyMutation(ebsResultItem).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private S3ResultItem s3ResultItem;

        private EBSResultItem ebsResultItem;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(ResultItem model) {
            s3ResultItem(model.s3ResultItem);
            ebsResultItem(model.ebsResultItem);
        }

        public final S3ResultItem.Builder getS3ResultItem() {
            return s3ResultItem != null ? s3ResultItem.toBuilder() : null;
        }

        public final void setS3ResultItem(S3ResultItem.BuilderImpl s3ResultItem) {
            Object oldValue = this.s3ResultItem;
            this.s3ResultItem = s3ResultItem != null ? s3ResultItem.build() : null;
            handleUnionValueChange(Type.S3_RESULT_ITEM, oldValue, this.s3ResultItem);
        }

        @Override
        public final Builder s3ResultItem(S3ResultItem s3ResultItem) {
            Object oldValue = this.s3ResultItem;
            this.s3ResultItem = s3ResultItem;
            handleUnionValueChange(Type.S3_RESULT_ITEM, oldValue, this.s3ResultItem);
            return this;
        }

        public final EBSResultItem.Builder getEbsResultItem() {
            return ebsResultItem != null ? ebsResultItem.toBuilder() : null;
        }

        public final void setEbsResultItem(EBSResultItem.BuilderImpl ebsResultItem) {
            Object oldValue = this.ebsResultItem;
            this.ebsResultItem = ebsResultItem != null ? ebsResultItem.build() : null;
            handleUnionValueChange(Type.EBS_RESULT_ITEM, oldValue, this.ebsResultItem);
        }

        @Override
        public final Builder ebsResultItem(EBSResultItem ebsResultItem) {
            Object oldValue = this.ebsResultItem;
            this.ebsResultItem = ebsResultItem;
            handleUnionValueChange(Type.EBS_RESULT_ITEM, oldValue, this.ebsResultItem);
            return this;
        }

        @Override
        public ResultItem build() {
            return new ResultItem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see ResultItem#type()
     */
    public enum Type {
        S3_RESULT_ITEM,

        EBS_RESULT_ITEM,

        UNKNOWN_TO_SDK_VERSION
    }
}
