/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backupsearch.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This is information pertaining to a search job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SearchJobSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<SearchJobSummary.Builder, SearchJobSummary> {
    private static final SdkField<String> SEARCH_JOB_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SearchJobIdentifier").getter(getter(SearchJobSummary::searchJobIdentifier))
            .setter(setter(Builder::searchJobIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SearchJobIdentifier").build())
            .build();

    private static final SdkField<String> SEARCH_JOB_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SearchJobArn").getter(getter(SearchJobSummary::searchJobArn)).setter(setter(Builder::searchJobArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SearchJobArn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(SearchJobSummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(SearchJobSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(SearchJobSummary::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<Instant> COMPLETION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CompletionTime").getter(getter(SearchJobSummary::completionTime))
            .setter(setter(Builder::completionTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompletionTime").build()).build();

    private static final SdkField<SearchScopeSummary> SEARCH_SCOPE_SUMMARY_FIELD = SdkField
            .<SearchScopeSummary> builder(MarshallingType.SDK_POJO).memberName("SearchScopeSummary")
            .getter(getter(SearchJobSummary::searchScopeSummary)).setter(setter(Builder::searchScopeSummary))
            .constructor(SearchScopeSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SearchScopeSummary").build())
            .build();

    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatusMessage").getter(getter(SearchJobSummary::statusMessage)).setter(setter(Builder::statusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SEARCH_JOB_IDENTIFIER_FIELD,
            SEARCH_JOB_ARN_FIELD, NAME_FIELD, STATUS_FIELD, CREATION_TIME_FIELD, COMPLETION_TIME_FIELD,
            SEARCH_SCOPE_SUMMARY_FIELD, STATUS_MESSAGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String searchJobIdentifier;

    private final String searchJobArn;

    private final String name;

    private final String status;

    private final Instant creationTime;

    private final Instant completionTime;

    private final SearchScopeSummary searchScopeSummary;

    private final String statusMessage;

    private SearchJobSummary(BuilderImpl builder) {
        this.searchJobIdentifier = builder.searchJobIdentifier;
        this.searchJobArn = builder.searchJobArn;
        this.name = builder.name;
        this.status = builder.status;
        this.creationTime = builder.creationTime;
        this.completionTime = builder.completionTime;
        this.searchScopeSummary = builder.searchScopeSummary;
        this.statusMessage = builder.statusMessage;
    }

    /**
     * <p>
     * The unique string that specifies the search job.
     * </p>
     * 
     * @return The unique string that specifies the search job.
     */
    public final String searchJobIdentifier() {
        return searchJobIdentifier;
    }

    /**
     * <p>
     * The unique string that identifies the Amazon Resource Name (ARN) of the specified search job.
     * </p>
     * 
     * @return The unique string that identifies the Amazon Resource Name (ARN) of the specified search job.
     */
    public final String searchJobArn() {
        return searchJobArn;
    }

    /**
     * <p>
     * This is the name of the search job.
     * </p>
     * 
     * @return This is the name of the search job.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * This is the status of the search job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link SearchJobState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return This is the status of the search job.
     * @see SearchJobState
     */
    public final SearchJobState status() {
        return SearchJobState.fromValue(status);
    }

    /**
     * <p>
     * This is the status of the search job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link SearchJobState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return This is the status of the search job.
     * @see SearchJobState
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * This is the creation time of the search job.
     * </p>
     * 
     * @return This is the creation time of the search job.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * This is the completion time of the search job.
     * </p>
     * 
     * @return This is the completion time of the search job.
     */
    public final Instant completionTime() {
        return completionTime;
    }

    /**
     * <p>
     * Returned summary of the specified search job scope, including:
     * </p>
     * <ul>
     * <li>
     * <p>
     * TotalBackupsToScanCount, the number of recovery points returned by the search.
     * </p>
     * </li>
     * <li>
     * <p>
     * TotalItemsToScanCount, the number of items returned by the search.
     * </p>
     * </li>
     * </ul>
     * 
     * @return Returned summary of the specified search job scope, including: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         TotalBackupsToScanCount, the number of recovery points returned by the search.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         TotalItemsToScanCount, the number of items returned by the search.
     *         </p>
     *         </li>
     */
    public final SearchScopeSummary searchScopeSummary() {
        return searchScopeSummary;
    }

    /**
     * <p>
     * A status message will be returned for either a earch job with a status of <code>ERRORED</code> or a status of
     * <code>COMPLETED</code> jobs with issues.
     * </p>
     * <p>
     * For example, a message may say that a search contained recovery points unable to be scanned because of a
     * permissions issue.
     * </p>
     * 
     * @return A status message will be returned for either a earch job with a status of <code>ERRORED</code> or a
     *         status of <code>COMPLETED</code> jobs with issues.</p>
     *         <p>
     *         For example, a message may say that a search contained recovery points unable to be scanned because of a
     *         permissions issue.
     */
    public final String statusMessage() {
        return statusMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(searchJobIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(searchJobArn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(completionTime());
        hashCode = 31 * hashCode + Objects.hashCode(searchScopeSummary());
        hashCode = 31 * hashCode + Objects.hashCode(statusMessage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchJobSummary)) {
            return false;
        }
        SearchJobSummary other = (SearchJobSummary) obj;
        return Objects.equals(searchJobIdentifier(), other.searchJobIdentifier())
                && Objects.equals(searchJobArn(), other.searchJobArn()) && Objects.equals(name(), other.name())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(completionTime(), other.completionTime())
                && Objects.equals(searchScopeSummary(), other.searchScopeSummary())
                && Objects.equals(statusMessage(), other.statusMessage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SearchJobSummary").add("SearchJobIdentifier", searchJobIdentifier())
                .add("SearchJobArn", searchJobArn()).add("Name", name()).add("Status", statusAsString())
                .add("CreationTime", creationTime()).add("CompletionTime", completionTime())
                .add("SearchScopeSummary", searchScopeSummary()).add("StatusMessage", statusMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SearchJobIdentifier":
            return Optional.ofNullable(clazz.cast(searchJobIdentifier()));
        case "SearchJobArn":
            return Optional.ofNullable(clazz.cast(searchJobArn()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "CompletionTime":
            return Optional.ofNullable(clazz.cast(completionTime()));
        case "SearchScopeSummary":
            return Optional.ofNullable(clazz.cast(searchScopeSummary()));
        case "StatusMessage":
            return Optional.ofNullable(clazz.cast(statusMessage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SearchJobIdentifier", SEARCH_JOB_IDENTIFIER_FIELD);
        map.put("SearchJobArn", SEARCH_JOB_ARN_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("CompletionTime", COMPLETION_TIME_FIELD);
        map.put("SearchScopeSummary", SEARCH_SCOPE_SUMMARY_FIELD);
        map.put("StatusMessage", STATUS_MESSAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SearchJobSummary, T> g) {
        return obj -> g.apply((SearchJobSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SearchJobSummary> {
        /**
         * <p>
         * The unique string that specifies the search job.
         * </p>
         * 
         * @param searchJobIdentifier
         *        The unique string that specifies the search job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder searchJobIdentifier(String searchJobIdentifier);

        /**
         * <p>
         * The unique string that identifies the Amazon Resource Name (ARN) of the specified search job.
         * </p>
         * 
         * @param searchJobArn
         *        The unique string that identifies the Amazon Resource Name (ARN) of the specified search job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder searchJobArn(String searchJobArn);

        /**
         * <p>
         * This is the name of the search job.
         * </p>
         * 
         * @param name
         *        This is the name of the search job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * This is the status of the search job.
         * </p>
         * 
         * @param status
         *        This is the status of the search job.
         * @see SearchJobState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SearchJobState
         */
        Builder status(String status);

        /**
         * <p>
         * This is the status of the search job.
         * </p>
         * 
         * @param status
         *        This is the status of the search job.
         * @see SearchJobState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SearchJobState
         */
        Builder status(SearchJobState status);

        /**
         * <p>
         * This is the creation time of the search job.
         * </p>
         * 
         * @param creationTime
         *        This is the creation time of the search job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * This is the completion time of the search job.
         * </p>
         * 
         * @param completionTime
         *        This is the completion time of the search job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder completionTime(Instant completionTime);

        /**
         * <p>
         * Returned summary of the specified search job scope, including:
         * </p>
         * <ul>
         * <li>
         * <p>
         * TotalBackupsToScanCount, the number of recovery points returned by the search.
         * </p>
         * </li>
         * <li>
         * <p>
         * TotalItemsToScanCount, the number of items returned by the search.
         * </p>
         * </li>
         * </ul>
         * 
         * @param searchScopeSummary
         *        Returned summary of the specified search job scope, including: </p>
         *        <ul>
         *        <li>
         *        <p>
         *        TotalBackupsToScanCount, the number of recovery points returned by the search.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        TotalItemsToScanCount, the number of items returned by the search.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder searchScopeSummary(SearchScopeSummary searchScopeSummary);

        /**
         * <p>
         * Returned summary of the specified search job scope, including:
         * </p>
         * <ul>
         * <li>
         * <p>
         * TotalBackupsToScanCount, the number of recovery points returned by the search.
         * </p>
         * </li>
         * <li>
         * <p>
         * TotalItemsToScanCount, the number of items returned by the search.
         * </p>
         * </li>
         * </ul>
         * This is a convenience method that creates an instance of the {@link SearchScopeSummary.Builder} avoiding the
         * need to create one manually via {@link SearchScopeSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SearchScopeSummary.Builder#build()} is called immediately and its
         * result is passed to {@link #searchScopeSummary(SearchScopeSummary)}.
         * 
         * @param searchScopeSummary
         *        a consumer that will call methods on {@link SearchScopeSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #searchScopeSummary(SearchScopeSummary)
         */
        default Builder searchScopeSummary(Consumer<SearchScopeSummary.Builder> searchScopeSummary) {
            return searchScopeSummary(SearchScopeSummary.builder().applyMutation(searchScopeSummary).build());
        }

        /**
         * <p>
         * A status message will be returned for either a earch job with a status of <code>ERRORED</code> or a status of
         * <code>COMPLETED</code> jobs with issues.
         * </p>
         * <p>
         * For example, a message may say that a search contained recovery points unable to be scanned because of a
         * permissions issue.
         * </p>
         * 
         * @param statusMessage
         *        A status message will be returned for either a earch job with a status of <code>ERRORED</code> or a
         *        status of <code>COMPLETED</code> jobs with issues.</p>
         *        <p>
         *        For example, a message may say that a search contained recovery points unable to be scanned because of
         *        a permissions issue.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusMessage(String statusMessage);
    }

    static final class BuilderImpl implements Builder {
        private String searchJobIdentifier;

        private String searchJobArn;

        private String name;

        private String status;

        private Instant creationTime;

        private Instant completionTime;

        private SearchScopeSummary searchScopeSummary;

        private String statusMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchJobSummary model) {
            searchJobIdentifier(model.searchJobIdentifier);
            searchJobArn(model.searchJobArn);
            name(model.name);
            status(model.status);
            creationTime(model.creationTime);
            completionTime(model.completionTime);
            searchScopeSummary(model.searchScopeSummary);
            statusMessage(model.statusMessage);
        }

        public final String getSearchJobIdentifier() {
            return searchJobIdentifier;
        }

        public final void setSearchJobIdentifier(String searchJobIdentifier) {
            this.searchJobIdentifier = searchJobIdentifier;
        }

        @Override
        public final Builder searchJobIdentifier(String searchJobIdentifier) {
            this.searchJobIdentifier = searchJobIdentifier;
            return this;
        }

        public final String getSearchJobArn() {
            return searchJobArn;
        }

        public final void setSearchJobArn(String searchJobArn) {
            this.searchJobArn = searchJobArn;
        }

        @Override
        public final Builder searchJobArn(String searchJobArn) {
            this.searchJobArn = searchJobArn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(SearchJobState status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getCompletionTime() {
            return completionTime;
        }

        public final void setCompletionTime(Instant completionTime) {
            this.completionTime = completionTime;
        }

        @Override
        public final Builder completionTime(Instant completionTime) {
            this.completionTime = completionTime;
            return this;
        }

        public final SearchScopeSummary.Builder getSearchScopeSummary() {
            return searchScopeSummary != null ? searchScopeSummary.toBuilder() : null;
        }

        public final void setSearchScopeSummary(SearchScopeSummary.BuilderImpl searchScopeSummary) {
            this.searchScopeSummary = searchScopeSummary != null ? searchScopeSummary.build() : null;
        }

        @Override
        public final Builder searchScopeSummary(SearchScopeSummary searchScopeSummary) {
            this.searchScopeSummary = searchScopeSummary;
            return this;
        }

        public final String getStatusMessage() {
            return statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        @Override
        public SearchJobSummary build() {
            return new SearchJobSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
