/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backupsearch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The search scope is all backup properties input into a search.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SearchScope implements SdkPojo, Serializable, ToCopyableBuilder<SearchScope.Builder, SearchScope> {
    private static final SdkField<List<String>> BACKUP_RESOURCE_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("BackupResourceTypes")
            .getter(getter(SearchScope::backupResourceTypesAsStrings))
            .setter(setter(Builder::backupResourceTypesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupResourceTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<BackupCreationTimeFilter> BACKUP_RESOURCE_CREATION_TIME_FIELD = SdkField
            .<BackupCreationTimeFilter> builder(MarshallingType.SDK_POJO)
            .memberName("BackupResourceCreationTime")
            .getter(getter(SearchScope::backupResourceCreationTime))
            .setter(setter(Builder::backupResourceCreationTime))
            .constructor(BackupCreationTimeFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupResourceCreationTime").build())
            .build();

    private static final SdkField<List<String>> SOURCE_RESOURCE_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SourceResourceArns")
            .getter(getter(SearchScope::sourceResourceArns))
            .setter(setter(Builder::sourceResourceArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceResourceArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> BACKUP_RESOURCE_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("BackupResourceArns")
            .getter(getter(SearchScope::backupResourceArns))
            .setter(setter(Builder::backupResourceArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupResourceArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> BACKUP_RESOURCE_TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("BackupResourceTags")
            .getter(getter(SearchScope::backupResourceTags))
            .setter(setter(Builder::backupResourceTags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupResourceTags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BACKUP_RESOURCE_TYPES_FIELD,
            BACKUP_RESOURCE_CREATION_TIME_FIELD, SOURCE_RESOURCE_ARNS_FIELD, BACKUP_RESOURCE_ARNS_FIELD,
            BACKUP_RESOURCE_TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<String> backupResourceTypes;

    private final BackupCreationTimeFilter backupResourceCreationTime;

    private final List<String> sourceResourceArns;

    private final List<String> backupResourceArns;

    private final Map<String, String> backupResourceTags;

    private SearchScope(BuilderImpl builder) {
        this.backupResourceTypes = builder.backupResourceTypes;
        this.backupResourceCreationTime = builder.backupResourceCreationTime;
        this.sourceResourceArns = builder.sourceResourceArns;
        this.backupResourceArns = builder.backupResourceArns;
        this.backupResourceTags = builder.backupResourceTags;
    }

    /**
     * <p>
     * The resource types included in a search.
     * </p>
     * <p>
     * Eligible resource types include S3 and EBS.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBackupResourceTypes} method.
     * </p>
     * 
     * @return The resource types included in a search.</p>
     *         <p>
     *         Eligible resource types include S3 and EBS.
     */
    public final List<ResourceType> backupResourceTypes() {
        return ResourceTypeListCopier.copyStringToEnum(backupResourceTypes);
    }

    /**
     * For responses, this returns true if the service returned a value for the BackupResourceTypes property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasBackupResourceTypes() {
        return backupResourceTypes != null && !(backupResourceTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The resource types included in a search.
     * </p>
     * <p>
     * Eligible resource types include S3 and EBS.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBackupResourceTypes} method.
     * </p>
     * 
     * @return The resource types included in a search.</p>
     *         <p>
     *         Eligible resource types include S3 and EBS.
     */
    public final List<String> backupResourceTypesAsStrings() {
        return backupResourceTypes;
    }

    /**
     * <p>
     * This is the time a backup resource was created.
     * </p>
     * 
     * @return This is the time a backup resource was created.
     */
    public final BackupCreationTimeFilter backupResourceCreationTime() {
        return backupResourceCreationTime;
    }

    /**
     * For responses, this returns true if the service returned a value for the SourceResourceArns property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSourceResourceArns() {
        return sourceResourceArns != null && !(sourceResourceArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) that uniquely identifies the source resources.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSourceResourceArns} method.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) that uniquely identifies the source resources.
     */
    public final List<String> sourceResourceArns() {
        return sourceResourceArns;
    }

    /**
     * For responses, this returns true if the service returned a value for the BackupResourceArns property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasBackupResourceArns() {
        return backupResourceArns != null && !(backupResourceArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) that uniquely identifies the backup resources.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBackupResourceArns} method.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) that uniquely identifies the backup resources.
     */
    public final List<String> backupResourceArns() {
        return backupResourceArns;
    }

    /**
     * For responses, this returns true if the service returned a value for the BackupResourceTags property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasBackupResourceTags() {
        return backupResourceTags != null && !(backupResourceTags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * These are one or more tags on the backup (recovery point).
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBackupResourceTags} method.
     * </p>
     * 
     * @return These are one or more tags on the backup (recovery point).
     */
    public final Map<String, String> backupResourceTags() {
        return backupResourceTags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasBackupResourceTypes() ? backupResourceTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(backupResourceCreationTime());
        hashCode = 31 * hashCode + Objects.hashCode(hasSourceResourceArns() ? sourceResourceArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasBackupResourceArns() ? backupResourceArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasBackupResourceTags() ? backupResourceTags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchScope)) {
            return false;
        }
        SearchScope other = (SearchScope) obj;
        return hasBackupResourceTypes() == other.hasBackupResourceTypes()
                && Objects.equals(backupResourceTypesAsStrings(), other.backupResourceTypesAsStrings())
                && Objects.equals(backupResourceCreationTime(), other.backupResourceCreationTime())
                && hasSourceResourceArns() == other.hasSourceResourceArns()
                && Objects.equals(sourceResourceArns(), other.sourceResourceArns())
                && hasBackupResourceArns() == other.hasBackupResourceArns()
                && Objects.equals(backupResourceArns(), other.backupResourceArns())
                && hasBackupResourceTags() == other.hasBackupResourceTags()
                && Objects.equals(backupResourceTags(), other.backupResourceTags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SearchScope")
                .add("BackupResourceTypes", hasBackupResourceTypes() ? backupResourceTypesAsStrings() : null)
                .add("BackupResourceCreationTime", backupResourceCreationTime())
                .add("SourceResourceArns", hasSourceResourceArns() ? sourceResourceArns() : null)
                .add("BackupResourceArns", hasBackupResourceArns() ? backupResourceArns() : null)
                .add("BackupResourceTags", hasBackupResourceTags() ? backupResourceTags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BackupResourceTypes":
            return Optional.ofNullable(clazz.cast(backupResourceTypesAsStrings()));
        case "BackupResourceCreationTime":
            return Optional.ofNullable(clazz.cast(backupResourceCreationTime()));
        case "SourceResourceArns":
            return Optional.ofNullable(clazz.cast(sourceResourceArns()));
        case "BackupResourceArns":
            return Optional.ofNullable(clazz.cast(backupResourceArns()));
        case "BackupResourceTags":
            return Optional.ofNullable(clazz.cast(backupResourceTags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("BackupResourceTypes", BACKUP_RESOURCE_TYPES_FIELD);
        map.put("BackupResourceCreationTime", BACKUP_RESOURCE_CREATION_TIME_FIELD);
        map.put("SourceResourceArns", SOURCE_RESOURCE_ARNS_FIELD);
        map.put("BackupResourceArns", BACKUP_RESOURCE_ARNS_FIELD);
        map.put("BackupResourceTags", BACKUP_RESOURCE_TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SearchScope, T> g) {
        return obj -> g.apply((SearchScope) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SearchScope> {
        /**
         * <p>
         * The resource types included in a search.
         * </p>
         * <p>
         * Eligible resource types include S3 and EBS.
         * </p>
         * 
         * @param backupResourceTypes
         *        The resource types included in a search.</p>
         *        <p>
         *        Eligible resource types include S3 and EBS.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupResourceTypesWithStrings(Collection<String> backupResourceTypes);

        /**
         * <p>
         * The resource types included in a search.
         * </p>
         * <p>
         * Eligible resource types include S3 and EBS.
         * </p>
         * 
         * @param backupResourceTypes
         *        The resource types included in a search.</p>
         *        <p>
         *        Eligible resource types include S3 and EBS.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupResourceTypesWithStrings(String... backupResourceTypes);

        /**
         * <p>
         * The resource types included in a search.
         * </p>
         * <p>
         * Eligible resource types include S3 and EBS.
         * </p>
         * 
         * @param backupResourceTypes
         *        The resource types included in a search.</p>
         *        <p>
         *        Eligible resource types include S3 and EBS.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupResourceTypes(Collection<ResourceType> backupResourceTypes);

        /**
         * <p>
         * The resource types included in a search.
         * </p>
         * <p>
         * Eligible resource types include S3 and EBS.
         * </p>
         * 
         * @param backupResourceTypes
         *        The resource types included in a search.</p>
         *        <p>
         *        Eligible resource types include S3 and EBS.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupResourceTypes(ResourceType... backupResourceTypes);

        /**
         * <p>
         * This is the time a backup resource was created.
         * </p>
         * 
         * @param backupResourceCreationTime
         *        This is the time a backup resource was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupResourceCreationTime(BackupCreationTimeFilter backupResourceCreationTime);

        /**
         * <p>
         * This is the time a backup resource was created.
         * </p>
         * This is a convenience method that creates an instance of the {@link BackupCreationTimeFilter.Builder}
         * avoiding the need to create one manually via {@link BackupCreationTimeFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BackupCreationTimeFilter.Builder#build()} is called immediately
         * and its result is passed to {@link #backupResourceCreationTime(BackupCreationTimeFilter)}.
         * 
         * @param backupResourceCreationTime
         *        a consumer that will call methods on {@link BackupCreationTimeFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #backupResourceCreationTime(BackupCreationTimeFilter)
         */
        default Builder backupResourceCreationTime(Consumer<BackupCreationTimeFilter.Builder> backupResourceCreationTime) {
            return backupResourceCreationTime(BackupCreationTimeFilter.builder().applyMutation(backupResourceCreationTime)
                    .build());
        }

        /**
         * <p>
         * The Amazon Resource Name (ARN) that uniquely identifies the source resources.
         * </p>
         * 
         * @param sourceResourceArns
         *        The Amazon Resource Name (ARN) that uniquely identifies the source resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceResourceArns(Collection<String> sourceResourceArns);

        /**
         * <p>
         * The Amazon Resource Name (ARN) that uniquely identifies the source resources.
         * </p>
         * 
         * @param sourceResourceArns
         *        The Amazon Resource Name (ARN) that uniquely identifies the source resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceResourceArns(String... sourceResourceArns);

        /**
         * <p>
         * The Amazon Resource Name (ARN) that uniquely identifies the backup resources.
         * </p>
         * 
         * @param backupResourceArns
         *        The Amazon Resource Name (ARN) that uniquely identifies the backup resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupResourceArns(Collection<String> backupResourceArns);

        /**
         * <p>
         * The Amazon Resource Name (ARN) that uniquely identifies the backup resources.
         * </p>
         * 
         * @param backupResourceArns
         *        The Amazon Resource Name (ARN) that uniquely identifies the backup resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupResourceArns(String... backupResourceArns);

        /**
         * <p>
         * These are one or more tags on the backup (recovery point).
         * </p>
         * 
         * @param backupResourceTags
         *        These are one or more tags on the backup (recovery point).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupResourceTags(Map<String, String> backupResourceTags);
    }

    static final class BuilderImpl implements Builder {
        private List<String> backupResourceTypes = DefaultSdkAutoConstructList.getInstance();

        private BackupCreationTimeFilter backupResourceCreationTime;

        private List<String> sourceResourceArns = DefaultSdkAutoConstructList.getInstance();

        private List<String> backupResourceArns = DefaultSdkAutoConstructList.getInstance();

        private Map<String, String> backupResourceTags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SearchScope model) {
            backupResourceTypesWithStrings(model.backupResourceTypes);
            backupResourceCreationTime(model.backupResourceCreationTime);
            sourceResourceArns(model.sourceResourceArns);
            backupResourceArns(model.backupResourceArns);
            backupResourceTags(model.backupResourceTags);
        }

        public final Collection<String> getBackupResourceTypes() {
            if (backupResourceTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return backupResourceTypes;
        }

        public final void setBackupResourceTypes(Collection<String> backupResourceTypes) {
            this.backupResourceTypes = ResourceTypeListCopier.copy(backupResourceTypes);
        }

        @Override
        public final Builder backupResourceTypesWithStrings(Collection<String> backupResourceTypes) {
            this.backupResourceTypes = ResourceTypeListCopier.copy(backupResourceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder backupResourceTypesWithStrings(String... backupResourceTypes) {
            backupResourceTypesWithStrings(Arrays.asList(backupResourceTypes));
            return this;
        }

        @Override
        public final Builder backupResourceTypes(Collection<ResourceType> backupResourceTypes) {
            this.backupResourceTypes = ResourceTypeListCopier.copyEnumToString(backupResourceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder backupResourceTypes(ResourceType... backupResourceTypes) {
            backupResourceTypes(Arrays.asList(backupResourceTypes));
            return this;
        }

        public final BackupCreationTimeFilter.Builder getBackupResourceCreationTime() {
            return backupResourceCreationTime != null ? backupResourceCreationTime.toBuilder() : null;
        }

        public final void setBackupResourceCreationTime(BackupCreationTimeFilter.BuilderImpl backupResourceCreationTime) {
            this.backupResourceCreationTime = backupResourceCreationTime != null ? backupResourceCreationTime.build() : null;
        }

        @Override
        public final Builder backupResourceCreationTime(BackupCreationTimeFilter backupResourceCreationTime) {
            this.backupResourceCreationTime = backupResourceCreationTime;
            return this;
        }

        public final Collection<String> getSourceResourceArns() {
            if (sourceResourceArns instanceof SdkAutoConstructList) {
                return null;
            }
            return sourceResourceArns;
        }

        public final void setSourceResourceArns(Collection<String> sourceResourceArns) {
            this.sourceResourceArns = ResourceArnListCopier.copy(sourceResourceArns);
        }

        @Override
        public final Builder sourceResourceArns(Collection<String> sourceResourceArns) {
            this.sourceResourceArns = ResourceArnListCopier.copy(sourceResourceArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourceResourceArns(String... sourceResourceArns) {
            sourceResourceArns(Arrays.asList(sourceResourceArns));
            return this;
        }

        public final Collection<String> getBackupResourceArns() {
            if (backupResourceArns instanceof SdkAutoConstructList) {
                return null;
            }
            return backupResourceArns;
        }

        public final void setBackupResourceArns(Collection<String> backupResourceArns) {
            this.backupResourceArns = RecoveryPointArnListCopier.copy(backupResourceArns);
        }

        @Override
        public final Builder backupResourceArns(Collection<String> backupResourceArns) {
            this.backupResourceArns = RecoveryPointArnListCopier.copy(backupResourceArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder backupResourceArns(String... backupResourceArns) {
            backupResourceArns(Arrays.asList(backupResourceArns));
            return this;
        }

        public final Map<String, String> getBackupResourceTags() {
            if (backupResourceTags instanceof SdkAutoConstructMap) {
                return null;
            }
            return backupResourceTags;
        }

        public final void setBackupResourceTags(Map<String, String> backupResourceTags) {
            this.backupResourceTags = TagMapCopier.copy(backupResourceTags);
        }

        @Override
        public final Builder backupResourceTags(Map<String, String> backupResourceTags) {
            this.backupResourceTags = TagMapCopier.copy(backupResourceTags);
            return this;
        }

        @Override
        public SearchScope build() {
            return new SearchScope(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
