/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backupsearch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The summary of the specified search job scope, including:
 * </p>
 * <ul>
 * <li>
 * <p>
 * TotalBackupsToScanCount, the number of recovery points returned by the search.
 * </p>
 * </li>
 * <li>
 * <p>
 * TotalItemsToScanCount, the number of items returned by the search.
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SearchScopeSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<SearchScopeSummary.Builder, SearchScopeSummary> {
    private static final SdkField<Integer> TOTAL_RECOVERY_POINTS_TO_SCAN_COUNT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("TotalRecoveryPointsToScanCount")
            .getter(getter(SearchScopeSummary::totalRecoveryPointsToScanCount))
            .setter(setter(Builder::totalRecoveryPointsToScanCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalRecoveryPointsToScanCount")
                    .build()).build();

    private static final SdkField<Long> TOTAL_ITEMS_TO_SCAN_COUNT_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("TotalItemsToScanCount").getter(getter(SearchScopeSummary::totalItemsToScanCount))
            .setter(setter(Builder::totalItemsToScanCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalItemsToScanCount").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            TOTAL_RECOVERY_POINTS_TO_SCAN_COUNT_FIELD, TOTAL_ITEMS_TO_SCAN_COUNT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer totalRecoveryPointsToScanCount;

    private final Long totalItemsToScanCount;

    private SearchScopeSummary(BuilderImpl builder) {
        this.totalRecoveryPointsToScanCount = builder.totalRecoveryPointsToScanCount;
        this.totalItemsToScanCount = builder.totalItemsToScanCount;
    }

    /**
     * <p>
     * This is the count of the total number of backups that will be scanned in a search.
     * </p>
     * 
     * @return This is the count of the total number of backups that will be scanned in a search.
     */
    public final Integer totalRecoveryPointsToScanCount() {
        return totalRecoveryPointsToScanCount;
    }

    /**
     * <p>
     * This is the count of the total number of items that will be scanned in a search.
     * </p>
     * 
     * @return This is the count of the total number of items that will be scanned in a search.
     */
    public final Long totalItemsToScanCount() {
        return totalItemsToScanCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(totalRecoveryPointsToScanCount());
        hashCode = 31 * hashCode + Objects.hashCode(totalItemsToScanCount());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchScopeSummary)) {
            return false;
        }
        SearchScopeSummary other = (SearchScopeSummary) obj;
        return Objects.equals(totalRecoveryPointsToScanCount(), other.totalRecoveryPointsToScanCount())
                && Objects.equals(totalItemsToScanCount(), other.totalItemsToScanCount());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SearchScopeSummary").add("TotalRecoveryPointsToScanCount", totalRecoveryPointsToScanCount())
                .add("TotalItemsToScanCount", totalItemsToScanCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TotalRecoveryPointsToScanCount":
            return Optional.ofNullable(clazz.cast(totalRecoveryPointsToScanCount()));
        case "TotalItemsToScanCount":
            return Optional.ofNullable(clazz.cast(totalItemsToScanCount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TotalRecoveryPointsToScanCount", TOTAL_RECOVERY_POINTS_TO_SCAN_COUNT_FIELD);
        map.put("TotalItemsToScanCount", TOTAL_ITEMS_TO_SCAN_COUNT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SearchScopeSummary, T> g) {
        return obj -> g.apply((SearchScopeSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SearchScopeSummary> {
        /**
         * <p>
         * This is the count of the total number of backups that will be scanned in a search.
         * </p>
         * 
         * @param totalRecoveryPointsToScanCount
         *        This is the count of the total number of backups that will be scanned in a search.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalRecoveryPointsToScanCount(Integer totalRecoveryPointsToScanCount);

        /**
         * <p>
         * This is the count of the total number of items that will be scanned in a search.
         * </p>
         * 
         * @param totalItemsToScanCount
         *        This is the count of the total number of items that will be scanned in a search.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalItemsToScanCount(Long totalItemsToScanCount);
    }

    static final class BuilderImpl implements Builder {
        private Integer totalRecoveryPointsToScanCount;

        private Long totalItemsToScanCount;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchScopeSummary model) {
            totalRecoveryPointsToScanCount(model.totalRecoveryPointsToScanCount);
            totalItemsToScanCount(model.totalItemsToScanCount);
        }

        public final Integer getTotalRecoveryPointsToScanCount() {
            return totalRecoveryPointsToScanCount;
        }

        public final void setTotalRecoveryPointsToScanCount(Integer totalRecoveryPointsToScanCount) {
            this.totalRecoveryPointsToScanCount = totalRecoveryPointsToScanCount;
        }

        @Override
        public final Builder totalRecoveryPointsToScanCount(Integer totalRecoveryPointsToScanCount) {
            this.totalRecoveryPointsToScanCount = totalRecoveryPointsToScanCount;
            return this;
        }

        public final Long getTotalItemsToScanCount() {
            return totalItemsToScanCount;
        }

        public final void setTotalItemsToScanCount(Long totalItemsToScanCount) {
            this.totalItemsToScanCount = totalItemsToScanCount;
        }

        @Override
        public final Builder totalItemsToScanCount(Long totalItemsToScanCount) {
            this.totalItemsToScanCount = totalItemsToScanCount;
            return this;
        }

        @Override
        public SearchScopeSummary build() {
            return new SearchScopeSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
