/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backupsearch.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartSearchJobRequest extends BackupSearchRequest implements
        ToCopyableBuilder<StartSearchJobRequest.Builder, StartSearchJobRequest> {
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(StartSearchJobRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(StartSearchJobRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> ENCRYPTION_KEY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EncryptionKeyArn").getter(getter(StartSearchJobRequest::encryptionKeyArn))
            .setter(setter(Builder::encryptionKeyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionKeyArn").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClientToken").getter(getter(StartSearchJobRequest::clientToken)).setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build()).build();

    private static final SdkField<SearchScope> SEARCH_SCOPE_FIELD = SdkField.<SearchScope> builder(MarshallingType.SDK_POJO)
            .memberName("SearchScope").getter(getter(StartSearchJobRequest::searchScope)).setter(setter(Builder::searchScope))
            .constructor(SearchScope::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SearchScope").build()).build();

    private static final SdkField<ItemFilters> ITEM_FILTERS_FIELD = SdkField.<ItemFilters> builder(MarshallingType.SDK_POJO)
            .memberName("ItemFilters").getter(getter(StartSearchJobRequest::itemFilters)).setter(setter(Builder::itemFilters))
            .constructor(ItemFilters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ItemFilters").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TAGS_FIELD, NAME_FIELD,
            ENCRYPTION_KEY_ARN_FIELD, CLIENT_TOKEN_FIELD, SEARCH_SCOPE_FIELD, ITEM_FILTERS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Map<String, String> tags;

    private final String name;

    private final String encryptionKeyArn;

    private final String clientToken;

    private final SearchScope searchScope;

    private final ItemFilters itemFilters;

    private StartSearchJobRequest(BuilderImpl builder) {
        super(builder);
        this.tags = builder.tags;
        this.name = builder.name;
        this.encryptionKeyArn = builder.encryptionKeyArn;
        this.clientToken = builder.clientToken;
        this.searchScope = builder.searchScope;
        this.itemFilters = builder.itemFilters;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * List of tags returned by the operation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return List of tags returned by the operation.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * Include alphanumeric characters to create a name for this search job.
     * </p>
     * 
     * @return Include alphanumeric characters to create a name for this search job.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The encryption key for the specified search job.
     * </p>
     * 
     * @return The encryption key for the specified search job.
     */
    public final String encryptionKeyArn() {
        return encryptionKeyArn;
    }

    /**
     * <p>
     * Include this parameter to allow multiple identical calls for idempotency.
     * </p>
     * <p>
     * A client token is valid for 8 hours after the first request that uses it is completed. After this time, any
     * request with the same token is treated as a new request.
     * </p>
     * 
     * @return Include this parameter to allow multiple identical calls for idempotency.</p>
     *         <p>
     *         A client token is valid for 8 hours after the first request that uses it is completed. After this time,
     *         any request with the same token is treated as a new request.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * This object can contain BackupResourceTypes, BackupResourceArns, BackupResourceCreationTime, BackupResourceTags,
     * and SourceResourceArns to filter the recovery points returned by the search job.
     * </p>
     * 
     * @return This object can contain BackupResourceTypes, BackupResourceArns, BackupResourceCreationTime,
     *         BackupResourceTags, and SourceResourceArns to filter the recovery points returned by the search job.
     */
    public final SearchScope searchScope() {
        return searchScope;
    }

    /**
     * <p>
     * Item Filters represent all input item properties specified when the search was created.
     * </p>
     * <p>
     * Contains either EBSItemFilters or S3ItemFilters
     * </p>
     * 
     * @return Item Filters represent all input item properties specified when the search was created.</p>
     *         <p>
     *         Contains either EBSItemFilters or S3ItemFilters
     */
    public final ItemFilters itemFilters() {
        return itemFilters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(encryptionKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(searchScope());
        hashCode = 31 * hashCode + Objects.hashCode(itemFilters());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartSearchJobRequest)) {
            return false;
        }
        StartSearchJobRequest other = (StartSearchJobRequest) obj;
        return hasTags() == other.hasTags() && Objects.equals(tags(), other.tags()) && Objects.equals(name(), other.name())
                && Objects.equals(encryptionKeyArn(), other.encryptionKeyArn())
                && Objects.equals(clientToken(), other.clientToken()) && Objects.equals(searchScope(), other.searchScope())
                && Objects.equals(itemFilters(), other.itemFilters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartSearchJobRequest").add("Tags", hasTags() ? tags() : null).add("Name", name())
                .add("EncryptionKeyArn", encryptionKeyArn()).add("ClientToken", clientToken()).add("SearchScope", searchScope())
                .add("ItemFilters", itemFilters()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "EncryptionKeyArn":
            return Optional.ofNullable(clazz.cast(encryptionKeyArn()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "SearchScope":
            return Optional.ofNullable(clazz.cast(searchScope()));
        case "ItemFilters":
            return Optional.ofNullable(clazz.cast(itemFilters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Tags", TAGS_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("EncryptionKeyArn", ENCRYPTION_KEY_ARN_FIELD);
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        map.put("SearchScope", SEARCH_SCOPE_FIELD);
        map.put("ItemFilters", ITEM_FILTERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartSearchJobRequest, T> g) {
        return obj -> g.apply((StartSearchJobRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BackupSearchRequest.Builder, SdkPojo, CopyableBuilder<Builder, StartSearchJobRequest> {
        /**
         * <p>
         * List of tags returned by the operation.
         * </p>
         * 
         * @param tags
         *        List of tags returned by the operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * Include alphanumeric characters to create a name for this search job.
         * </p>
         * 
         * @param name
         *        Include alphanumeric characters to create a name for this search job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The encryption key for the specified search job.
         * </p>
         * 
         * @param encryptionKeyArn
         *        The encryption key for the specified search job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryptionKeyArn(String encryptionKeyArn);

        /**
         * <p>
         * Include this parameter to allow multiple identical calls for idempotency.
         * </p>
         * <p>
         * A client token is valid for 8 hours after the first request that uses it is completed. After this time, any
         * request with the same token is treated as a new request.
         * </p>
         * 
         * @param clientToken
         *        Include this parameter to allow multiple identical calls for idempotency.</p>
         *        <p>
         *        A client token is valid for 8 hours after the first request that uses it is completed. After this
         *        time, any request with the same token is treated as a new request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * This object can contain BackupResourceTypes, BackupResourceArns, BackupResourceCreationTime,
         * BackupResourceTags, and SourceResourceArns to filter the recovery points returned by the search job.
         * </p>
         * 
         * @param searchScope
         *        This object can contain BackupResourceTypes, BackupResourceArns, BackupResourceCreationTime,
         *        BackupResourceTags, and SourceResourceArns to filter the recovery points returned by the search job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder searchScope(SearchScope searchScope);

        /**
         * <p>
         * This object can contain BackupResourceTypes, BackupResourceArns, BackupResourceCreationTime,
         * BackupResourceTags, and SourceResourceArns to filter the recovery points returned by the search job.
         * </p>
         * This is a convenience method that creates an instance of the {@link SearchScope.Builder} avoiding the need to
         * create one manually via {@link SearchScope#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SearchScope.Builder#build()} is called immediately and its result
         * is passed to {@link #searchScope(SearchScope)}.
         * 
         * @param searchScope
         *        a consumer that will call methods on {@link SearchScope.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #searchScope(SearchScope)
         */
        default Builder searchScope(Consumer<SearchScope.Builder> searchScope) {
            return searchScope(SearchScope.builder().applyMutation(searchScope).build());
        }

        /**
         * <p>
         * Item Filters represent all input item properties specified when the search was created.
         * </p>
         * <p>
         * Contains either EBSItemFilters or S3ItemFilters
         * </p>
         * 
         * @param itemFilters
         *        Item Filters represent all input item properties specified when the search was created.</p>
         *        <p>
         *        Contains either EBSItemFilters or S3ItemFilters
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder itemFilters(ItemFilters itemFilters);

        /**
         * <p>
         * Item Filters represent all input item properties specified when the search was created.
         * </p>
         * <p>
         * Contains either EBSItemFilters or S3ItemFilters
         * </p>
         * This is a convenience method that creates an instance of the {@link ItemFilters.Builder} avoiding the need to
         * create one manually via {@link ItemFilters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ItemFilters.Builder#build()} is called immediately and its result
         * is passed to {@link #itemFilters(ItemFilters)}.
         * 
         * @param itemFilters
         *        a consumer that will call methods on {@link ItemFilters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #itemFilters(ItemFilters)
         */
        default Builder itemFilters(Consumer<ItemFilters.Builder> itemFilters) {
            return itemFilters(ItemFilters.builder().applyMutation(itemFilters).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BackupSearchRequest.BuilderImpl implements Builder {
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private String name;

        private String encryptionKeyArn;

        private String clientToken;

        private SearchScope searchScope;

        private ItemFilters itemFilters;

        private BuilderImpl() {
        }

        private BuilderImpl(StartSearchJobRequest model) {
            super(model);
            tags(model.tags);
            name(model.name);
            encryptionKeyArn(model.encryptionKeyArn);
            clientToken(model.clientToken);
            searchScope(model.searchScope);
            itemFilters(model.itemFilters);
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getEncryptionKeyArn() {
            return encryptionKeyArn;
        }

        public final void setEncryptionKeyArn(String encryptionKeyArn) {
            this.encryptionKeyArn = encryptionKeyArn;
        }

        @Override
        public final Builder encryptionKeyArn(String encryptionKeyArn) {
            this.encryptionKeyArn = encryptionKeyArn;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final SearchScope.Builder getSearchScope() {
            return searchScope != null ? searchScope.toBuilder() : null;
        }

        public final void setSearchScope(SearchScope.BuilderImpl searchScope) {
            this.searchScope = searchScope != null ? searchScope.build() : null;
        }

        @Override
        public final Builder searchScope(SearchScope searchScope) {
            this.searchScope = searchScope;
            return this;
        }

        public final ItemFilters.Builder getItemFilters() {
            return itemFilters != null ? itemFilters.toBuilder() : null;
        }

        public final void setItemFilters(ItemFilters.BuilderImpl itemFilters) {
            this.itemFilters = itemFilters != null ? itemFilters.build() : null;
        }

        @Override
        public final Builder itemFilters(ItemFilters itemFilters) {
            this.itemFilters = itemFilters;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartSearchJobRequest build() {
            return new StartSearchJobRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
