/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backupsearch.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartSearchJobResponse extends BackupSearchResponse implements
        ToCopyableBuilder<StartSearchJobResponse.Builder, StartSearchJobResponse> {
    private static final SdkField<String> SEARCH_JOB_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SearchJobArn").getter(getter(StartSearchJobResponse::searchJobArn))
            .setter(setter(Builder::searchJobArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SearchJobArn").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(StartSearchJobResponse::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<String> SEARCH_JOB_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SearchJobIdentifier").getter(getter(StartSearchJobResponse::searchJobIdentifier))
            .setter(setter(Builder::searchJobIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SearchJobIdentifier").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SEARCH_JOB_ARN_FIELD,
            CREATION_TIME_FIELD, SEARCH_JOB_IDENTIFIER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String searchJobArn;

    private final Instant creationTime;

    private final String searchJobIdentifier;

    private StartSearchJobResponse(BuilderImpl builder) {
        super(builder);
        this.searchJobArn = builder.searchJobArn;
        this.creationTime = builder.creationTime;
        this.searchJobIdentifier = builder.searchJobIdentifier;
    }

    /**
     * <p>
     * The unique string that identifies the Amazon Resource Name (ARN) of the specified search job.
     * </p>
     * 
     * @return The unique string that identifies the Amazon Resource Name (ARN) of the specified search job.
     */
    public final String searchJobArn() {
        return searchJobArn;
    }

    /**
     * <p>
     * The date and time that a job was created, in Unix format and Coordinated Universal Time (UTC). The value of
     * <code>CompletionTime</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday,
     * January 26, 2018 12:11:30.087 AM.
     * </p>
     * 
     * @return The date and time that a job was created, in Unix format and Coordinated Universal Time (UTC). The value
     *         of <code>CompletionTime</code> is accurate to milliseconds. For example, the value 1516925490.087
     *         represents Friday, January 26, 2018 12:11:30.087 AM.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The unique string that specifies the search job.
     * </p>
     * 
     * @return The unique string that specifies the search job.
     */
    public final String searchJobIdentifier() {
        return searchJobIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(searchJobArn());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(searchJobIdentifier());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartSearchJobResponse)) {
            return false;
        }
        StartSearchJobResponse other = (StartSearchJobResponse) obj;
        return Objects.equals(searchJobArn(), other.searchJobArn()) && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(searchJobIdentifier(), other.searchJobIdentifier());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartSearchJobResponse").add("SearchJobArn", searchJobArn()).add("CreationTime", creationTime())
                .add("SearchJobIdentifier", searchJobIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SearchJobArn":
            return Optional.ofNullable(clazz.cast(searchJobArn()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "SearchJobIdentifier":
            return Optional.ofNullable(clazz.cast(searchJobIdentifier()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SearchJobArn", SEARCH_JOB_ARN_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("SearchJobIdentifier", SEARCH_JOB_IDENTIFIER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartSearchJobResponse, T> g) {
        return obj -> g.apply((StartSearchJobResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BackupSearchResponse.Builder, SdkPojo, CopyableBuilder<Builder, StartSearchJobResponse> {
        /**
         * <p>
         * The unique string that identifies the Amazon Resource Name (ARN) of the specified search job.
         * </p>
         * 
         * @param searchJobArn
         *        The unique string that identifies the Amazon Resource Name (ARN) of the specified search job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder searchJobArn(String searchJobArn);

        /**
         * <p>
         * The date and time that a job was created, in Unix format and Coordinated Universal Time (UTC). The value of
         * <code>CompletionTime</code> is accurate to milliseconds. For example, the value 1516925490.087 represents
         * Friday, January 26, 2018 12:11:30.087 AM.
         * </p>
         * 
         * @param creationTime
         *        The date and time that a job was created, in Unix format and Coordinated Universal Time (UTC). The
         *        value of <code>CompletionTime</code> is accurate to milliseconds. For example, the value
         *        1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The unique string that specifies the search job.
         * </p>
         * 
         * @param searchJobIdentifier
         *        The unique string that specifies the search job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder searchJobIdentifier(String searchJobIdentifier);
    }

    static final class BuilderImpl extends BackupSearchResponse.BuilderImpl implements Builder {
        private String searchJobArn;

        private Instant creationTime;

        private String searchJobIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(StartSearchJobResponse model) {
            super(model);
            searchJobArn(model.searchJobArn);
            creationTime(model.creationTime);
            searchJobIdentifier(model.searchJobIdentifier);
        }

        public final String getSearchJobArn() {
            return searchJobArn;
        }

        public final void setSearchJobArn(String searchJobArn) {
            this.searchJobArn = searchJobArn;
        }

        @Override
        public final Builder searchJobArn(String searchJobArn) {
            this.searchJobArn = searchJobArn;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getSearchJobIdentifier() {
            return searchJobIdentifier;
        }

        public final void setSearchJobIdentifier(String searchJobIdentifier) {
            this.searchJobIdentifier = searchJobIdentifier;
        }

        @Override
        public final Builder searchJobIdentifier(String searchJobIdentifier) {
            this.searchJobIdentifier = searchJobIdentifier;
            return this;
        }

        @Override
        public StartSearchJobResponse build() {
            return new StartSearchJobResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
