/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backupsearch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.backupsearch.model.EBSItemFilter;
import software.amazon.awssdk.services.backupsearch.model.EBSItemFiltersCopier;
import software.amazon.awssdk.services.backupsearch.model.S3ItemFilter;
import software.amazon.awssdk.services.backupsearch.model.S3ItemFiltersCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ItemFilters
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ItemFilters> {
    private static final SdkField<List<S3ItemFilter>> S3_ITEM_FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("S3ItemFilters").getter(ItemFilters.getter(ItemFilters::s3ItemFilters)).setter(ItemFilters.setter(Builder::s3ItemFilters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3ItemFilters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(S3ItemFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<EBSItemFilter>> EBS_ITEM_FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EBSItemFilters").getter(ItemFilters.getter(ItemFilters::ebsItemFilters)).setter(ItemFilters.setter(Builder::ebsItemFilters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EBSItemFilters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EBSItemFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_ITEM_FILTERS_FIELD, EBS_ITEM_FILTERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ItemFilters.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<S3ItemFilter> s3ItemFilters;
    private final List<EBSItemFilter> ebsItemFilters;

    private ItemFilters(BuilderImpl builder) {
        this.s3ItemFilters = builder.s3ItemFilters;
        this.ebsItemFilters = builder.ebsItemFilters;
    }

    public final boolean hasS3ItemFilters() {
        return this.s3ItemFilters != null && !(this.s3ItemFilters instanceof SdkAutoConstructList);
    }

    public final List<S3ItemFilter> s3ItemFilters() {
        return this.s3ItemFilters;
    }

    public final boolean hasEbsItemFilters() {
        return this.ebsItemFilters != null && !(this.ebsItemFilters instanceof SdkAutoConstructList);
    }

    public final List<EBSItemFilter> ebsItemFilters() {
        return this.ebsItemFilters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasS3ItemFilters() ? this.s3ItemFilters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEbsItemFilters() ? this.ebsItemFilters() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ItemFilters)) {
            return false;
        }
        ItemFilters other = (ItemFilters)obj;
        return this.hasS3ItemFilters() == other.hasS3ItemFilters() && Objects.equals(this.s3ItemFilters(), other.s3ItemFilters()) && this.hasEbsItemFilters() == other.hasEbsItemFilters() && Objects.equals(this.ebsItemFilters(), other.ebsItemFilters());
    }

    public final String toString() {
        return ToString.builder((String)"ItemFilters").add("S3ItemFilters", this.hasS3ItemFilters() ? this.s3ItemFilters() : null).add("EBSItemFilters", this.hasEbsItemFilters() ? this.ebsItemFilters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "S3ItemFilters": {
                return Optional.ofNullable(clazz.cast(this.s3ItemFilters()));
            }
            case "EBSItemFilters": {
                return Optional.ofNullable(clazz.cast(this.ebsItemFilters()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("S3ItemFilters", S3_ITEM_FILTERS_FIELD);
        map.put("EBSItemFilters", EBS_ITEM_FILTERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ItemFilters, T> g) {
        return obj -> g.apply((ItemFilters)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<S3ItemFilter> s3ItemFilters = DefaultSdkAutoConstructList.getInstance();
        private List<EBSItemFilter> ebsItemFilters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ItemFilters model) {
            this.s3ItemFilters(model.s3ItemFilters);
            this.ebsItemFilters(model.ebsItemFilters);
        }

        public final List<S3ItemFilter.Builder> getS3ItemFilters() {
            List<S3ItemFilter.Builder> result = S3ItemFiltersCopier.copyToBuilder(this.s3ItemFilters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setS3ItemFilters(Collection<S3ItemFilter.BuilderImpl> s3ItemFilters) {
            this.s3ItemFilters = S3ItemFiltersCopier.copyFromBuilder(s3ItemFilters);
        }

        @Override
        public final Builder s3ItemFilters(Collection<S3ItemFilter> s3ItemFilters) {
            this.s3ItemFilters = S3ItemFiltersCopier.copy(s3ItemFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder s3ItemFilters(S3ItemFilter ... s3ItemFilters) {
            this.s3ItemFilters(Arrays.asList(s3ItemFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder s3ItemFilters(Consumer<S3ItemFilter.Builder> ... s3ItemFilters) {
            this.s3ItemFilters(Stream.of(s3ItemFilters).map(c -> (S3ItemFilter)((S3ItemFilter.Builder)S3ItemFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<EBSItemFilter.Builder> getEbsItemFilters() {
            List<EBSItemFilter.Builder> result = EBSItemFiltersCopier.copyToBuilder(this.ebsItemFilters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEbsItemFilters(Collection<EBSItemFilter.BuilderImpl> ebsItemFilters) {
            this.ebsItemFilters = EBSItemFiltersCopier.copyFromBuilder(ebsItemFilters);
        }

        @Override
        public final Builder ebsItemFilters(Collection<EBSItemFilter> ebsItemFilters) {
            this.ebsItemFilters = EBSItemFiltersCopier.copy(ebsItemFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ebsItemFilters(EBSItemFilter ... ebsItemFilters) {
            this.ebsItemFilters(Arrays.asList(ebsItemFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ebsItemFilters(Consumer<EBSItemFilter.Builder> ... ebsItemFilters) {
            this.ebsItemFilters(Stream.of(ebsItemFilters).map(c -> (EBSItemFilter)((EBSItemFilter.Builder)EBSItemFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public ItemFilters build() {
            return new ItemFilters(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ItemFilters> {
        public Builder s3ItemFilters(Collection<S3ItemFilter> var1);

        public Builder s3ItemFilters(S3ItemFilter ... var1);

        public Builder s3ItemFilters(Consumer<S3ItemFilter.Builder> ... var1);

        public Builder ebsItemFilters(Collection<EBSItemFilter> var1);

        public Builder ebsItemFilters(EBSItemFilter ... var1);

        public Builder ebsItemFilters(Consumer<EBSItemFilter.Builder> ... var1);
    }
}

