/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backupsearch.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.backupsearch.model.BackupSearchRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetSearchResultExportJobRequest
extends BackupSearchRequest
implements ToCopyableBuilder<Builder, GetSearchResultExportJobRequest> {
    private static final SdkField<String> EXPORT_JOB_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExportJobIdentifier").getter(GetSearchResultExportJobRequest.getter(GetSearchResultExportJobRequest::exportJobIdentifier)).setter(GetSearchResultExportJobRequest.setter(Builder::exportJobIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("ExportJobIdentifier").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPORT_JOB_IDENTIFIER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetSearchResultExportJobRequest.memberNameToFieldInitializer();
    private final String exportJobIdentifier;

    private GetSearchResultExportJobRequest(BuilderImpl builder) {
        super(builder);
        this.exportJobIdentifier = builder.exportJobIdentifier;
    }

    public final String exportJobIdentifier() {
        return this.exportJobIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.exportJobIdentifier());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSearchResultExportJobRequest)) {
            return false;
        }
        GetSearchResultExportJobRequest other = (GetSearchResultExportJobRequest)((Object)obj);
        return Objects.equals(this.exportJobIdentifier(), other.exportJobIdentifier());
    }

    public final String toString() {
        return ToString.builder((String)"GetSearchResultExportJobRequest").add("ExportJobIdentifier", (Object)this.exportJobIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ExportJobIdentifier": {
                return Optional.ofNullable(clazz.cast(this.exportJobIdentifier()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("ExportJobIdentifier", EXPORT_JOB_IDENTIFIER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetSearchResultExportJobRequest, T> g) {
        return obj -> g.apply((GetSearchResultExportJobRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BackupSearchRequest.BuilderImpl
    implements Builder {
        private String exportJobIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSearchResultExportJobRequest model) {
            super(model);
            this.exportJobIdentifier(model.exportJobIdentifier);
        }

        public final String getExportJobIdentifier() {
            return this.exportJobIdentifier;
        }

        public final void setExportJobIdentifier(String exportJobIdentifier) {
            this.exportJobIdentifier = exportJobIdentifier;
        }

        @Override
        public final Builder exportJobIdentifier(String exportJobIdentifier) {
            this.exportJobIdentifier = exportJobIdentifier;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetSearchResultExportJobRequest build() {
            return new GetSearchResultExportJobRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BackupSearchRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetSearchResultExportJobRequest> {
        public Builder exportJobIdentifier(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

