/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backupsearch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This specification contains a required string of the destination bucket; optionally, you can include the destination
 * prefix.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class S3ExportSpecification implements SdkPojo, Serializable,
        ToCopyableBuilder<S3ExportSpecification.Builder, S3ExportSpecification> {
    private static final SdkField<String> DESTINATION_BUCKET_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DestinationBucket").getter(getter(S3ExportSpecification::destinationBucket))
            .setter(setter(Builder::destinationBucket))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationBucket").build()).build();

    private static final SdkField<String> DESTINATION_PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DestinationPrefix").getter(getter(S3ExportSpecification::destinationPrefix))
            .setter(setter(Builder::destinationPrefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationPrefix").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESTINATION_BUCKET_FIELD,
            DESTINATION_PREFIX_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String destinationBucket;

    private final String destinationPrefix;

    private S3ExportSpecification(BuilderImpl builder) {
        this.destinationBucket = builder.destinationBucket;
        this.destinationPrefix = builder.destinationPrefix;
    }

    /**
     * <p>
     * This specifies the destination Amazon S3 bucket for the export job.
     * </p>
     * 
     * @return This specifies the destination Amazon S3 bucket for the export job.
     */
    public final String destinationBucket() {
        return destinationBucket;
    }

    /**
     * <p>
     * This specifies the prefix for the destination Amazon S3 bucket for the export job.
     * </p>
     * 
     * @return This specifies the prefix for the destination Amazon S3 bucket for the export job.
     */
    public final String destinationPrefix() {
        return destinationPrefix;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(destinationBucket());
        hashCode = 31 * hashCode + Objects.hashCode(destinationPrefix());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3ExportSpecification)) {
            return false;
        }
        S3ExportSpecification other = (S3ExportSpecification) obj;
        return Objects.equals(destinationBucket(), other.destinationBucket())
                && Objects.equals(destinationPrefix(), other.destinationPrefix());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("S3ExportSpecification").add("DestinationBucket", destinationBucket())
                .add("DestinationPrefix", destinationPrefix()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DestinationBucket":
            return Optional.ofNullable(clazz.cast(destinationBucket()));
        case "DestinationPrefix":
            return Optional.ofNullable(clazz.cast(destinationPrefix()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DestinationBucket", DESTINATION_BUCKET_FIELD);
        map.put("DestinationPrefix", DESTINATION_PREFIX_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<S3ExportSpecification, T> g) {
        return obj -> g.apply((S3ExportSpecification) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, S3ExportSpecification> {
        /**
         * <p>
         * This specifies the destination Amazon S3 bucket for the export job.
         * </p>
         * 
         * @param destinationBucket
         *        This specifies the destination Amazon S3 bucket for the export job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationBucket(String destinationBucket);

        /**
         * <p>
         * This specifies the prefix for the destination Amazon S3 bucket for the export job.
         * </p>
         * 
         * @param destinationPrefix
         *        This specifies the prefix for the destination Amazon S3 bucket for the export job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationPrefix(String destinationPrefix);
    }

    static final class BuilderImpl implements Builder {
        private String destinationBucket;

        private String destinationPrefix;

        private BuilderImpl() {
        }

        private BuilderImpl(S3ExportSpecification model) {
            destinationBucket(model.destinationBucket);
            destinationPrefix(model.destinationPrefix);
        }

        public final String getDestinationBucket() {
            return destinationBucket;
        }

        public final void setDestinationBucket(String destinationBucket) {
            this.destinationBucket = destinationBucket;
        }

        @Override
        public final Builder destinationBucket(String destinationBucket) {
            this.destinationBucket = destinationBucket;
            return this;
        }

        public final String getDestinationPrefix() {
            return destinationPrefix;
        }

        public final void setDestinationPrefix(String destinationPrefix) {
            this.destinationPrefix = destinationPrefix;
        }

        @Override
        public final Builder destinationPrefix(String destinationPrefix) {
            this.destinationPrefix = destinationPrefix;
            return this;
        }

        @Override
        public S3ExportSpecification build() {
            return new S3ExportSpecification(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
