/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backupsearch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This contains arrays of objects, which may include ObjectKeys, Sizes, CreationTimes, VersionIds, and/or Etags.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class S3ItemFilter implements SdkPojo, Serializable, ToCopyableBuilder<S3ItemFilter.Builder, S3ItemFilter> {
    private static final SdkField<List<StringCondition>> OBJECT_KEYS_FIELD = SdkField
            .<List<StringCondition>> builder(MarshallingType.LIST)
            .memberName("ObjectKeys")
            .getter(getter(S3ItemFilter::objectKeys))
            .setter(setter(Builder::objectKeys))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ObjectKeys").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StringCondition> builder(MarshallingType.SDK_POJO)
                                            .constructor(StringCondition::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<LongCondition>> SIZES_FIELD = SdkField
            .<List<LongCondition>> builder(MarshallingType.LIST)
            .memberName("Sizes")
            .getter(getter(S3ItemFilter::sizes))
            .setter(setter(Builder::sizes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sizes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<LongCondition> builder(MarshallingType.SDK_POJO)
                                            .constructor(LongCondition::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<TimeCondition>> CREATION_TIMES_FIELD = SdkField
            .<List<TimeCondition>> builder(MarshallingType.LIST)
            .memberName("CreationTimes")
            .getter(getter(S3ItemFilter::creationTimes))
            .setter(setter(Builder::creationTimes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTimes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TimeCondition> builder(MarshallingType.SDK_POJO)
                                            .constructor(TimeCondition::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<StringCondition>> VERSION_IDS_FIELD = SdkField
            .<List<StringCondition>> builder(MarshallingType.LIST)
            .memberName("VersionIds")
            .getter(getter(S3ItemFilter::versionIds))
            .setter(setter(Builder::versionIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StringCondition> builder(MarshallingType.SDK_POJO)
                                            .constructor(StringCondition::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<StringCondition>> E_TAGS_FIELD = SdkField
            .<List<StringCondition>> builder(MarshallingType.LIST)
            .memberName("ETags")
            .getter(getter(S3ItemFilter::eTags))
            .setter(setter(Builder::eTags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ETags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StringCondition> builder(MarshallingType.SDK_POJO)
                                            .constructor(StringCondition::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OBJECT_KEYS_FIELD,
            SIZES_FIELD, CREATION_TIMES_FIELD, VERSION_IDS_FIELD, E_TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<StringCondition> objectKeys;

    private final List<LongCondition> sizes;

    private final List<TimeCondition> creationTimes;

    private final List<StringCondition> versionIds;

    private final List<StringCondition> eTags;

    private S3ItemFilter(BuilderImpl builder) {
        this.objectKeys = builder.objectKeys;
        this.sizes = builder.sizes;
        this.creationTimes = builder.creationTimes;
        this.versionIds = builder.versionIds;
        this.eTags = builder.eTags;
    }

    /**
     * For responses, this returns true if the service returned a value for the ObjectKeys property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasObjectKeys() {
        return objectKeys != null && !(objectKeys instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * You can include 1 to 10 values.
     * </p>
     * <p>
     * If one value is included, the results will return only items that match the value.
     * </p>
     * <p>
     * If more than one value is included, the results will return all items that match any of the values.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasObjectKeys} method.
     * </p>
     * 
     * @return You can include 1 to 10 values.</p>
     *         <p>
     *         If one value is included, the results will return only items that match the value.
     *         </p>
     *         <p>
     *         If more than one value is included, the results will return all items that match any of the values.
     */
    public final List<StringCondition> objectKeys() {
        return objectKeys;
    }

    /**
     * For responses, this returns true if the service returned a value for the Sizes property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasSizes() {
        return sizes != null && !(sizes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * You can include 1 to 10 values.
     * </p>
     * <p>
     * If one value is included, the results will return only items that match the value.
     * </p>
     * <p>
     * If more than one value is included, the results will return all items that match any of the values.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSizes} method.
     * </p>
     * 
     * @return You can include 1 to 10 values.</p>
     *         <p>
     *         If one value is included, the results will return only items that match the value.
     *         </p>
     *         <p>
     *         If more than one value is included, the results will return all items that match any of the values.
     */
    public final List<LongCondition> sizes() {
        return sizes;
    }

    /**
     * For responses, this returns true if the service returned a value for the CreationTimes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCreationTimes() {
        return creationTimes != null && !(creationTimes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * You can include 1 to 10 values.
     * </p>
     * <p>
     * If one value is included, the results will return only items that match the value.
     * </p>
     * <p>
     * If more than one value is included, the results will return all items that match any of the values.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCreationTimes} method.
     * </p>
     * 
     * @return You can include 1 to 10 values.</p>
     *         <p>
     *         If one value is included, the results will return only items that match the value.
     *         </p>
     *         <p>
     *         If more than one value is included, the results will return all items that match any of the values.
     */
    public final List<TimeCondition> creationTimes() {
        return creationTimes;
    }

    /**
     * For responses, this returns true if the service returned a value for the VersionIds property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasVersionIds() {
        return versionIds != null && !(versionIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * You can include 1 to 10 values.
     * </p>
     * <p>
     * If one value is included, the results will return only items that match the value.
     * </p>
     * <p>
     * If more than one value is included, the results will return all items that match any of the values.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasVersionIds} method.
     * </p>
     * 
     * @return You can include 1 to 10 values.</p>
     *         <p>
     *         If one value is included, the results will return only items that match the value.
     *         </p>
     *         <p>
     *         If more than one value is included, the results will return all items that match any of the values.
     */
    public final List<StringCondition> versionIds() {
        return versionIds;
    }

    /**
     * For responses, this returns true if the service returned a value for the ETags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasETags() {
        return eTags != null && !(eTags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * You can include 1 to 10 values.
     * </p>
     * <p>
     * If one value is included, the results will return only items that match the value.
     * </p>
     * <p>
     * If more than one value is included, the results will return all items that match any of the values.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasETags} method.
     * </p>
     * 
     * @return You can include 1 to 10 values.</p>
     *         <p>
     *         If one value is included, the results will return only items that match the value.
     *         </p>
     *         <p>
     *         If more than one value is included, the results will return all items that match any of the values.
     */
    public final List<StringCondition> eTags() {
        return eTags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasObjectKeys() ? objectKeys() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSizes() ? sizes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasCreationTimes() ? creationTimes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasVersionIds() ? versionIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasETags() ? eTags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3ItemFilter)) {
            return false;
        }
        S3ItemFilter other = (S3ItemFilter) obj;
        return hasObjectKeys() == other.hasObjectKeys() && Objects.equals(objectKeys(), other.objectKeys())
                && hasSizes() == other.hasSizes() && Objects.equals(sizes(), other.sizes())
                && hasCreationTimes() == other.hasCreationTimes() && Objects.equals(creationTimes(), other.creationTimes())
                && hasVersionIds() == other.hasVersionIds() && Objects.equals(versionIds(), other.versionIds())
                && hasETags() == other.hasETags() && Objects.equals(eTags(), other.eTags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("S3ItemFilter").add("ObjectKeys", hasObjectKeys() ? objectKeys() : null)
                .add("Sizes", hasSizes() ? sizes() : null).add("CreationTimes", hasCreationTimes() ? creationTimes() : null)
                .add("VersionIds", hasVersionIds() ? versionIds() : null).add("ETags", hasETags() ? eTags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ObjectKeys":
            return Optional.ofNullable(clazz.cast(objectKeys()));
        case "Sizes":
            return Optional.ofNullable(clazz.cast(sizes()));
        case "CreationTimes":
            return Optional.ofNullable(clazz.cast(creationTimes()));
        case "VersionIds":
            return Optional.ofNullable(clazz.cast(versionIds()));
        case "ETags":
            return Optional.ofNullable(clazz.cast(eTags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ObjectKeys", OBJECT_KEYS_FIELD);
        map.put("Sizes", SIZES_FIELD);
        map.put("CreationTimes", CREATION_TIMES_FIELD);
        map.put("VersionIds", VERSION_IDS_FIELD);
        map.put("ETags", E_TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<S3ItemFilter, T> g) {
        return obj -> g.apply((S3ItemFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, S3ItemFilter> {
        /**
         * <p>
         * You can include 1 to 10 values.
         * </p>
         * <p>
         * If one value is included, the results will return only items that match the value.
         * </p>
         * <p>
         * If more than one value is included, the results will return all items that match any of the values.
         * </p>
         * 
         * @param objectKeys
         *        You can include 1 to 10 values.</p>
         *        <p>
         *        If one value is included, the results will return only items that match the value.
         *        </p>
         *        <p>
         *        If more than one value is included, the results will return all items that match any of the values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder objectKeys(Collection<StringCondition> objectKeys);

        /**
         * <p>
         * You can include 1 to 10 values.
         * </p>
         * <p>
         * If one value is included, the results will return only items that match the value.
         * </p>
         * <p>
         * If more than one value is included, the results will return all items that match any of the values.
         * </p>
         * 
         * @param objectKeys
         *        You can include 1 to 10 values.</p>
         *        <p>
         *        If one value is included, the results will return only items that match the value.
         *        </p>
         *        <p>
         *        If more than one value is included, the results will return all items that match any of the values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder objectKeys(StringCondition... objectKeys);

        /**
         * <p>
         * You can include 1 to 10 values.
         * </p>
         * <p>
         * If one value is included, the results will return only items that match the value.
         * </p>
         * <p>
         * If more than one value is included, the results will return all items that match any of the values.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.backupsearch.model.StringCondition.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.backupsearch.model.StringCondition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.backupsearch.model.StringCondition.Builder#build()} is called
         * immediately and its result is passed to {@link #objectKeys(List<StringCondition>)}.
         * 
         * @param objectKeys
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.backupsearch.model.StringCondition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #objectKeys(java.util.Collection<StringCondition>)
         */
        Builder objectKeys(Consumer<StringCondition.Builder>... objectKeys);

        /**
         * <p>
         * You can include 1 to 10 values.
         * </p>
         * <p>
         * If one value is included, the results will return only items that match the value.
         * </p>
         * <p>
         * If more than one value is included, the results will return all items that match any of the values.
         * </p>
         * 
         * @param sizes
         *        You can include 1 to 10 values.</p>
         *        <p>
         *        If one value is included, the results will return only items that match the value.
         *        </p>
         *        <p>
         *        If more than one value is included, the results will return all items that match any of the values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sizes(Collection<LongCondition> sizes);

        /**
         * <p>
         * You can include 1 to 10 values.
         * </p>
         * <p>
         * If one value is included, the results will return only items that match the value.
         * </p>
         * <p>
         * If more than one value is included, the results will return all items that match any of the values.
         * </p>
         * 
         * @param sizes
         *        You can include 1 to 10 values.</p>
         *        <p>
         *        If one value is included, the results will return only items that match the value.
         *        </p>
         *        <p>
         *        If more than one value is included, the results will return all items that match any of the values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sizes(LongCondition... sizes);

        /**
         * <p>
         * You can include 1 to 10 values.
         * </p>
         * <p>
         * If one value is included, the results will return only items that match the value.
         * </p>
         * <p>
         * If more than one value is included, the results will return all items that match any of the values.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.backupsearch.model.LongCondition.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.backupsearch.model.LongCondition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.backupsearch.model.LongCondition.Builder#build()} is called
         * immediately and its result is passed to {@link #sizes(List<LongCondition>)}.
         * 
         * @param sizes
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.backupsearch.model.LongCondition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sizes(java.util.Collection<LongCondition>)
         */
        Builder sizes(Consumer<LongCondition.Builder>... sizes);

        /**
         * <p>
         * You can include 1 to 10 values.
         * </p>
         * <p>
         * If one value is included, the results will return only items that match the value.
         * </p>
         * <p>
         * If more than one value is included, the results will return all items that match any of the values.
         * </p>
         * 
         * @param creationTimes
         *        You can include 1 to 10 values.</p>
         *        <p>
         *        If one value is included, the results will return only items that match the value.
         *        </p>
         *        <p>
         *        If more than one value is included, the results will return all items that match any of the values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTimes(Collection<TimeCondition> creationTimes);

        /**
         * <p>
         * You can include 1 to 10 values.
         * </p>
         * <p>
         * If one value is included, the results will return only items that match the value.
         * </p>
         * <p>
         * If more than one value is included, the results will return all items that match any of the values.
         * </p>
         * 
         * @param creationTimes
         *        You can include 1 to 10 values.</p>
         *        <p>
         *        If one value is included, the results will return only items that match the value.
         *        </p>
         *        <p>
         *        If more than one value is included, the results will return all items that match any of the values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTimes(TimeCondition... creationTimes);

        /**
         * <p>
         * You can include 1 to 10 values.
         * </p>
         * <p>
         * If one value is included, the results will return only items that match the value.
         * </p>
         * <p>
         * If more than one value is included, the results will return all items that match any of the values.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.backupsearch.model.TimeCondition.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.backupsearch.model.TimeCondition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.backupsearch.model.TimeCondition.Builder#build()} is called
         * immediately and its result is passed to {@link #creationTimes(List<TimeCondition>)}.
         * 
         * @param creationTimes
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.backupsearch.model.TimeCondition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #creationTimes(java.util.Collection<TimeCondition>)
         */
        Builder creationTimes(Consumer<TimeCondition.Builder>... creationTimes);

        /**
         * <p>
         * You can include 1 to 10 values.
         * </p>
         * <p>
         * If one value is included, the results will return only items that match the value.
         * </p>
         * <p>
         * If more than one value is included, the results will return all items that match any of the values.
         * </p>
         * 
         * @param versionIds
         *        You can include 1 to 10 values.</p>
         *        <p>
         *        If one value is included, the results will return only items that match the value.
         *        </p>
         *        <p>
         *        If more than one value is included, the results will return all items that match any of the values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionIds(Collection<StringCondition> versionIds);

        /**
         * <p>
         * You can include 1 to 10 values.
         * </p>
         * <p>
         * If one value is included, the results will return only items that match the value.
         * </p>
         * <p>
         * If more than one value is included, the results will return all items that match any of the values.
         * </p>
         * 
         * @param versionIds
         *        You can include 1 to 10 values.</p>
         *        <p>
         *        If one value is included, the results will return only items that match the value.
         *        </p>
         *        <p>
         *        If more than one value is included, the results will return all items that match any of the values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionIds(StringCondition... versionIds);

        /**
         * <p>
         * You can include 1 to 10 values.
         * </p>
         * <p>
         * If one value is included, the results will return only items that match the value.
         * </p>
         * <p>
         * If more than one value is included, the results will return all items that match any of the values.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.backupsearch.model.StringCondition.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.backupsearch.model.StringCondition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.backupsearch.model.StringCondition.Builder#build()} is called
         * immediately and its result is passed to {@link #versionIds(List<StringCondition>)}.
         * 
         * @param versionIds
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.backupsearch.model.StringCondition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #versionIds(java.util.Collection<StringCondition>)
         */
        Builder versionIds(Consumer<StringCondition.Builder>... versionIds);

        /**
         * <p>
         * You can include 1 to 10 values.
         * </p>
         * <p>
         * If one value is included, the results will return only items that match the value.
         * </p>
         * <p>
         * If more than one value is included, the results will return all items that match any of the values.
         * </p>
         * 
         * @param eTags
         *        You can include 1 to 10 values.</p>
         *        <p>
         *        If one value is included, the results will return only items that match the value.
         *        </p>
         *        <p>
         *        If more than one value is included, the results will return all items that match any of the values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eTags(Collection<StringCondition> eTags);

        /**
         * <p>
         * You can include 1 to 10 values.
         * </p>
         * <p>
         * If one value is included, the results will return only items that match the value.
         * </p>
         * <p>
         * If more than one value is included, the results will return all items that match any of the values.
         * </p>
         * 
         * @param eTags
         *        You can include 1 to 10 values.</p>
         *        <p>
         *        If one value is included, the results will return only items that match the value.
         *        </p>
         *        <p>
         *        If more than one value is included, the results will return all items that match any of the values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eTags(StringCondition... eTags);

        /**
         * <p>
         * You can include 1 to 10 values.
         * </p>
         * <p>
         * If one value is included, the results will return only items that match the value.
         * </p>
         * <p>
         * If more than one value is included, the results will return all items that match any of the values.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.backupsearch.model.StringCondition.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.backupsearch.model.StringCondition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.backupsearch.model.StringCondition.Builder#build()} is called
         * immediately and its result is passed to {@link #eTags(List<StringCondition>)}.
         * 
         * @param eTags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.backupsearch.model.StringCondition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #eTags(java.util.Collection<StringCondition>)
         */
        Builder eTags(Consumer<StringCondition.Builder>... eTags);
    }

    static final class BuilderImpl implements Builder {
        private List<StringCondition> objectKeys = DefaultSdkAutoConstructList.getInstance();

        private List<LongCondition> sizes = DefaultSdkAutoConstructList.getInstance();

        private List<TimeCondition> creationTimes = DefaultSdkAutoConstructList.getInstance();

        private List<StringCondition> versionIds = DefaultSdkAutoConstructList.getInstance();

        private List<StringCondition> eTags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(S3ItemFilter model) {
            objectKeys(model.objectKeys);
            sizes(model.sizes);
            creationTimes(model.creationTimes);
            versionIds(model.versionIds);
            eTags(model.eTags);
        }

        public final List<StringCondition.Builder> getObjectKeys() {
            List<StringCondition.Builder> result = StringConditionListCopier.copyToBuilder(this.objectKeys);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setObjectKeys(Collection<StringCondition.BuilderImpl> objectKeys) {
            this.objectKeys = StringConditionListCopier.copyFromBuilder(objectKeys);
        }

        @Override
        public final Builder objectKeys(Collection<StringCondition> objectKeys) {
            this.objectKeys = StringConditionListCopier.copy(objectKeys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder objectKeys(StringCondition... objectKeys) {
            objectKeys(Arrays.asList(objectKeys));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder objectKeys(Consumer<StringCondition.Builder>... objectKeys) {
            objectKeys(Stream.of(objectKeys).map(c -> StringCondition.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<LongCondition.Builder> getSizes() {
            List<LongCondition.Builder> result = LongConditionListCopier.copyToBuilder(this.sizes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSizes(Collection<LongCondition.BuilderImpl> sizes) {
            this.sizes = LongConditionListCopier.copyFromBuilder(sizes);
        }

        @Override
        public final Builder sizes(Collection<LongCondition> sizes) {
            this.sizes = LongConditionListCopier.copy(sizes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sizes(LongCondition... sizes) {
            sizes(Arrays.asList(sizes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sizes(Consumer<LongCondition.Builder>... sizes) {
            sizes(Stream.of(sizes).map(c -> LongCondition.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<TimeCondition.Builder> getCreationTimes() {
            List<TimeCondition.Builder> result = TimeConditionListCopier.copyToBuilder(this.creationTimes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCreationTimes(Collection<TimeCondition.BuilderImpl> creationTimes) {
            this.creationTimes = TimeConditionListCopier.copyFromBuilder(creationTimes);
        }

        @Override
        public final Builder creationTimes(Collection<TimeCondition> creationTimes) {
            this.creationTimes = TimeConditionListCopier.copy(creationTimes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder creationTimes(TimeCondition... creationTimes) {
            creationTimes(Arrays.asList(creationTimes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder creationTimes(Consumer<TimeCondition.Builder>... creationTimes) {
            creationTimes(Stream.of(creationTimes).map(c -> TimeCondition.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<StringCondition.Builder> getVersionIds() {
            List<StringCondition.Builder> result = StringConditionListCopier.copyToBuilder(this.versionIds);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVersionIds(Collection<StringCondition.BuilderImpl> versionIds) {
            this.versionIds = StringConditionListCopier.copyFromBuilder(versionIds);
        }

        @Override
        public final Builder versionIds(Collection<StringCondition> versionIds) {
            this.versionIds = StringConditionListCopier.copy(versionIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder versionIds(StringCondition... versionIds) {
            versionIds(Arrays.asList(versionIds));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder versionIds(Consumer<StringCondition.Builder>... versionIds) {
            versionIds(Stream.of(versionIds).map(c -> StringCondition.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<StringCondition.Builder> getETags() {
            List<StringCondition.Builder> result = StringConditionListCopier.copyToBuilder(this.eTags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setETags(Collection<StringCondition.BuilderImpl> eTags) {
            this.eTags = StringConditionListCopier.copyFromBuilder(eTags);
        }

        @Override
        public final Builder eTags(Collection<StringCondition> eTags) {
            this.eTags = StringConditionListCopier.copy(eTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eTags(StringCondition... eTags) {
            eTags(Arrays.asList(eTags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eTags(Consumer<StringCondition.Builder>... eTags) {
            eTags(Stream.of(eTags).map(c -> StringCondition.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public S3ItemFilter build() {
            return new S3ItemFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
