/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backupsearch.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * These are the items returned in the results of a search of Amazon S3 backup metadata.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class S3ResultItem implements SdkPojo, Serializable, ToCopyableBuilder<S3ResultItem.Builder, S3ResultItem> {
    private static final SdkField<String> BACKUP_RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BackupResourceArn").getter(getter(S3ResultItem::backupResourceArn))
            .setter(setter(Builder::backupResourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupResourceArn").build()).build();

    private static final SdkField<String> SOURCE_RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceResourceArn").getter(getter(S3ResultItem::sourceResourceArn))
            .setter(setter(Builder::sourceResourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceResourceArn").build()).build();

    private static final SdkField<String> BACKUP_VAULT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BackupVaultName").getter(getter(S3ResultItem::backupVaultName)).setter(setter(Builder::backupVaultName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupVaultName").build()).build();

    private static final SdkField<String> OBJECT_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ObjectKey").getter(getter(S3ResultItem::objectKey)).setter(setter(Builder::objectKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ObjectKey").build()).build();

    private static final SdkField<Long> OBJECT_SIZE_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("ObjectSize").getter(getter(S3ResultItem::objectSize)).setter(setter(Builder::objectSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ObjectSize").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(S3ResultItem::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<String> E_TAG_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("ETag")
            .getter(getter(S3ResultItem::eTag)).setter(setter(Builder::eTag))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ETag").build()).build();

    private static final SdkField<String> VERSION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VersionId").getter(getter(S3ResultItem::versionId)).setter(setter(Builder::versionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BACKUP_RESOURCE_ARN_FIELD,
            SOURCE_RESOURCE_ARN_FIELD, BACKUP_VAULT_NAME_FIELD, OBJECT_KEY_FIELD, OBJECT_SIZE_FIELD, CREATION_TIME_FIELD,
            E_TAG_FIELD, VERSION_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String backupResourceArn;

    private final String sourceResourceArn;

    private final String backupVaultName;

    private final String objectKey;

    private final Long objectSize;

    private final Instant creationTime;

    private final String eTag;

    private final String versionId;

    private S3ResultItem(BuilderImpl builder) {
        this.backupResourceArn = builder.backupResourceArn;
        this.sourceResourceArn = builder.sourceResourceArn;
        this.backupVaultName = builder.backupVaultName;
        this.objectKey = builder.objectKey;
        this.objectSize = builder.objectSize;
        this.creationTime = builder.creationTime;
        this.eTag = builder.eTag;
        this.versionId = builder.versionId;
    }

    /**
     * <p>
     * These are items in the returned results that match recovery point Amazon Resource Names (ARN) input during a
     * search of Amazon S3 backup metadata.
     * </p>
     * 
     * @return These are items in the returned results that match recovery point Amazon Resource Names (ARN) input
     *         during a search of Amazon S3 backup metadata.
     */
    public final String backupResourceArn() {
        return backupResourceArn;
    }

    /**
     * <p>
     * These are items in the returned results that match source Amazon Resource Names (ARN) input during a search of
     * Amazon S3 backup metadata.
     * </p>
     * 
     * @return These are items in the returned results that match source Amazon Resource Names (ARN) input during a
     *         search of Amazon S3 backup metadata.
     */
    public final String sourceResourceArn() {
        return sourceResourceArn;
    }

    /**
     * <p>
     * The name of the backup vault.
     * </p>
     * 
     * @return The name of the backup vault.
     */
    public final String backupVaultName() {
        return backupVaultName;
    }

    /**
     * <p>
     * This is one or more items returned in the results of a search of Amazon S3 backup metadata that match the values
     * input for object key.
     * </p>
     * 
     * @return This is one or more items returned in the results of a search of Amazon S3 backup metadata that match the
     *         values input for object key.
     */
    public final String objectKey() {
        return objectKey;
    }

    /**
     * <p>
     * These are items in the returned results that match values for object size(s) input during a search of Amazon S3
     * backup metadata.
     * </p>
     * 
     * @return These are items in the returned results that match values for object size(s) input during a search of
     *         Amazon S3 backup metadata.
     */
    public final Long objectSize() {
        return objectSize;
    }

    /**
     * <p>
     * These are one or more items in the returned results that match values for item creation time input during a
     * search of Amazon S3 backup metadata.
     * </p>
     * 
     * @return These are one or more items in the returned results that match values for item creation time input during
     *         a search of Amazon S3 backup metadata.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * These are one or more items in the returned results that match values for ETags input during a search of Amazon
     * S3 backup metadata.
     * </p>
     * 
     * @return These are one or more items in the returned results that match values for ETags input during a search of
     *         Amazon S3 backup metadata.
     */
    public final String eTag() {
        return eTag;
    }

    /**
     * <p>
     * These are one or more items in the returned results that match values for version IDs input during a search of
     * Amazon S3 backup metadata.
     * </p>
     * 
     * @return These are one or more items in the returned results that match values for version IDs input during a
     *         search of Amazon S3 backup metadata.
     */
    public final String versionId() {
        return versionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(backupResourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(sourceResourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(backupVaultName());
        hashCode = 31 * hashCode + Objects.hashCode(objectKey());
        hashCode = 31 * hashCode + Objects.hashCode(objectSize());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(eTag());
        hashCode = 31 * hashCode + Objects.hashCode(versionId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3ResultItem)) {
            return false;
        }
        S3ResultItem other = (S3ResultItem) obj;
        return Objects.equals(backupResourceArn(), other.backupResourceArn())
                && Objects.equals(sourceResourceArn(), other.sourceResourceArn())
                && Objects.equals(backupVaultName(), other.backupVaultName()) && Objects.equals(objectKey(), other.objectKey())
                && Objects.equals(objectSize(), other.objectSize()) && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(eTag(), other.eTag()) && Objects.equals(versionId(), other.versionId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("S3ResultItem").add("BackupResourceArn", backupResourceArn())
                .add("SourceResourceArn", sourceResourceArn()).add("BackupVaultName", backupVaultName())
                .add("ObjectKey", objectKey() == null ? null : "*** Sensitive Data Redacted ***").add("ObjectSize", objectSize())
                .add("CreationTime", creationTime()).add("ETag", eTag()).add("VersionId", versionId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BackupResourceArn":
            return Optional.ofNullable(clazz.cast(backupResourceArn()));
        case "SourceResourceArn":
            return Optional.ofNullable(clazz.cast(sourceResourceArn()));
        case "BackupVaultName":
            return Optional.ofNullable(clazz.cast(backupVaultName()));
        case "ObjectKey":
            return Optional.ofNullable(clazz.cast(objectKey()));
        case "ObjectSize":
            return Optional.ofNullable(clazz.cast(objectSize()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "ETag":
            return Optional.ofNullable(clazz.cast(eTag()));
        case "VersionId":
            return Optional.ofNullable(clazz.cast(versionId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("BackupResourceArn", BACKUP_RESOURCE_ARN_FIELD);
        map.put("SourceResourceArn", SOURCE_RESOURCE_ARN_FIELD);
        map.put("BackupVaultName", BACKUP_VAULT_NAME_FIELD);
        map.put("ObjectKey", OBJECT_KEY_FIELD);
        map.put("ObjectSize", OBJECT_SIZE_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("ETag", E_TAG_FIELD);
        map.put("VersionId", VERSION_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<S3ResultItem, T> g) {
        return obj -> g.apply((S3ResultItem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, S3ResultItem> {
        /**
         * <p>
         * These are items in the returned results that match recovery point Amazon Resource Names (ARN) input during a
         * search of Amazon S3 backup metadata.
         * </p>
         * 
         * @param backupResourceArn
         *        These are items in the returned results that match recovery point Amazon Resource Names (ARN) input
         *        during a search of Amazon S3 backup metadata.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupResourceArn(String backupResourceArn);

        /**
         * <p>
         * These are items in the returned results that match source Amazon Resource Names (ARN) input during a search
         * of Amazon S3 backup metadata.
         * </p>
         * 
         * @param sourceResourceArn
         *        These are items in the returned results that match source Amazon Resource Names (ARN) input during a
         *        search of Amazon S3 backup metadata.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceResourceArn(String sourceResourceArn);

        /**
         * <p>
         * The name of the backup vault.
         * </p>
         * 
         * @param backupVaultName
         *        The name of the backup vault.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupVaultName(String backupVaultName);

        /**
         * <p>
         * This is one or more items returned in the results of a search of Amazon S3 backup metadata that match the
         * values input for object key.
         * </p>
         * 
         * @param objectKey
         *        This is one or more items returned in the results of a search of Amazon S3 backup metadata that match
         *        the values input for object key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder objectKey(String objectKey);

        /**
         * <p>
         * These are items in the returned results that match values for object size(s) input during a search of Amazon
         * S3 backup metadata.
         * </p>
         * 
         * @param objectSize
         *        These are items in the returned results that match values for object size(s) input during a search of
         *        Amazon S3 backup metadata.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder objectSize(Long objectSize);

        /**
         * <p>
         * These are one or more items in the returned results that match values for item creation time input during a
         * search of Amazon S3 backup metadata.
         * </p>
         * 
         * @param creationTime
         *        These are one or more items in the returned results that match values for item creation time input
         *        during a search of Amazon S3 backup metadata.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * These are one or more items in the returned results that match values for ETags input during a search of
         * Amazon S3 backup metadata.
         * </p>
         * 
         * @param eTag
         *        These are one or more items in the returned results that match values for ETags input during a search
         *        of Amazon S3 backup metadata.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eTag(String eTag);

        /**
         * <p>
         * These are one or more items in the returned results that match values for version IDs input during a search
         * of Amazon S3 backup metadata.
         * </p>
         * 
         * @param versionId
         *        These are one or more items in the returned results that match values for version IDs input during a
         *        search of Amazon S3 backup metadata.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionId(String versionId);
    }

    static final class BuilderImpl implements Builder {
        private String backupResourceArn;

        private String sourceResourceArn;

        private String backupVaultName;

        private String objectKey;

        private Long objectSize;

        private Instant creationTime;

        private String eTag;

        private String versionId;

        private BuilderImpl() {
        }

        private BuilderImpl(S3ResultItem model) {
            backupResourceArn(model.backupResourceArn);
            sourceResourceArn(model.sourceResourceArn);
            backupVaultName(model.backupVaultName);
            objectKey(model.objectKey);
            objectSize(model.objectSize);
            creationTime(model.creationTime);
            eTag(model.eTag);
            versionId(model.versionId);
        }

        public final String getBackupResourceArn() {
            return backupResourceArn;
        }

        public final void setBackupResourceArn(String backupResourceArn) {
            this.backupResourceArn = backupResourceArn;
        }

        @Override
        public final Builder backupResourceArn(String backupResourceArn) {
            this.backupResourceArn = backupResourceArn;
            return this;
        }

        public final String getSourceResourceArn() {
            return sourceResourceArn;
        }

        public final void setSourceResourceArn(String sourceResourceArn) {
            this.sourceResourceArn = sourceResourceArn;
        }

        @Override
        public final Builder sourceResourceArn(String sourceResourceArn) {
            this.sourceResourceArn = sourceResourceArn;
            return this;
        }

        public final String getBackupVaultName() {
            return backupVaultName;
        }

        public final void setBackupVaultName(String backupVaultName) {
            this.backupVaultName = backupVaultName;
        }

        @Override
        public final Builder backupVaultName(String backupVaultName) {
            this.backupVaultName = backupVaultName;
            return this;
        }

        public final String getObjectKey() {
            return objectKey;
        }

        public final void setObjectKey(String objectKey) {
            this.objectKey = objectKey;
        }

        @Override
        public final Builder objectKey(String objectKey) {
            this.objectKey = objectKey;
            return this;
        }

        public final Long getObjectSize() {
            return objectSize;
        }

        public final void setObjectSize(Long objectSize) {
            this.objectSize = objectSize;
        }

        @Override
        public final Builder objectSize(Long objectSize) {
            this.objectSize = objectSize;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getETag() {
            return eTag;
        }

        public final void setETag(String eTag) {
            this.eTag = eTag;
        }

        @Override
        public final Builder eTag(String eTag) {
            this.eTag = eTag;
            return this;
        }

        public final String getVersionId() {
            return versionId;
        }

        public final void setVersionId(String versionId) {
            this.versionId = versionId;
        }

        @Override
        public final Builder versionId(String versionId) {
            this.versionId = versionId;
            return this;
        }

        @Override
        public S3ResultItem build() {
            return new S3ResultItem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
