/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backupsearch.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This contains the information about recovery points returned in results of a search job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SearchJobBackupsResult implements SdkPojo, Serializable,
        ToCopyableBuilder<SearchJobBackupsResult.Builder, SearchJobBackupsResult> {
    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(SearchJobBackupsResult::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatusMessage").getter(getter(SearchJobBackupsResult::statusMessage))
            .setter(setter(Builder::statusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").build()).build();

    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceType").getter(getter(SearchJobBackupsResult::resourceTypeAsString))
            .setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()).build();

    private static final SdkField<String> BACKUP_RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BackupResourceArn").getter(getter(SearchJobBackupsResult::backupResourceArn))
            .setter(setter(Builder::backupResourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupResourceArn").build()).build();

    private static final SdkField<String> SOURCE_RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceResourceArn").getter(getter(SearchJobBackupsResult::sourceResourceArn))
            .setter(setter(Builder::sourceResourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceResourceArn").build()).build();

    private static final SdkField<Instant> INDEX_CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("IndexCreationTime").getter(getter(SearchJobBackupsResult::indexCreationTime))
            .setter(setter(Builder::indexCreationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexCreationTime").build()).build();

    private static final SdkField<Instant> BACKUP_CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("BackupCreationTime").getter(getter(SearchJobBackupsResult::backupCreationTime))
            .setter(setter(Builder::backupCreationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupCreationTime").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD,
            STATUS_MESSAGE_FIELD, RESOURCE_TYPE_FIELD, BACKUP_RESOURCE_ARN_FIELD, SOURCE_RESOURCE_ARN_FIELD,
            INDEX_CREATION_TIME_FIELD, BACKUP_CREATION_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String status;

    private final String statusMessage;

    private final String resourceType;

    private final String backupResourceArn;

    private final String sourceResourceArn;

    private final Instant indexCreationTime;

    private final Instant backupCreationTime;

    private SearchJobBackupsResult(BuilderImpl builder) {
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
        this.resourceType = builder.resourceType;
        this.backupResourceArn = builder.backupResourceArn;
        this.sourceResourceArn = builder.sourceResourceArn;
        this.indexCreationTime = builder.indexCreationTime;
        this.backupCreationTime = builder.backupCreationTime;
    }

    /**
     * <p>
     * This is the status of the search job backup result.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link SearchJobState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return This is the status of the search job backup result.
     * @see SearchJobState
     */
    public final SearchJobState status() {
        return SearchJobState.fromValue(status);
    }

    /**
     * <p>
     * This is the status of the search job backup result.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link SearchJobState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return This is the status of the search job backup result.
     * @see SearchJobState
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * This is the status message included with the results.
     * </p>
     * 
     * @return This is the status message included with the results.
     */
    public final String statusMessage() {
        return statusMessage;
    }

    /**
     * <p>
     * This is the resource type of the search.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link ResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return This is the resource type of the search.
     * @see ResourceType
     */
    public final ResourceType resourceType() {
        return ResourceType.fromValue(resourceType);
    }

    /**
     * <p>
     * This is the resource type of the search.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link ResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return This is the resource type of the search.
     * @see ResourceType
     */
    public final String resourceTypeAsString() {
        return resourceType;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) that uniquely identifies the backup resources.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) that uniquely identifies the backup resources.
     */
    public final String backupResourceArn() {
        return backupResourceArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) that uniquely identifies the source resources.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) that uniquely identifies the source resources.
     */
    public final String sourceResourceArn() {
        return sourceResourceArn;
    }

    /**
     * <p>
     * This is the creation time of the backup index.
     * </p>
     * 
     * @return This is the creation time of the backup index.
     */
    public final Instant indexCreationTime() {
        return indexCreationTime;
    }

    /**
     * <p>
     * This is the creation time of the backup (recovery point).
     * </p>
     * 
     * @return This is the creation time of the backup (recovery point).
     */
    public final Instant backupCreationTime() {
        return backupCreationTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(backupResourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(sourceResourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(indexCreationTime());
        hashCode = 31 * hashCode + Objects.hashCode(backupCreationTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchJobBackupsResult)) {
            return false;
        }
        SearchJobBackupsResult other = (SearchJobBackupsResult) obj;
        return Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(statusMessage(), other.statusMessage())
                && Objects.equals(resourceTypeAsString(), other.resourceTypeAsString())
                && Objects.equals(backupResourceArn(), other.backupResourceArn())
                && Objects.equals(sourceResourceArn(), other.sourceResourceArn())
                && Objects.equals(indexCreationTime(), other.indexCreationTime())
                && Objects.equals(backupCreationTime(), other.backupCreationTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SearchJobBackupsResult").add("Status", statusAsString()).add("StatusMessage", statusMessage())
                .add("ResourceType", resourceTypeAsString()).add("BackupResourceArn", backupResourceArn())
                .add("SourceResourceArn", sourceResourceArn()).add("IndexCreationTime", indexCreationTime())
                .add("BackupCreationTime", backupCreationTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "StatusMessage":
            return Optional.ofNullable(clazz.cast(statusMessage()));
        case "ResourceType":
            return Optional.ofNullable(clazz.cast(resourceTypeAsString()));
        case "BackupResourceArn":
            return Optional.ofNullable(clazz.cast(backupResourceArn()));
        case "SourceResourceArn":
            return Optional.ofNullable(clazz.cast(sourceResourceArn()));
        case "IndexCreationTime":
            return Optional.ofNullable(clazz.cast(indexCreationTime()));
        case "BackupCreationTime":
            return Optional.ofNullable(clazz.cast(backupCreationTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Status", STATUS_FIELD);
        map.put("StatusMessage", STATUS_MESSAGE_FIELD);
        map.put("ResourceType", RESOURCE_TYPE_FIELD);
        map.put("BackupResourceArn", BACKUP_RESOURCE_ARN_FIELD);
        map.put("SourceResourceArn", SOURCE_RESOURCE_ARN_FIELD);
        map.put("IndexCreationTime", INDEX_CREATION_TIME_FIELD);
        map.put("BackupCreationTime", BACKUP_CREATION_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SearchJobBackupsResult, T> g) {
        return obj -> g.apply((SearchJobBackupsResult) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SearchJobBackupsResult> {
        /**
         * <p>
         * This is the status of the search job backup result.
         * </p>
         * 
         * @param status
         *        This is the status of the search job backup result.
         * @see SearchJobState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SearchJobState
         */
        Builder status(String status);

        /**
         * <p>
         * This is the status of the search job backup result.
         * </p>
         * 
         * @param status
         *        This is the status of the search job backup result.
         * @see SearchJobState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SearchJobState
         */
        Builder status(SearchJobState status);

        /**
         * <p>
         * This is the status message included with the results.
         * </p>
         * 
         * @param statusMessage
         *        This is the status message included with the results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusMessage(String statusMessage);

        /**
         * <p>
         * This is the resource type of the search.
         * </p>
         * 
         * @param resourceType
         *        This is the resource type of the search.
         * @see ResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceType
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * This is the resource type of the search.
         * </p>
         * 
         * @param resourceType
         *        This is the resource type of the search.
         * @see ResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceType
         */
        Builder resourceType(ResourceType resourceType);

        /**
         * <p>
         * The Amazon Resource Name (ARN) that uniquely identifies the backup resources.
         * </p>
         * 
         * @param backupResourceArn
         *        The Amazon Resource Name (ARN) that uniquely identifies the backup resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupResourceArn(String backupResourceArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) that uniquely identifies the source resources.
         * </p>
         * 
         * @param sourceResourceArn
         *        The Amazon Resource Name (ARN) that uniquely identifies the source resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceResourceArn(String sourceResourceArn);

        /**
         * <p>
         * This is the creation time of the backup index.
         * </p>
         * 
         * @param indexCreationTime
         *        This is the creation time of the backup index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indexCreationTime(Instant indexCreationTime);

        /**
         * <p>
         * This is the creation time of the backup (recovery point).
         * </p>
         * 
         * @param backupCreationTime
         *        This is the creation time of the backup (recovery point).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupCreationTime(Instant backupCreationTime);
    }

    static final class BuilderImpl implements Builder {
        private String status;

        private String statusMessage;

        private String resourceType;

        private String backupResourceArn;

        private String sourceResourceArn;

        private Instant indexCreationTime;

        private Instant backupCreationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchJobBackupsResult model) {
            status(model.status);
            statusMessage(model.statusMessage);
            resourceType(model.resourceType);
            backupResourceArn(model.backupResourceArn);
            sourceResourceArn(model.sourceResourceArn);
            indexCreationTime(model.indexCreationTime);
            backupCreationTime(model.backupCreationTime);
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(SearchJobState status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusMessage() {
            return statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final String getResourceType() {
            return resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(ResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final String getBackupResourceArn() {
            return backupResourceArn;
        }

        public final void setBackupResourceArn(String backupResourceArn) {
            this.backupResourceArn = backupResourceArn;
        }

        @Override
        public final Builder backupResourceArn(String backupResourceArn) {
            this.backupResourceArn = backupResourceArn;
            return this;
        }

        public final String getSourceResourceArn() {
            return sourceResourceArn;
        }

        public final void setSourceResourceArn(String sourceResourceArn) {
            this.sourceResourceArn = sourceResourceArn;
        }

        @Override
        public final Builder sourceResourceArn(String sourceResourceArn) {
            this.sourceResourceArn = sourceResourceArn;
            return this;
        }

        public final Instant getIndexCreationTime() {
            return indexCreationTime;
        }

        public final void setIndexCreationTime(Instant indexCreationTime) {
            this.indexCreationTime = indexCreationTime;
        }

        @Override
        public final Builder indexCreationTime(Instant indexCreationTime) {
            this.indexCreationTime = indexCreationTime;
            return this;
        }

        public final Instant getBackupCreationTime() {
            return backupCreationTime;
        }

        public final void setBackupCreationTime(Instant backupCreationTime) {
            this.backupCreationTime = backupCreationTime;
        }

        @Override
        public final Builder backupCreationTime(Instant backupCreationTime) {
            this.backupCreationTime = backupCreationTime;
            return this;
        }

        @Override
        public SearchJobBackupsResult build() {
            return new SearchJobBackupsResult(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
