/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backupsearch.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartSearchResultExportJobResponse extends BackupSearchResponse implements
        ToCopyableBuilder<StartSearchResultExportJobResponse.Builder, StartSearchResultExportJobResponse> {
    private static final SdkField<String> EXPORT_JOB_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExportJobArn").getter(getter(StartSearchResultExportJobResponse::exportJobArn))
            .setter(setter(Builder::exportJobArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportJobArn").build()).build();

    private static final SdkField<String> EXPORT_JOB_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExportJobIdentifier").getter(getter(StartSearchResultExportJobResponse::exportJobIdentifier))
            .setter(setter(Builder::exportJobIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportJobIdentifier").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPORT_JOB_ARN_FIELD,
            EXPORT_JOB_IDENTIFIER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String exportJobArn;

    private final String exportJobIdentifier;

    private StartSearchResultExportJobResponse(BuilderImpl builder) {
        super(builder);
        this.exportJobArn = builder.exportJobArn;
        this.exportJobIdentifier = builder.exportJobIdentifier;
    }

    /**
     * <p>
     * This is the unique ARN (Amazon Resource Name) that belongs to the new export job.
     * </p>
     * 
     * @return This is the unique ARN (Amazon Resource Name) that belongs to the new export job.
     */
    public final String exportJobArn() {
        return exportJobArn;
    }

    /**
     * <p>
     * This is the unique identifier that specifies the new export job.
     * </p>
     * 
     * @return This is the unique identifier that specifies the new export job.
     */
    public final String exportJobIdentifier() {
        return exportJobIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(exportJobArn());
        hashCode = 31 * hashCode + Objects.hashCode(exportJobIdentifier());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartSearchResultExportJobResponse)) {
            return false;
        }
        StartSearchResultExportJobResponse other = (StartSearchResultExportJobResponse) obj;
        return Objects.equals(exportJobArn(), other.exportJobArn())
                && Objects.equals(exportJobIdentifier(), other.exportJobIdentifier());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartSearchResultExportJobResponse").add("ExportJobArn", exportJobArn())
                .add("ExportJobIdentifier", exportJobIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ExportJobArn":
            return Optional.ofNullable(clazz.cast(exportJobArn()));
        case "ExportJobIdentifier":
            return Optional.ofNullable(clazz.cast(exportJobIdentifier()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ExportJobArn", EXPORT_JOB_ARN_FIELD);
        map.put("ExportJobIdentifier", EXPORT_JOB_IDENTIFIER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartSearchResultExportJobResponse, T> g) {
        return obj -> g.apply((StartSearchResultExportJobResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends BackupSearchResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, StartSearchResultExportJobResponse> {
        /**
         * <p>
         * This is the unique ARN (Amazon Resource Name) that belongs to the new export job.
         * </p>
         * 
         * @param exportJobArn
         *        This is the unique ARN (Amazon Resource Name) that belongs to the new export job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exportJobArn(String exportJobArn);

        /**
         * <p>
         * This is the unique identifier that specifies the new export job.
         * </p>
         * 
         * @param exportJobIdentifier
         *        This is the unique identifier that specifies the new export job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exportJobIdentifier(String exportJobIdentifier);
    }

    static final class BuilderImpl extends BackupSearchResponse.BuilderImpl implements Builder {
        private String exportJobArn;

        private String exportJobIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(StartSearchResultExportJobResponse model) {
            super(model);
            exportJobArn(model.exportJobArn);
            exportJobIdentifier(model.exportJobIdentifier);
        }

        public final String getExportJobArn() {
            return exportJobArn;
        }

        public final void setExportJobArn(String exportJobArn) {
            this.exportJobArn = exportJobArn;
        }

        @Override
        public final Builder exportJobArn(String exportJobArn) {
            this.exportJobArn = exportJobArn;
            return this;
        }

        public final String getExportJobIdentifier() {
            return exportJobIdentifier;
        }

        public final void setExportJobIdentifier(String exportJobIdentifier) {
            this.exportJobIdentifier = exportJobIdentifier;
        }

        @Override
        public final Builder exportJobIdentifier(String exportJobIdentifier) {
            this.exportJobIdentifier = exportJobIdentifier;
            return this;
        }

        @Override
        public StartSearchResultExportJobResponse build() {
            return new StartSearchResultExportJobResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
