/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backupsearch.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListSearchJobsRequest extends BackupSearchRequest implements
        ToCopyableBuilder<ListSearchJobsRequest.Builder, ListSearchJobsRequest> {
    private static final SdkField<String> BY_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ByStatus").getter(getter(ListSearchJobsRequest::byStatusAsString)).setter(setter(Builder::byStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("Status").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListSearchJobsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListSearchJobsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("MaxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BY_STATUS_FIELD,
            NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String byStatus;

    private final String nextToken;

    private final Integer maxResults;

    private ListSearchJobsRequest(BuilderImpl builder) {
        super(builder);
        this.byStatus = builder.byStatus;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * <p>
     * Include this parameter to filter list by search job status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #byStatus} will
     * return {@link SearchJobState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #byStatusAsString}.
     * </p>
     * 
     * @return Include this parameter to filter list by search job status.
     * @see SearchJobState
     */
    public final SearchJobState byStatus() {
        return SearchJobState.fromValue(byStatus);
    }

    /**
     * <p>
     * Include this parameter to filter list by search job status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #byStatus} will
     * return {@link SearchJobState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #byStatusAsString}.
     * </p>
     * 
     * @return Include this parameter to filter list by search job status.
     * @see SearchJobState
     */
    public final String byStatusAsString() {
        return byStatus;
    }

    /**
     * <p>
     * The next item following a partial list of returned search jobs.
     * </p>
     * <p>
     * For example, if a request is made to return <code>MaxResults</code> number of backups, <code>NextToken</code>
     * allows you to return more items in your list starting at the location pointed to by the next token.
     * </p>
     * 
     * @return The next item following a partial list of returned search jobs.</p>
     *         <p>
     *         For example, if a request is made to return <code>MaxResults</code> number of backups,
     *         <code>NextToken</code> allows you to return more items in your list starting at the location pointed to
     *         by the next token.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of resource list items to be returned.
     * </p>
     * 
     * @return The maximum number of resource list items to be returned.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(byStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSearchJobsRequest)) {
            return false;
        }
        ListSearchJobsRequest other = (ListSearchJobsRequest) obj;
        return Objects.equals(byStatusAsString(), other.byStatusAsString()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(maxResults(), other.maxResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListSearchJobsRequest").add("ByStatus", byStatusAsString()).add("NextToken", nextToken())
                .add("MaxResults", maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ByStatus":
            return Optional.ofNullable(clazz.cast(byStatusAsString()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Status", BY_STATUS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListSearchJobsRequest, T> g) {
        return obj -> g.apply((ListSearchJobsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends BackupSearchRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListSearchJobsRequest> {
        /**
         * <p>
         * Include this parameter to filter list by search job status.
         * </p>
         * 
         * @param byStatus
         *        Include this parameter to filter list by search job status.
         * @see SearchJobState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SearchJobState
         */
        Builder byStatus(String byStatus);

        /**
         * <p>
         * Include this parameter to filter list by search job status.
         * </p>
         * 
         * @param byStatus
         *        Include this parameter to filter list by search job status.
         * @see SearchJobState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SearchJobState
         */
        Builder byStatus(SearchJobState byStatus);

        /**
         * <p>
         * The next item following a partial list of returned search jobs.
         * </p>
         * <p>
         * For example, if a request is made to return <code>MaxResults</code> number of backups, <code>NextToken</code>
         * allows you to return more items in your list starting at the location pointed to by the next token.
         * </p>
         * 
         * @param nextToken
         *        The next item following a partial list of returned search jobs.</p>
         *        <p>
         *        For example, if a request is made to return <code>MaxResults</code> number of backups,
         *        <code>NextToken</code> allows you to return more items in your list starting at the location pointed
         *        to by the next token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of resource list items to be returned.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of resource list items to be returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BackupSearchRequest.BuilderImpl implements Builder {
        private String byStatus;

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSearchJobsRequest model) {
            super(model);
            byStatus(model.byStatus);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final String getByStatus() {
            return byStatus;
        }

        public final void setByStatus(String byStatus) {
            this.byStatus = byStatus;
        }

        @Override
        public final Builder byStatus(String byStatus) {
            this.byStatus = byStatus;
            return this;
        }

        @Override
        public final Builder byStatus(SearchJobState byStatus) {
            this.byStatus(byStatus == null ? null : byStatus.toString());
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListSearchJobsRequest build() {
            return new ListSearchJobsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
