/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backupsearch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListSearchResultExportJobsResponse extends BackupSearchResponse implements
        ToCopyableBuilder<ListSearchResultExportJobsResponse.Builder, ListSearchResultExportJobsResponse> {
    private static final SdkField<List<ExportJobSummary>> EXPORT_JOBS_FIELD = SdkField
            .<List<ExportJobSummary>> builder(MarshallingType.LIST)
            .memberName("ExportJobs")
            .getter(getter(ListSearchResultExportJobsResponse::exportJobs))
            .setter(setter(Builder::exportJobs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportJobs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ExportJobSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(ExportJobSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListSearchResultExportJobsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPORT_JOBS_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<ExportJobSummary> exportJobs;

    private final String nextToken;

    private ListSearchResultExportJobsResponse(BuilderImpl builder) {
        super(builder);
        this.exportJobs = builder.exportJobs;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the ExportJobs property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasExportJobs() {
        return exportJobs != null && !(exportJobs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The operation returns the included export jobs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasExportJobs} method.
     * </p>
     * 
     * @return The operation returns the included export jobs.
     */
    public final List<ExportJobSummary> exportJobs() {
        return exportJobs;
    }

    /**
     * <p>
     * The next item following a partial list of returned backups included in a search job.
     * </p>
     * <p>
     * For example, if a request is made to return <code>MaxResults</code> number of backups, <code>NextToken</code>
     * allows you to return more items in your list starting at the location pointed to by the next token.
     * </p>
     * 
     * @return The next item following a partial list of returned backups included in a search job.</p>
     *         <p>
     *         For example, if a request is made to return <code>MaxResults</code> number of backups,
     *         <code>NextToken</code> allows you to return more items in your list starting at the location pointed to
     *         by the next token.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasExportJobs() ? exportJobs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSearchResultExportJobsResponse)) {
            return false;
        }
        ListSearchResultExportJobsResponse other = (ListSearchResultExportJobsResponse) obj;
        return hasExportJobs() == other.hasExportJobs() && Objects.equals(exportJobs(), other.exportJobs())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListSearchResultExportJobsResponse").add("ExportJobs", hasExportJobs() ? exportJobs() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ExportJobs":
            return Optional.ofNullable(clazz.cast(exportJobs()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ExportJobs", EXPORT_JOBS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListSearchResultExportJobsResponse, T> g) {
        return obj -> g.apply((ListSearchResultExportJobsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends BackupSearchResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListSearchResultExportJobsResponse> {
        /**
         * <p>
         * The operation returns the included export jobs.
         * </p>
         * 
         * @param exportJobs
         *        The operation returns the included export jobs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exportJobs(Collection<ExportJobSummary> exportJobs);

        /**
         * <p>
         * The operation returns the included export jobs.
         * </p>
         * 
         * @param exportJobs
         *        The operation returns the included export jobs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exportJobs(ExportJobSummary... exportJobs);

        /**
         * <p>
         * The operation returns the included export jobs.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.backupsearch.model.ExportJobSummary.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.backupsearch.model.ExportJobSummary#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.backupsearch.model.ExportJobSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #exportJobs(List<ExportJobSummary>)}.
         * 
         * @param exportJobs
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.backupsearch.model.ExportJobSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #exportJobs(java.util.Collection<ExportJobSummary>)
         */
        Builder exportJobs(Consumer<ExportJobSummary.Builder>... exportJobs);

        /**
         * <p>
         * The next item following a partial list of returned backups included in a search job.
         * </p>
         * <p>
         * For example, if a request is made to return <code>MaxResults</code> number of backups, <code>NextToken</code>
         * allows you to return more items in your list starting at the location pointed to by the next token.
         * </p>
         * 
         * @param nextToken
         *        The next item following a partial list of returned backups included in a search job.</p>
         *        <p>
         *        For example, if a request is made to return <code>MaxResults</code> number of backups,
         *        <code>NextToken</code> allows you to return more items in your list starting at the location pointed
         *        to by the next token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends BackupSearchResponse.BuilderImpl implements Builder {
        private List<ExportJobSummary> exportJobs = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSearchResultExportJobsResponse model) {
            super(model);
            exportJobs(model.exportJobs);
            nextToken(model.nextToken);
        }

        public final List<ExportJobSummary.Builder> getExportJobs() {
            List<ExportJobSummary.Builder> result = ExportJobSummariesCopier.copyToBuilder(this.exportJobs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setExportJobs(Collection<ExportJobSummary.BuilderImpl> exportJobs) {
            this.exportJobs = ExportJobSummariesCopier.copyFromBuilder(exportJobs);
        }

        @Override
        public final Builder exportJobs(Collection<ExportJobSummary> exportJobs) {
            this.exportJobs = ExportJobSummariesCopier.copy(exportJobs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder exportJobs(ExportJobSummary... exportJobs) {
            exportJobs(Arrays.asList(exportJobs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder exportJobs(Consumer<ExportJobSummary.Builder>... exportJobs) {
            exportJobs(Stream.of(exportJobs).map(c -> ExportJobSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListSearchResultExportJobsResponse build() {
            return new ListSearchResultExportJobsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
