/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backupsearch.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartSearchResultExportJobRequest extends BackupSearchRequest implements
        ToCopyableBuilder<StartSearchResultExportJobRequest.Builder, StartSearchResultExportJobRequest> {
    private static final SdkField<String> SEARCH_JOB_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SearchJobIdentifier").getter(getter(StartSearchResultExportJobRequest::searchJobIdentifier))
            .setter(setter(Builder::searchJobIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SearchJobIdentifier").build())
            .build();

    private static final SdkField<ExportSpecification> EXPORT_SPECIFICATION_FIELD = SdkField
            .<ExportSpecification> builder(MarshallingType.SDK_POJO).memberName("ExportSpecification")
            .getter(getter(StartSearchResultExportJobRequest::exportSpecification)).setter(setter(Builder::exportSpecification))
            .constructor(ExportSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportSpecification").build())
            .build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClientToken").getter(getter(StartSearchResultExportJobRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(StartSearchResultExportJobRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleArn").getter(getter(StartSearchResultExportJobRequest::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SEARCH_JOB_IDENTIFIER_FIELD,
            EXPORT_SPECIFICATION_FIELD, CLIENT_TOKEN_FIELD, TAGS_FIELD, ROLE_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String searchJobIdentifier;

    private final ExportSpecification exportSpecification;

    private final String clientToken;

    private final Map<String, String> tags;

    private final String roleArn;

    private StartSearchResultExportJobRequest(BuilderImpl builder) {
        super(builder);
        this.searchJobIdentifier = builder.searchJobIdentifier;
        this.exportSpecification = builder.exportSpecification;
        this.clientToken = builder.clientToken;
        this.tags = builder.tags;
        this.roleArn = builder.roleArn;
    }

    /**
     * <p>
     * The unique string that specifies the search job.
     * </p>
     * 
     * @return The unique string that specifies the search job.
     */
    public final String searchJobIdentifier() {
        return searchJobIdentifier;
    }

    /**
     * <p>
     * This specification contains a required string of the destination bucket; optionally, you can include the
     * destination prefix.
     * </p>
     * 
     * @return This specification contains a required string of the destination bucket; optionally, you can include the
     *         destination prefix.
     */
    public final ExportSpecification exportSpecification() {
        return exportSpecification;
    }

    /**
     * <p>
     * Include this parameter to allow multiple identical calls for idempotency.
     * </p>
     * <p>
     * A client token is valid for 8 hours after the first request that uses it is completed. After this time, any
     * request with the same token is treated as a new request.
     * </p>
     * 
     * @return Include this parameter to allow multiple identical calls for idempotency.</p>
     *         <p>
     *         A client token is valid for 8 hours after the first request that uses it is completed. After this time,
     *         any request with the same token is treated as a new request.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Optional tags to include. A tag is a key-value pair you can use to manage, filter, and search for your resources.
     * Allowed characters include UTF-8 letters, numbers, spaces, and the following characters: + - = . _ : /.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Optional tags to include. A tag is a key-value pair you can use to manage, filter, and search for your
     *         resources. Allowed characters include UTF-8 letters, numbers, spaces, and the following characters: + - =
     *         . _ : /.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * This parameter specifies the role ARN used to start the search results export jobs.
     * </p>
     * 
     * @return This parameter specifies the role ARN used to start the search results export jobs.
     */
    public final String roleArn() {
        return roleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(searchJobIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(exportSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartSearchResultExportJobRequest)) {
            return false;
        }
        StartSearchResultExportJobRequest other = (StartSearchResultExportJobRequest) obj;
        return Objects.equals(searchJobIdentifier(), other.searchJobIdentifier())
                && Objects.equals(exportSpecification(), other.exportSpecification())
                && Objects.equals(clientToken(), other.clientToken()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(roleArn(), other.roleArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartSearchResultExportJobRequest").add("SearchJobIdentifier", searchJobIdentifier())
                .add("ExportSpecification", exportSpecification()).add("ClientToken", clientToken())
                .add("Tags", hasTags() ? tags() : null).add("RoleArn", roleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SearchJobIdentifier":
            return Optional.ofNullable(clazz.cast(searchJobIdentifier()));
        case "ExportSpecification":
            return Optional.ofNullable(clazz.cast(exportSpecification()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SearchJobIdentifier", SEARCH_JOB_IDENTIFIER_FIELD);
        map.put("ExportSpecification", EXPORT_SPECIFICATION_FIELD);
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("RoleArn", ROLE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartSearchResultExportJobRequest, T> g) {
        return obj -> g.apply((StartSearchResultExportJobRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends BackupSearchRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, StartSearchResultExportJobRequest> {
        /**
         * <p>
         * The unique string that specifies the search job.
         * </p>
         * 
         * @param searchJobIdentifier
         *        The unique string that specifies the search job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder searchJobIdentifier(String searchJobIdentifier);

        /**
         * <p>
         * This specification contains a required string of the destination bucket; optionally, you can include the
         * destination prefix.
         * </p>
         * 
         * @param exportSpecification
         *        This specification contains a required string of the destination bucket; optionally, you can include
         *        the destination prefix.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exportSpecification(ExportSpecification exportSpecification);

        /**
         * <p>
         * This specification contains a required string of the destination bucket; optionally, you can include the
         * destination prefix.
         * </p>
         * This is a convenience method that creates an instance of the {@link ExportSpecification.Builder} avoiding the
         * need to create one manually via {@link ExportSpecification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ExportSpecification.Builder#build()} is called immediately and
         * its result is passed to {@link #exportSpecification(ExportSpecification)}.
         * 
         * @param exportSpecification
         *        a consumer that will call methods on {@link ExportSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #exportSpecification(ExportSpecification)
         */
        default Builder exportSpecification(Consumer<ExportSpecification.Builder> exportSpecification) {
            return exportSpecification(ExportSpecification.builder().applyMutation(exportSpecification).build());
        }

        /**
         * <p>
         * Include this parameter to allow multiple identical calls for idempotency.
         * </p>
         * <p>
         * A client token is valid for 8 hours after the first request that uses it is completed. After this time, any
         * request with the same token is treated as a new request.
         * </p>
         * 
         * @param clientToken
         *        Include this parameter to allow multiple identical calls for idempotency.</p>
         *        <p>
         *        A client token is valid for 8 hours after the first request that uses it is completed. After this
         *        time, any request with the same token is treated as a new request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * Optional tags to include. A tag is a key-value pair you can use to manage, filter, and search for your
         * resources. Allowed characters include UTF-8 letters, numbers, spaces, and the following characters: + - = . _
         * : /.
         * </p>
         * 
         * @param tags
         *        Optional tags to include. A tag is a key-value pair you can use to manage, filter, and search for your
         *        resources. Allowed characters include UTF-8 letters, numbers, spaces, and the following characters: +
         *        - = . _ : /.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * This parameter specifies the role ARN used to start the search results export jobs.
         * </p>
         * 
         * @param roleArn
         *        This parameter specifies the role ARN used to start the search results export jobs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BackupSearchRequest.BuilderImpl implements Builder {
        private String searchJobIdentifier;

        private ExportSpecification exportSpecification;

        private String clientToken;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private String roleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(StartSearchResultExportJobRequest model) {
            super(model);
            searchJobIdentifier(model.searchJobIdentifier);
            exportSpecification(model.exportSpecification);
            clientToken(model.clientToken);
            tags(model.tags);
            roleArn(model.roleArn);
        }

        public final String getSearchJobIdentifier() {
            return searchJobIdentifier;
        }

        public final void setSearchJobIdentifier(String searchJobIdentifier) {
            this.searchJobIdentifier = searchJobIdentifier;
        }

        @Override
        public final Builder searchJobIdentifier(String searchJobIdentifier) {
            this.searchJobIdentifier = searchJobIdentifier;
            return this;
        }

        public final ExportSpecification.Builder getExportSpecification() {
            return exportSpecification != null ? exportSpecification.toBuilder() : null;
        }

        public final void setExportSpecification(ExportSpecification.BuilderImpl exportSpecification) {
            this.exportSpecification = exportSpecification != null ? exportSpecification.build() : null;
        }

        @Override
        public final Builder exportSpecification(ExportSpecification exportSpecification) {
            this.exportSpecification = exportSpecification;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartSearchResultExportJobRequest build() {
            return new StartSearchResultExportJobRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
