/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backupsearch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This contains the value of the string and can contain one or more operators.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StringCondition implements SdkPojo, Serializable, ToCopyableBuilder<StringCondition.Builder, StringCondition> {
    private static final SdkField<String> VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Value")
            .getter(getter(StringCondition::value)).setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()).build();

    private static final SdkField<String> OPERATOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Operator").getter(getter(StringCondition::operatorAsString)).setter(setter(Builder::operator))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Operator").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VALUE_FIELD, OPERATOR_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String value;

    private final String operator;

    private StringCondition(BuilderImpl builder) {
        this.value = builder.value;
        this.operator = builder.operator;
    }

    /**
     * <p>
     * The value of the string.
     * </p>
     * 
     * @return The value of the string.
     */
    public final String value() {
        return value;
    }

    /**
     * <p>
     * A string that defines what values will be returned.
     * </p>
     * <p>
     * If this is included, avoid combinations of operators that will return all possible values. For example, including
     * both <code>EQUALS_TO</code> and <code>NOT_EQUALS_TO</code> with a value of <code>4</code> will return all values.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #operator} will
     * return {@link StringConditionOperator#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #operatorAsString}.
     * </p>
     * 
     * @return A string that defines what values will be returned.</p>
     *         <p>
     *         If this is included, avoid combinations of operators that will return all possible values. For example,
     *         including both <code>EQUALS_TO</code> and <code>NOT_EQUALS_TO</code> with a value of <code>4</code> will
     *         return all values.
     * @see StringConditionOperator
     */
    public final StringConditionOperator operator() {
        return StringConditionOperator.fromValue(operator);
    }

    /**
     * <p>
     * A string that defines what values will be returned.
     * </p>
     * <p>
     * If this is included, avoid combinations of operators that will return all possible values. For example, including
     * both <code>EQUALS_TO</code> and <code>NOT_EQUALS_TO</code> with a value of <code>4</code> will return all values.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #operator} will
     * return {@link StringConditionOperator#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #operatorAsString}.
     * </p>
     * 
     * @return A string that defines what values will be returned.</p>
     *         <p>
     *         If this is included, avoid combinations of operators that will return all possible values. For example,
     *         including both <code>EQUALS_TO</code> and <code>NOT_EQUALS_TO</code> with a value of <code>4</code> will
     *         return all values.
     * @see StringConditionOperator
     */
    public final String operatorAsString() {
        return operator;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(value());
        hashCode = 31 * hashCode + Objects.hashCode(operatorAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StringCondition)) {
            return false;
        }
        StringCondition other = (StringCondition) obj;
        return Objects.equals(value(), other.value()) && Objects.equals(operatorAsString(), other.operatorAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StringCondition").add("Value", value()).add("Operator", operatorAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Value":
            return Optional.ofNullable(clazz.cast(value()));
        case "Operator":
            return Optional.ofNullable(clazz.cast(operatorAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Value", VALUE_FIELD);
        map.put("Operator", OPERATOR_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StringCondition, T> g) {
        return obj -> g.apply((StringCondition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StringCondition> {
        /**
         * <p>
         * The value of the string.
         * </p>
         * 
         * @param value
         *        The value of the string.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(String value);

        /**
         * <p>
         * A string that defines what values will be returned.
         * </p>
         * <p>
         * If this is included, avoid combinations of operators that will return all possible values. For example,
         * including both <code>EQUALS_TO</code> and <code>NOT_EQUALS_TO</code> with a value of <code>4</code> will
         * return all values.
         * </p>
         * 
         * @param operator
         *        A string that defines what values will be returned.</p>
         *        <p>
         *        If this is included, avoid combinations of operators that will return all possible values. For
         *        example, including both <code>EQUALS_TO</code> and <code>NOT_EQUALS_TO</code> with a value of
         *        <code>4</code> will return all values.
         * @see StringConditionOperator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StringConditionOperator
         */
        Builder operator(String operator);

        /**
         * <p>
         * A string that defines what values will be returned.
         * </p>
         * <p>
         * If this is included, avoid combinations of operators that will return all possible values. For example,
         * including both <code>EQUALS_TO</code> and <code>NOT_EQUALS_TO</code> with a value of <code>4</code> will
         * return all values.
         * </p>
         * 
         * @param operator
         *        A string that defines what values will be returned.</p>
         *        <p>
         *        If this is included, avoid combinations of operators that will return all possible values. For
         *        example, including both <code>EQUALS_TO</code> and <code>NOT_EQUALS_TO</code> with a value of
         *        <code>4</code> will return all values.
         * @see StringConditionOperator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StringConditionOperator
         */
        Builder operator(StringConditionOperator operator);
    }

    static final class BuilderImpl implements Builder {
        private String value;

        private String operator;

        private BuilderImpl() {
        }

        private BuilderImpl(StringCondition model) {
            value(model.value);
            operator(model.operator);
        }

        public final String getValue() {
            return value;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final String getOperator() {
            return operator;
        }

        public final void setOperator(String operator) {
            this.operator = operator;
        }

        @Override
        public final Builder operator(String operator) {
            this.operator = operator;
            return this;
        }

        @Override
        public final Builder operator(StringConditionOperator operator) {
            this.operator(operator == null ? null : operator.toString());
            return this;
        }

        @Override
        public StringCondition build() {
            return new StringCondition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
