/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backupstorage;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.backupstorage.BackupStorageClient;
import software.amazon.awssdk.services.backupstorage.BackupStorageClientBuilder;
import software.amazon.awssdk.services.backupstorage.BackupStorageServiceClientConfiguration;
import software.amazon.awssdk.services.backupstorage.DefaultBackupStorageBaseClientBuilder;
import software.amazon.awssdk.services.backupstorage.DefaultBackupStorageClient;
import software.amazon.awssdk.services.backupstorage.endpoints.BackupStorageEndpointProvider;

@SdkInternalApi
final class DefaultBackupStorageClientBuilder
extends DefaultBackupStorageBaseClientBuilder<BackupStorageClientBuilder, BackupStorageClient>
implements BackupStorageClientBuilder {
    DefaultBackupStorageClientBuilder() {
    }

    @Override
    public DefaultBackupStorageClientBuilder endpointProvider(BackupStorageEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final BackupStorageClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultBackupStorageClientBuilder.validateClientOptions(clientConfiguration);
        BackupStorageServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultBackupStorageClient client = new DefaultBackupStorageClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private BackupStorageServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        EndpointProvider endpointProvider = (EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER);
        if (clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return BackupStorageServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider(endpointProvider).build();
    }
}

