/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backupstorage.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.backupstorage.model.BackupStorageRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetChunkRequest
extends BackupStorageRequest
implements ToCopyableBuilder<Builder, GetChunkRequest> {
    private static final SdkField<String> STORAGE_JOB_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StorageJobId").getter(GetChunkRequest.getter(GetChunkRequest::storageJobId)).setter(GetChunkRequest.setter(Builder::storageJobId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("jobId").build()}).build();
    private static final SdkField<String> CHUNK_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChunkToken").getter(GetChunkRequest.getter(GetChunkRequest::chunkToken)).setter(GetChunkRequest.setter(Builder::chunkToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("chunkToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STORAGE_JOB_ID_FIELD, CHUNK_TOKEN_FIELD));
    private final String storageJobId;
    private final String chunkToken;

    private GetChunkRequest(BuilderImpl builder) {
        super(builder);
        this.storageJobId = builder.storageJobId;
        this.chunkToken = builder.chunkToken;
    }

    public final String storageJobId() {
        return this.storageJobId;
    }

    public final String chunkToken() {
        return this.chunkToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.storageJobId());
        hashCode = 31 * hashCode + Objects.hashCode(this.chunkToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetChunkRequest)) {
            return false;
        }
        GetChunkRequest other = (GetChunkRequest)((Object)obj);
        return Objects.equals(this.storageJobId(), other.storageJobId()) && Objects.equals(this.chunkToken(), other.chunkToken());
    }

    public final String toString() {
        return ToString.builder((String)"GetChunkRequest").add("StorageJobId", (Object)this.storageJobId()).add("ChunkToken", (Object)this.chunkToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StorageJobId": {
                return Optional.ofNullable(clazz.cast(this.storageJobId()));
            }
            case "ChunkToken": {
                return Optional.ofNullable(clazz.cast(this.chunkToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetChunkRequest, T> g) {
        return obj -> g.apply((GetChunkRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BackupStorageRequest.BuilderImpl
    implements Builder {
        private String storageJobId;
        private String chunkToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetChunkRequest model) {
            super(model);
            this.storageJobId(model.storageJobId);
            this.chunkToken(model.chunkToken);
        }

        public final String getStorageJobId() {
            return this.storageJobId;
        }

        public final void setStorageJobId(String storageJobId) {
            this.storageJobId = storageJobId;
        }

        @Override
        public final Builder storageJobId(String storageJobId) {
            this.storageJobId = storageJobId;
            return this;
        }

        public final String getChunkToken() {
            return this.chunkToken;
        }

        public final void setChunkToken(String chunkToken) {
            this.chunkToken = chunkToken;
        }

        @Override
        public final Builder chunkToken(String chunkToken) {
            this.chunkToken = chunkToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetChunkRequest build() {
            return new GetChunkRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends BackupStorageRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetChunkRequest> {
        public Builder storageJobId(String var1);

        public Builder chunkToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

