/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backupstorage.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetObjectMetadataResponse extends BackupStorageResponse implements
        ToCopyableBuilder<GetObjectMetadataResponse.Builder, GetObjectMetadataResponse> {
    private static final SdkField<String> METADATA_STRING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MetadataString").getter(getter(GetObjectMetadataResponse::metadataString))
            .setter(setter(Builder::metadataString))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-metadata-string").build())
            .build();

    private static final SdkField<Long> METADATA_BLOB_LENGTH_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("MetadataBlobLength").getter(getter(GetObjectMetadataResponse::metadataBlobLength))
            .setter(setter(Builder::metadataBlobLength))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-data-length").build()).build();

    private static final SdkField<String> METADATA_BLOB_CHECKSUM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MetadataBlobChecksum").getter(getter(GetObjectMetadataResponse::metadataBlobChecksum))
            .setter(setter(Builder::metadataBlobChecksum))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-checksum").build()).build();

    private static final SdkField<String> METADATA_BLOB_CHECKSUM_ALGORITHM_FIELD = SdkField
            .<String> builder(MarshallingType.STRING).memberName("MetadataBlobChecksumAlgorithm")
            .getter(getter(GetObjectMetadataResponse::metadataBlobChecksumAlgorithmAsString))
            .setter(setter(Builder::metadataBlobChecksumAlgorithm))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-checksum-algorithm").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METADATA_STRING_FIELD,
            METADATA_BLOB_LENGTH_FIELD, METADATA_BLOB_CHECKSUM_FIELD, METADATA_BLOB_CHECKSUM_ALGORITHM_FIELD));

    private final String metadataString;

    private final Long metadataBlobLength;

    private final String metadataBlobChecksum;

    private final String metadataBlobChecksumAlgorithm;

    private GetObjectMetadataResponse(BuilderImpl builder) {
        super(builder);
        this.metadataString = builder.metadataString;
        this.metadataBlobLength = builder.metadataBlobLength;
        this.metadataBlobChecksum = builder.metadataBlobChecksum;
        this.metadataBlobChecksumAlgorithm = builder.metadataBlobChecksumAlgorithm;
    }

    /**
     * Metadata string.
     * 
     * @return Metadata string.
     */
    public final String metadataString() {
        return metadataString;
    }

    /**
     * The size of MetadataBlob.
     * 
     * @return The size of MetadataBlob.
     */
    public final Long metadataBlobLength() {
        return metadataBlobLength;
    }

    /**
     * MetadataBlob checksum.
     * 
     * @return MetadataBlob checksum.
     */
    public final String metadataBlobChecksum() {
        return metadataBlobChecksum;
    }

    /**
     * Checksum algorithm.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #metadataBlobChecksumAlgorithm} will return {@link DataChecksumAlgorithm#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #metadataBlobChecksumAlgorithmAsString}.
     * </p>
     * 
     * @return Checksum algorithm.
     * @see DataChecksumAlgorithm
     */
    public final DataChecksumAlgorithm metadataBlobChecksumAlgorithm() {
        return DataChecksumAlgorithm.fromValue(metadataBlobChecksumAlgorithm);
    }

    /**
     * Checksum algorithm.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #metadataBlobChecksumAlgorithm} will return {@link DataChecksumAlgorithm#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #metadataBlobChecksumAlgorithmAsString}.
     * </p>
     * 
     * @return Checksum algorithm.
     * @see DataChecksumAlgorithm
     */
    public final String metadataBlobChecksumAlgorithmAsString() {
        return metadataBlobChecksumAlgorithm;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(metadataString());
        hashCode = 31 * hashCode + Objects.hashCode(metadataBlobLength());
        hashCode = 31 * hashCode + Objects.hashCode(metadataBlobChecksum());
        hashCode = 31 * hashCode + Objects.hashCode(metadataBlobChecksumAlgorithmAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetObjectMetadataResponse)) {
            return false;
        }
        GetObjectMetadataResponse other = (GetObjectMetadataResponse) obj;
        return Objects.equals(metadataString(), other.metadataString())
                && Objects.equals(metadataBlobLength(), other.metadataBlobLength())
                && Objects.equals(metadataBlobChecksum(), other.metadataBlobChecksum())
                && Objects.equals(metadataBlobChecksumAlgorithmAsString(), other.metadataBlobChecksumAlgorithmAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetObjectMetadataResponse").add("MetadataString", metadataString())
                .add("MetadataBlobLength", metadataBlobLength()).add("MetadataBlobChecksum", metadataBlobChecksum())
                .add("MetadataBlobChecksumAlgorithm", metadataBlobChecksumAlgorithmAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MetadataString":
            return Optional.ofNullable(clazz.cast(metadataString()));
        case "MetadataBlobLength":
            return Optional.ofNullable(clazz.cast(metadataBlobLength()));
        case "MetadataBlobChecksum":
            return Optional.ofNullable(clazz.cast(metadataBlobChecksum()));
        case "MetadataBlobChecksumAlgorithm":
            return Optional.ofNullable(clazz.cast(metadataBlobChecksumAlgorithmAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetObjectMetadataResponse, T> g) {
        return obj -> g.apply((GetObjectMetadataResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BackupStorageResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetObjectMetadataResponse> {
        /**
         * Metadata string.
         * 
         * @param metadataString
         *        Metadata string.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadataString(String metadataString);

        /**
         * The size of MetadataBlob.
         * 
         * @param metadataBlobLength
         *        The size of MetadataBlob.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadataBlobLength(Long metadataBlobLength);

        /**
         * MetadataBlob checksum.
         * 
         * @param metadataBlobChecksum
         *        MetadataBlob checksum.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadataBlobChecksum(String metadataBlobChecksum);

        /**
         * Checksum algorithm.
         * 
         * @param metadataBlobChecksumAlgorithm
         *        Checksum algorithm.
         * @see DataChecksumAlgorithm
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataChecksumAlgorithm
         */
        Builder metadataBlobChecksumAlgorithm(String metadataBlobChecksumAlgorithm);

        /**
         * Checksum algorithm.
         * 
         * @param metadataBlobChecksumAlgorithm
         *        Checksum algorithm.
         * @see DataChecksumAlgorithm
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataChecksumAlgorithm
         */
        Builder metadataBlobChecksumAlgorithm(DataChecksumAlgorithm metadataBlobChecksumAlgorithm);
    }

    static final class BuilderImpl extends BackupStorageResponse.BuilderImpl implements Builder {
        private String metadataString;

        private Long metadataBlobLength;

        private String metadataBlobChecksum;

        private String metadataBlobChecksumAlgorithm;

        private BuilderImpl() {
        }

        private BuilderImpl(GetObjectMetadataResponse model) {
            super(model);
            metadataString(model.metadataString);
            metadataBlobLength(model.metadataBlobLength);
            metadataBlobChecksum(model.metadataBlobChecksum);
            metadataBlobChecksumAlgorithm(model.metadataBlobChecksumAlgorithm);
        }

        public final String getMetadataString() {
            return metadataString;
        }

        public final void setMetadataString(String metadataString) {
            this.metadataString = metadataString;
        }

        @Override
        public final Builder metadataString(String metadataString) {
            this.metadataString = metadataString;
            return this;
        }

        public final Long getMetadataBlobLength() {
            return metadataBlobLength;
        }

        public final void setMetadataBlobLength(Long metadataBlobLength) {
            this.metadataBlobLength = metadataBlobLength;
        }

        @Override
        public final Builder metadataBlobLength(Long metadataBlobLength) {
            this.metadataBlobLength = metadataBlobLength;
            return this;
        }

        public final String getMetadataBlobChecksum() {
            return metadataBlobChecksum;
        }

        public final void setMetadataBlobChecksum(String metadataBlobChecksum) {
            this.metadataBlobChecksum = metadataBlobChecksum;
        }

        @Override
        public final Builder metadataBlobChecksum(String metadataBlobChecksum) {
            this.metadataBlobChecksum = metadataBlobChecksum;
            return this;
        }

        public final String getMetadataBlobChecksumAlgorithm() {
            return metadataBlobChecksumAlgorithm;
        }

        public final void setMetadataBlobChecksumAlgorithm(String metadataBlobChecksumAlgorithm) {
            this.metadataBlobChecksumAlgorithm = metadataBlobChecksumAlgorithm;
        }

        @Override
        public final Builder metadataBlobChecksumAlgorithm(String metadataBlobChecksumAlgorithm) {
            this.metadataBlobChecksumAlgorithm = metadataBlobChecksumAlgorithm;
            return this;
        }

        @Override
        public final Builder metadataBlobChecksumAlgorithm(DataChecksumAlgorithm metadataBlobChecksumAlgorithm) {
            this.metadataBlobChecksumAlgorithm(metadataBlobChecksumAlgorithm == null ? null : metadataBlobChecksumAlgorithm
                    .toString());
            return this;
        }

        @Override
        public GetObjectMetadataResponse build() {
            return new GetObjectMetadataResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
