/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backupstorage;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.auth.signer.Aws4UnsignedPayloadSigner;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkProtocolMetadata;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkServiceClientConfiguration;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.runtime.transform.StreamingRequestMarshaller;
import software.amazon.awssdk.core.signer.Signer;
import software.amazon.awssdk.core.sync.RequestBody;
import software.amazon.awssdk.core.sync.ResponseTransformer;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.backupstorage.BackupStorageClient;
import software.amazon.awssdk.services.backupstorage.BackupStorageServiceClientConfiguration;
import software.amazon.awssdk.services.backupstorage.internal.BackupStorageServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.backupstorage.model.AccessDeniedException;
import software.amazon.awssdk.services.backupstorage.model.BackupStorageException;
import software.amazon.awssdk.services.backupstorage.model.BackupStorageRequest;
import software.amazon.awssdk.services.backupstorage.model.DataAlreadyExistsException;
import software.amazon.awssdk.services.backupstorage.model.DeleteObjectRequest;
import software.amazon.awssdk.services.backupstorage.model.DeleteObjectResponse;
import software.amazon.awssdk.services.backupstorage.model.GetChunkRequest;
import software.amazon.awssdk.services.backupstorage.model.GetChunkResponse;
import software.amazon.awssdk.services.backupstorage.model.GetObjectMetadataRequest;
import software.amazon.awssdk.services.backupstorage.model.GetObjectMetadataResponse;
import software.amazon.awssdk.services.backupstorage.model.IllegalArgumentException;
import software.amazon.awssdk.services.backupstorage.model.KmsInvalidKeyUsageException;
import software.amazon.awssdk.services.backupstorage.model.ListChunksRequest;
import software.amazon.awssdk.services.backupstorage.model.ListChunksResponse;
import software.amazon.awssdk.services.backupstorage.model.ListObjectsRequest;
import software.amazon.awssdk.services.backupstorage.model.ListObjectsResponse;
import software.amazon.awssdk.services.backupstorage.model.NotReadableInputStreamException;
import software.amazon.awssdk.services.backupstorage.model.NotifyObjectCompleteRequest;
import software.amazon.awssdk.services.backupstorage.model.NotifyObjectCompleteResponse;
import software.amazon.awssdk.services.backupstorage.model.PutChunkRequest;
import software.amazon.awssdk.services.backupstorage.model.PutChunkResponse;
import software.amazon.awssdk.services.backupstorage.model.PutObjectRequest;
import software.amazon.awssdk.services.backupstorage.model.PutObjectResponse;
import software.amazon.awssdk.services.backupstorage.model.ResourceNotFoundException;
import software.amazon.awssdk.services.backupstorage.model.RetryableException;
import software.amazon.awssdk.services.backupstorage.model.ServiceInternalException;
import software.amazon.awssdk.services.backupstorage.model.ServiceUnavailableException;
import software.amazon.awssdk.services.backupstorage.model.StartObjectRequest;
import software.amazon.awssdk.services.backupstorage.model.StartObjectResponse;
import software.amazon.awssdk.services.backupstorage.model.ThrottlingException;
import software.amazon.awssdk.services.backupstorage.transform.DeleteObjectRequestMarshaller;
import software.amazon.awssdk.services.backupstorage.transform.GetChunkRequestMarshaller;
import software.amazon.awssdk.services.backupstorage.transform.GetObjectMetadataRequestMarshaller;
import software.amazon.awssdk.services.backupstorage.transform.ListChunksRequestMarshaller;
import software.amazon.awssdk.services.backupstorage.transform.ListObjectsRequestMarshaller;
import software.amazon.awssdk.services.backupstorage.transform.NotifyObjectCompleteRequestMarshaller;
import software.amazon.awssdk.services.backupstorage.transform.PutChunkRequestMarshaller;
import software.amazon.awssdk.services.backupstorage.transform.PutObjectRequestMarshaller;
import software.amazon.awssdk.services.backupstorage.transform.StartObjectRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultBackupStorageClient
implements BackupStorageClient {
    private static final Logger log = Logger.loggerFor(DefaultBackupStorageClient.class);
    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder().serviceProtocol(AwsServiceProtocol.REST_JSON).build();
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultBackupStorageClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteObjectResponse deleteObject(DeleteObjectRequest deleteObjectRequest) throws ServiceUnavailableException, ServiceInternalException, RetryableException, IllegalArgumentException, ResourceNotFoundException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException, BackupStorageException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteObjectResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteObjectRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultBackupStorageClient.resolveMetricPublishers(clientConfiguration, deleteObjectRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"BackupStorage");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteObject");
            DeleteObjectResponse deleteObjectResponse = (DeleteObjectResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteObject").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteObjectRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteObjectRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteObjectResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultBackupStorageClient.lambda$deleteObject$0((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <ReturnT> ReturnT getChunk(GetChunkRequest getChunkRequest, ResponseTransformer<GetChunkResponse, ReturnT> responseTransformer) throws IllegalArgumentException, RetryableException, ResourceNotFoundException, ServiceInternalException, ThrottlingException, KmsInvalidKeyUsageException, AccessDeniedException, AwsServiceException, SdkClientException, BackupStorageException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(true).isPayloadJson(false).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetChunkResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getChunkRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultBackupStorageClient.resolveMetricPublishers(clientConfiguration, getChunkRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"BackupStorage");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetChunk");
            Object object = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetChunk").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getChunkRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetChunkRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)), responseTransformer);
            return (ReturnT)object;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultBackupStorageClient.lambda$getChunk$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <ReturnT> ReturnT getObjectMetadata(GetObjectMetadataRequest getObjectMetadataRequest, ResponseTransformer<GetObjectMetadataResponse, ReturnT> responseTransformer) throws ServiceUnavailableException, ServiceInternalException, ResourceNotFoundException, RetryableException, IllegalArgumentException, ThrottlingException, KmsInvalidKeyUsageException, AccessDeniedException, AwsServiceException, SdkClientException, BackupStorageException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(true).isPayloadJson(false).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetObjectMetadataResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getObjectMetadataRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultBackupStorageClient.resolveMetricPublishers(clientConfiguration, getObjectMetadataRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"BackupStorage");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetObjectMetadata");
            Object object = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetObjectMetadata").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getObjectMetadataRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetObjectMetadataRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)), responseTransformer);
            return (ReturnT)object;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultBackupStorageClient.lambda$getObjectMetadata$2((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListChunksResponse listChunks(ListChunksRequest listChunksRequest) throws ServiceUnavailableException, ResourceNotFoundException, ServiceInternalException, RetryableException, IllegalArgumentException, AccessDeniedException, AwsServiceException, SdkClientException, BackupStorageException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListChunksResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listChunksRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultBackupStorageClient.resolveMetricPublishers(clientConfiguration, listChunksRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"BackupStorage");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListChunks");
            ListChunksResponse listChunksResponse = (ListChunksResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListChunks").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listChunksRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListChunksRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listChunksResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultBackupStorageClient.lambda$listChunks$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListObjectsResponse listObjects(ListObjectsRequest listObjectsRequest) throws ServiceUnavailableException, ServiceInternalException, RetryableException, IllegalArgumentException, ThrottlingException, ResourceNotFoundException, KmsInvalidKeyUsageException, AccessDeniedException, AwsServiceException, SdkClientException, BackupStorageException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListObjectsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listObjectsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultBackupStorageClient.resolveMetricPublishers(clientConfiguration, listObjectsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"BackupStorage");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListObjects");
            ListObjectsResponse listObjectsResponse = (ListObjectsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListObjects").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listObjectsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListObjectsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listObjectsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultBackupStorageClient.lambda$listObjects$4((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NotifyObjectCompleteResponse notifyObjectComplete(NotifyObjectCompleteRequest notifyObjectCompleteRequest, RequestBody requestBody) throws ServiceUnavailableException, ServiceInternalException, NotReadableInputStreamException, RetryableException, IllegalArgumentException, ThrottlingException, KmsInvalidKeyUsageException, AccessDeniedException, AwsServiceException, SdkClientException, BackupStorageException {
        notifyObjectCompleteRequest = this.applySignerOverride(notifyObjectCompleteRequest, (Signer)Aws4UnsignedPayloadSigner.create());
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, NotifyObjectCompleteResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)notifyObjectCompleteRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultBackupStorageClient.resolveMetricPublishers(clientConfiguration, notifyObjectCompleteRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"BackupStorage");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"NotifyObjectComplete");
            NotifyObjectCompleteResponse notifyObjectCompleteResponse = (NotifyObjectCompleteResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("NotifyObjectComplete").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)notifyObjectCompleteRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withRequestBody(requestBody).withMarshaller((Marshaller)((StreamingRequestMarshaller.Builder)((StreamingRequestMarshaller.Builder)StreamingRequestMarshaller.builder().delegateMarshaller((Marshaller)new NotifyObjectCompleteRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory))).requestBody(requestBody).transferEncoding(true)).build()));
            return notifyObjectCompleteResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultBackupStorageClient.lambda$notifyObjectComplete$5((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutChunkResponse putChunk(PutChunkRequest putChunkRequest, RequestBody requestBody) throws ServiceUnavailableException, ServiceInternalException, NotReadableInputStreamException, RetryableException, IllegalArgumentException, ThrottlingException, KmsInvalidKeyUsageException, AccessDeniedException, AwsServiceException, SdkClientException, BackupStorageException {
        putChunkRequest = this.applySignerOverride(putChunkRequest, (Signer)Aws4UnsignedPayloadSigner.create());
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutChunkResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putChunkRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultBackupStorageClient.resolveMetricPublishers(clientConfiguration, putChunkRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"BackupStorage");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutChunk");
            PutChunkResponse putChunkResponse = (PutChunkResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutChunk").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)putChunkRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withRequestBody(requestBody).withMarshaller((Marshaller)((StreamingRequestMarshaller.Builder)((StreamingRequestMarshaller.Builder)StreamingRequestMarshaller.builder().delegateMarshaller((Marshaller)new PutChunkRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory))).requestBody(requestBody).transferEncoding(true)).build()));
            return putChunkResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultBackupStorageClient.lambda$putChunk$6((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutObjectResponse putObject(PutObjectRequest putObjectRequest, RequestBody requestBody) throws ServiceUnavailableException, ServiceInternalException, NotReadableInputStreamException, RetryableException, IllegalArgumentException, ThrottlingException, KmsInvalidKeyUsageException, AccessDeniedException, AwsServiceException, SdkClientException, BackupStorageException {
        putObjectRequest = this.applySignerOverride(putObjectRequest, (Signer)Aws4UnsignedPayloadSigner.create());
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutObjectResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putObjectRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultBackupStorageClient.resolveMetricPublishers(clientConfiguration, putObjectRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"BackupStorage");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutObject");
            PutObjectResponse putObjectResponse = (PutObjectResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutObject").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)putObjectRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withRequestBody(requestBody).withMarshaller((Marshaller)((StreamingRequestMarshaller.Builder)((StreamingRequestMarshaller.Builder)StreamingRequestMarshaller.builder().delegateMarshaller((Marshaller)new PutObjectRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory))).requestBody(requestBody).transferEncoding(true)).build()));
            return putObjectResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultBackupStorageClient.lambda$putObject$7((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartObjectResponse startObject(StartObjectRequest startObjectRequest) throws ServiceUnavailableException, ServiceInternalException, RetryableException, IllegalArgumentException, ResourceNotFoundException, DataAlreadyExistsException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException, BackupStorageException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartObjectResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)startObjectRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultBackupStorageClient.resolveMetricPublishers(clientConfiguration, startObjectRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"BackupStorage");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartObject");
            StartObjectResponse startObjectResponse = (StartObjectResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartObject").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)startObjectRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StartObjectRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return startObjectResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultBackupStorageClient.lambda$startObject$8((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    private <T extends BackupStorageRequest> T applySignerOverride(T request, Signer signer) {
        if (request.overrideConfiguration().flatMap(c -> c.signer()).isPresent()) {
            return request;
        }
        Consumer<AwsRequestOverrideConfiguration.Builder> signerOverride = b -> ((AwsRequestOverrideConfiguration.Builder)b.signer(signer)).build();
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(signerOverride)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(signerOverride)).build());
        return (T)((Object)((BackupStorageRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    public final String serviceName() {
        return "backup-storage";
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        if (plugins.isEmpty()) {
            return clientConfiguration;
        }
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        BackupStorageServiceClientConfigurationBuilder serviceConfigBuilder = new BackupStorageServiceClientConfigurationBuilder(configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient((SdkServiceClientConfiguration.Builder)serviceConfigBuilder);
        }
        return configuration.build();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(BackupStorageException::builder).protocol(AwsJsonProtocol.REST_JSON).protocolVersion("1.1").registerModeledException(ExceptionMetadata.builder().errorCode("AccessDeniedException").exceptionBuilderSupplier(AccessDeniedException::builder).httpStatusCode(Integer.valueOf(403)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("KMSInvalidKeyUsageException").exceptionBuilderSupplier(KmsInvalidKeyUsageException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").exceptionBuilderSupplier(ServiceUnavailableException::builder).httpStatusCode(Integer.valueOf(503)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("NotReadableInputStreamException").exceptionBuilderSupplier(NotReadableInputStreamException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("IllegalArgumentException").exceptionBuilderSupplier(IllegalArgumentException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DataAlreadyExistsException").exceptionBuilderSupplier(DataAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ServiceInternalException").exceptionBuilderSupplier(ServiceInternalException::builder).httpStatusCode(Integer.valueOf(500)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("RetryableException").exceptionBuilderSupplier(RetryableException::builder).httpStatusCode(Integer.valueOf(500)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ThrottlingException").exceptionBuilderSupplier(ThrottlingException::builder).httpStatusCode(Integer.valueOf(429)).build());
    }

    @Override
    public final BackupStorageServiceClientConfiguration serviceClientConfiguration() {
        return new BackupStorageServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$startObject$8(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putObject$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putChunk$6(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$notifyObjectComplete$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listObjects$4(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listChunks$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getObjectMetadata$2(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getChunk$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteObject$0(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

