/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backupstorage.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.backupstorage.model.BackupStorageRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListObjectsRequest
extends BackupStorageRequest
implements ToCopyableBuilder<Builder, ListObjectsRequest> {
    private static final SdkField<String> STORAGE_JOB_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StorageJobId").getter(ListObjectsRequest.getter(ListObjectsRequest::storageJobId)).setter(ListObjectsRequest.setter(Builder::storageJobId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("jobId").build()}).build();
    private static final SdkField<String> STARTING_OBJECT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StartingObjectName").getter(ListObjectsRequest.getter(ListObjectsRequest::startingObjectName)).setter(ListObjectsRequest.setter(Builder::startingObjectName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("starting-object-name").build()}).build();
    private static final SdkField<String> STARTING_OBJECT_PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StartingObjectPrefix").getter(ListObjectsRequest.getter(ListObjectsRequest::startingObjectPrefix)).setter(ListObjectsRequest.setter(Builder::startingObjectPrefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("starting-object-prefix").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(ListObjectsRequest.getter(ListObjectsRequest::maxResults)).setter(ListObjectsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("max-results").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListObjectsRequest.getter(ListObjectsRequest::nextToken)).setter(ListObjectsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("next-token").build()}).build();
    private static final SdkField<Instant> CREATED_BEFORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedBefore").getter(ListObjectsRequest.getter(ListObjectsRequest::createdBefore)).setter(ListObjectsRequest.setter(Builder::createdBefore)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("created-before").build()}).build();
    private static final SdkField<Instant> CREATED_AFTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedAfter").getter(ListObjectsRequest.getter(ListObjectsRequest::createdAfter)).setter(ListObjectsRequest.setter(Builder::createdAfter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("created-after").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STORAGE_JOB_ID_FIELD, STARTING_OBJECT_NAME_FIELD, STARTING_OBJECT_PREFIX_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, CREATED_BEFORE_FIELD, CREATED_AFTER_FIELD));
    private final String storageJobId;
    private final String startingObjectName;
    private final String startingObjectPrefix;
    private final Integer maxResults;
    private final String nextToken;
    private final Instant createdBefore;
    private final Instant createdAfter;

    private ListObjectsRequest(BuilderImpl builder) {
        super(builder);
        this.storageJobId = builder.storageJobId;
        this.startingObjectName = builder.startingObjectName;
        this.startingObjectPrefix = builder.startingObjectPrefix;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.createdBefore = builder.createdBefore;
        this.createdAfter = builder.createdAfter;
    }

    public final String storageJobId() {
        return this.storageJobId;
    }

    public final String startingObjectName() {
        return this.startingObjectName;
    }

    public final String startingObjectPrefix() {
        return this.startingObjectPrefix;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Instant createdBefore() {
        return this.createdBefore;
    }

    public final Instant createdAfter() {
        return this.createdAfter;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.storageJobId());
        hashCode = 31 * hashCode + Objects.hashCode(this.startingObjectName());
        hashCode = 31 * hashCode + Objects.hashCode(this.startingObjectPrefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdBefore());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAfter());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListObjectsRequest)) {
            return false;
        }
        ListObjectsRequest other = (ListObjectsRequest)((Object)obj);
        return Objects.equals(this.storageJobId(), other.storageJobId()) && Objects.equals(this.startingObjectName(), other.startingObjectName()) && Objects.equals(this.startingObjectPrefix(), other.startingObjectPrefix()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.createdBefore(), other.createdBefore()) && Objects.equals(this.createdAfter(), other.createdAfter());
    }

    public final String toString() {
        return ToString.builder((String)"ListObjectsRequest").add("StorageJobId", (Object)this.storageJobId()).add("StartingObjectName", (Object)this.startingObjectName()).add("StartingObjectPrefix", (Object)this.startingObjectPrefix()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).add("CreatedBefore", (Object)this.createdBefore()).add("CreatedAfter", (Object)this.createdAfter()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StorageJobId": {
                return Optional.ofNullable(clazz.cast(this.storageJobId()));
            }
            case "StartingObjectName": {
                return Optional.ofNullable(clazz.cast(this.startingObjectName()));
            }
            case "StartingObjectPrefix": {
                return Optional.ofNullable(clazz.cast(this.startingObjectPrefix()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "CreatedBefore": {
                return Optional.ofNullable(clazz.cast(this.createdBefore()));
            }
            case "CreatedAfter": {
                return Optional.ofNullable(clazz.cast(this.createdAfter()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListObjectsRequest, T> g) {
        return obj -> g.apply((ListObjectsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BackupStorageRequest.BuilderImpl
    implements Builder {
        private String storageJobId;
        private String startingObjectName;
        private String startingObjectPrefix;
        private Integer maxResults;
        private String nextToken;
        private Instant createdBefore;
        private Instant createdAfter;

        private BuilderImpl() {
        }

        private BuilderImpl(ListObjectsRequest model) {
            super(model);
            this.storageJobId(model.storageJobId);
            this.startingObjectName(model.startingObjectName);
            this.startingObjectPrefix(model.startingObjectPrefix);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
            this.createdBefore(model.createdBefore);
            this.createdAfter(model.createdAfter);
        }

        public final String getStorageJobId() {
            return this.storageJobId;
        }

        public final void setStorageJobId(String storageJobId) {
            this.storageJobId = storageJobId;
        }

        @Override
        public final Builder storageJobId(String storageJobId) {
            this.storageJobId = storageJobId;
            return this;
        }

        public final String getStartingObjectName() {
            return this.startingObjectName;
        }

        public final void setStartingObjectName(String startingObjectName) {
            this.startingObjectName = startingObjectName;
        }

        @Override
        public final Builder startingObjectName(String startingObjectName) {
            this.startingObjectName = startingObjectName;
            return this;
        }

        public final String getStartingObjectPrefix() {
            return this.startingObjectPrefix;
        }

        public final void setStartingObjectPrefix(String startingObjectPrefix) {
            this.startingObjectPrefix = startingObjectPrefix;
        }

        @Override
        public final Builder startingObjectPrefix(String startingObjectPrefix) {
            this.startingObjectPrefix = startingObjectPrefix;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Instant getCreatedBefore() {
            return this.createdBefore;
        }

        public final void setCreatedBefore(Instant createdBefore) {
            this.createdBefore = createdBefore;
        }

        @Override
        public final Builder createdBefore(Instant createdBefore) {
            this.createdBefore = createdBefore;
            return this;
        }

        public final Instant getCreatedAfter() {
            return this.createdAfter;
        }

        public final void setCreatedAfter(Instant createdAfter) {
            this.createdAfter = createdAfter;
        }

        @Override
        public final Builder createdAfter(Instant createdAfter) {
            this.createdAfter = createdAfter;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListObjectsRequest build() {
            return new ListObjectsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends BackupStorageRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListObjectsRequest> {
        public Builder storageJobId(String var1);

        public Builder startingObjectName(String var1);

        public Builder startingObjectPrefix(String var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder createdBefore(Instant var1);

        public Builder createdAfter(Instant var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

