/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backupstorage.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.backupstorage.BackupStorageAsyncClient;
import software.amazon.awssdk.services.backupstorage.internal.UserAgentUtils;
import software.amazon.awssdk.services.backupstorage.model.ListObjectsRequest;
import software.amazon.awssdk.services.backupstorage.model.ListObjectsResponse;

public class ListObjectsPublisher
implements SdkPublisher<ListObjectsResponse> {
    private final BackupStorageAsyncClient client;
    private final ListObjectsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListObjectsPublisher(BackupStorageAsyncClient client, ListObjectsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListObjectsPublisher(BackupStorageAsyncClient client, ListObjectsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListObjectsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListObjectsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListObjectsResponseFetcher
    implements AsyncPageFetcher<ListObjectsResponse> {
        private ListObjectsResponseFetcher() {
        }

        public boolean hasNextPage(ListObjectsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListObjectsResponse> nextPage(ListObjectsResponse previousPage) {
            if (previousPage == null) {
                return ListObjectsPublisher.this.client.listObjects(ListObjectsPublisher.this.firstRequest);
            }
            return ListObjectsPublisher.this.client.listObjects((ListObjectsRequest)((Object)ListObjectsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

