/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backupstorage.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.backupstorage.model.BackupStorageResponse;
import software.amazon.awssdk.services.backupstorage.model.DataChecksumAlgorithm;
import software.amazon.awssdk.services.backupstorage.model.SummaryChecksumAlgorithm;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutObjectResponse
extends BackupStorageResponse
implements ToCopyableBuilder<Builder, PutObjectResponse> {
    private static final SdkField<String> INLINE_CHUNK_CHECKSUM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InlineChunkChecksum").getter(PutObjectResponse.getter(PutObjectResponse::inlineChunkChecksum)).setter(PutObjectResponse.setter(Builder::inlineChunkChecksum)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InlineChunkChecksum").build()}).build();
    private static final SdkField<String> INLINE_CHUNK_CHECKSUM_ALGORITHM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InlineChunkChecksumAlgorithm").getter(PutObjectResponse.getter(PutObjectResponse::inlineChunkChecksumAlgorithmAsString)).setter(PutObjectResponse.setter(Builder::inlineChunkChecksumAlgorithm)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InlineChunkChecksumAlgorithm").build()}).build();
    private static final SdkField<String> OBJECT_CHECKSUM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ObjectChecksum").getter(PutObjectResponse.getter(PutObjectResponse::objectChecksum)).setter(PutObjectResponse.setter(Builder::objectChecksum)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ObjectChecksum").build()}).build();
    private static final SdkField<String> OBJECT_CHECKSUM_ALGORITHM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ObjectChecksumAlgorithm").getter(PutObjectResponse.getter(PutObjectResponse::objectChecksumAlgorithmAsString)).setter(PutObjectResponse.setter(Builder::objectChecksumAlgorithm)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ObjectChecksumAlgorithm").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INLINE_CHUNK_CHECKSUM_FIELD, INLINE_CHUNK_CHECKSUM_ALGORITHM_FIELD, OBJECT_CHECKSUM_FIELD, OBJECT_CHECKSUM_ALGORITHM_FIELD));
    private final String inlineChunkChecksum;
    private final String inlineChunkChecksumAlgorithm;
    private final String objectChecksum;
    private final String objectChecksumAlgorithm;

    private PutObjectResponse(BuilderImpl builder) {
        super(builder);
        this.inlineChunkChecksum = builder.inlineChunkChecksum;
        this.inlineChunkChecksumAlgorithm = builder.inlineChunkChecksumAlgorithm;
        this.objectChecksum = builder.objectChecksum;
        this.objectChecksumAlgorithm = builder.objectChecksumAlgorithm;
    }

    public final String inlineChunkChecksum() {
        return this.inlineChunkChecksum;
    }

    public final DataChecksumAlgorithm inlineChunkChecksumAlgorithm() {
        return DataChecksumAlgorithm.fromValue(this.inlineChunkChecksumAlgorithm);
    }

    public final String inlineChunkChecksumAlgorithmAsString() {
        return this.inlineChunkChecksumAlgorithm;
    }

    public final String objectChecksum() {
        return this.objectChecksum;
    }

    public final SummaryChecksumAlgorithm objectChecksumAlgorithm() {
        return SummaryChecksumAlgorithm.fromValue(this.objectChecksumAlgorithm);
    }

    public final String objectChecksumAlgorithmAsString() {
        return this.objectChecksumAlgorithm;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.inlineChunkChecksum());
        hashCode = 31 * hashCode + Objects.hashCode(this.inlineChunkChecksumAlgorithmAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.objectChecksum());
        hashCode = 31 * hashCode + Objects.hashCode(this.objectChecksumAlgorithmAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutObjectResponse)) {
            return false;
        }
        PutObjectResponse other = (PutObjectResponse)((Object)obj);
        return Objects.equals(this.inlineChunkChecksum(), other.inlineChunkChecksum()) && Objects.equals(this.inlineChunkChecksumAlgorithmAsString(), other.inlineChunkChecksumAlgorithmAsString()) && Objects.equals(this.objectChecksum(), other.objectChecksum()) && Objects.equals(this.objectChecksumAlgorithmAsString(), other.objectChecksumAlgorithmAsString());
    }

    public final String toString() {
        return ToString.builder((String)"PutObjectResponse").add("InlineChunkChecksum", (Object)this.inlineChunkChecksum()).add("InlineChunkChecksumAlgorithm", (Object)this.inlineChunkChecksumAlgorithmAsString()).add("ObjectChecksum", (Object)this.objectChecksum()).add("ObjectChecksumAlgorithm", (Object)this.objectChecksumAlgorithmAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InlineChunkChecksum": {
                return Optional.ofNullable(clazz.cast(this.inlineChunkChecksum()));
            }
            case "InlineChunkChecksumAlgorithm": {
                return Optional.ofNullable(clazz.cast(this.inlineChunkChecksumAlgorithmAsString()));
            }
            case "ObjectChecksum": {
                return Optional.ofNullable(clazz.cast(this.objectChecksum()));
            }
            case "ObjectChecksumAlgorithm": {
                return Optional.ofNullable(clazz.cast(this.objectChecksumAlgorithmAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutObjectResponse, T> g) {
        return obj -> g.apply((PutObjectResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BackupStorageResponse.BuilderImpl
    implements Builder {
        private String inlineChunkChecksum;
        private String inlineChunkChecksumAlgorithm;
        private String objectChecksum;
        private String objectChecksumAlgorithm;

        private BuilderImpl() {
        }

        private BuilderImpl(PutObjectResponse model) {
            super(model);
            this.inlineChunkChecksum(model.inlineChunkChecksum);
            this.inlineChunkChecksumAlgorithm(model.inlineChunkChecksumAlgorithm);
            this.objectChecksum(model.objectChecksum);
            this.objectChecksumAlgorithm(model.objectChecksumAlgorithm);
        }

        public final String getInlineChunkChecksum() {
            return this.inlineChunkChecksum;
        }

        public final void setInlineChunkChecksum(String inlineChunkChecksum) {
            this.inlineChunkChecksum = inlineChunkChecksum;
        }

        @Override
        public final Builder inlineChunkChecksum(String inlineChunkChecksum) {
            this.inlineChunkChecksum = inlineChunkChecksum;
            return this;
        }

        public final String getInlineChunkChecksumAlgorithm() {
            return this.inlineChunkChecksumAlgorithm;
        }

        public final void setInlineChunkChecksumAlgorithm(String inlineChunkChecksumAlgorithm) {
            this.inlineChunkChecksumAlgorithm = inlineChunkChecksumAlgorithm;
        }

        @Override
        public final Builder inlineChunkChecksumAlgorithm(String inlineChunkChecksumAlgorithm) {
            this.inlineChunkChecksumAlgorithm = inlineChunkChecksumAlgorithm;
            return this;
        }

        @Override
        public final Builder inlineChunkChecksumAlgorithm(DataChecksumAlgorithm inlineChunkChecksumAlgorithm) {
            this.inlineChunkChecksumAlgorithm(inlineChunkChecksumAlgorithm == null ? null : inlineChunkChecksumAlgorithm.toString());
            return this;
        }

        public final String getObjectChecksum() {
            return this.objectChecksum;
        }

        public final void setObjectChecksum(String objectChecksum) {
            this.objectChecksum = objectChecksum;
        }

        @Override
        public final Builder objectChecksum(String objectChecksum) {
            this.objectChecksum = objectChecksum;
            return this;
        }

        public final String getObjectChecksumAlgorithm() {
            return this.objectChecksumAlgorithm;
        }

        public final void setObjectChecksumAlgorithm(String objectChecksumAlgorithm) {
            this.objectChecksumAlgorithm = objectChecksumAlgorithm;
        }

        @Override
        public final Builder objectChecksumAlgorithm(String objectChecksumAlgorithm) {
            this.objectChecksumAlgorithm = objectChecksumAlgorithm;
            return this;
        }

        @Override
        public final Builder objectChecksumAlgorithm(SummaryChecksumAlgorithm objectChecksumAlgorithm) {
            this.objectChecksumAlgorithm(objectChecksumAlgorithm == null ? null : objectChecksumAlgorithm.toString());
            return this;
        }

        @Override
        public PutObjectResponse build() {
            return new PutObjectResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends BackupStorageResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutObjectResponse> {
        public Builder inlineChunkChecksum(String var1);

        public Builder inlineChunkChecksumAlgorithm(String var1);

        public Builder inlineChunkChecksumAlgorithm(DataChecksumAlgorithm var1);

        public Builder objectChecksum(String var1);

        public Builder objectChecksumAlgorithm(String var1);

        public Builder objectChecksumAlgorithm(SummaryChecksumAlgorithm var1);
    }
}

