/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backupstorage.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.backupstorage.model.BackupStorageResponse;
import software.amazon.awssdk.services.backupstorage.model.SummaryChecksumAlgorithm;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NotifyObjectCompleteResponse
extends BackupStorageResponse
implements ToCopyableBuilder<Builder, NotifyObjectCompleteResponse> {
    private static final SdkField<String> OBJECT_CHECKSUM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ObjectChecksum").getter(NotifyObjectCompleteResponse.getter(NotifyObjectCompleteResponse::objectChecksum)).setter(NotifyObjectCompleteResponse.setter(Builder::objectChecksum)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ObjectChecksum").build()}).build();
    private static final SdkField<String> OBJECT_CHECKSUM_ALGORITHM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ObjectChecksumAlgorithm").getter(NotifyObjectCompleteResponse.getter(NotifyObjectCompleteResponse::objectChecksumAlgorithmAsString)).setter(NotifyObjectCompleteResponse.setter(Builder::objectChecksumAlgorithm)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ObjectChecksumAlgorithm").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OBJECT_CHECKSUM_FIELD, OBJECT_CHECKSUM_ALGORITHM_FIELD));
    private final String objectChecksum;
    private final String objectChecksumAlgorithm;

    private NotifyObjectCompleteResponse(BuilderImpl builder) {
        super(builder);
        this.objectChecksum = builder.objectChecksum;
        this.objectChecksumAlgorithm = builder.objectChecksumAlgorithm;
    }

    public final String objectChecksum() {
        return this.objectChecksum;
    }

    public final SummaryChecksumAlgorithm objectChecksumAlgorithm() {
        return SummaryChecksumAlgorithm.fromValue(this.objectChecksumAlgorithm);
    }

    public final String objectChecksumAlgorithmAsString() {
        return this.objectChecksumAlgorithm;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.objectChecksum());
        hashCode = 31 * hashCode + Objects.hashCode(this.objectChecksumAlgorithmAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NotifyObjectCompleteResponse)) {
            return false;
        }
        NotifyObjectCompleteResponse other = (NotifyObjectCompleteResponse)((Object)obj);
        return Objects.equals(this.objectChecksum(), other.objectChecksum()) && Objects.equals(this.objectChecksumAlgorithmAsString(), other.objectChecksumAlgorithmAsString());
    }

    public final String toString() {
        return ToString.builder((String)"NotifyObjectCompleteResponse").add("ObjectChecksum", (Object)this.objectChecksum()).add("ObjectChecksumAlgorithm", (Object)this.objectChecksumAlgorithmAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ObjectChecksum": {
                return Optional.ofNullable(clazz.cast(this.objectChecksum()));
            }
            case "ObjectChecksumAlgorithm": {
                return Optional.ofNullable(clazz.cast(this.objectChecksumAlgorithmAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NotifyObjectCompleteResponse, T> g) {
        return obj -> g.apply((NotifyObjectCompleteResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BackupStorageResponse.BuilderImpl
    implements Builder {
        private String objectChecksum;
        private String objectChecksumAlgorithm;

        private BuilderImpl() {
        }

        private BuilderImpl(NotifyObjectCompleteResponse model) {
            super(model);
            this.objectChecksum(model.objectChecksum);
            this.objectChecksumAlgorithm(model.objectChecksumAlgorithm);
        }

        public final String getObjectChecksum() {
            return this.objectChecksum;
        }

        public final void setObjectChecksum(String objectChecksum) {
            this.objectChecksum = objectChecksum;
        }

        @Override
        public final Builder objectChecksum(String objectChecksum) {
            this.objectChecksum = objectChecksum;
            return this;
        }

        public final String getObjectChecksumAlgorithm() {
            return this.objectChecksumAlgorithm;
        }

        public final void setObjectChecksumAlgorithm(String objectChecksumAlgorithm) {
            this.objectChecksumAlgorithm = objectChecksumAlgorithm;
        }

        @Override
        public final Builder objectChecksumAlgorithm(String objectChecksumAlgorithm) {
            this.objectChecksumAlgorithm = objectChecksumAlgorithm;
            return this;
        }

        @Override
        public final Builder objectChecksumAlgorithm(SummaryChecksumAlgorithm objectChecksumAlgorithm) {
            this.objectChecksumAlgorithm(objectChecksumAlgorithm == null ? null : objectChecksumAlgorithm.toString());
            return this;
        }

        @Override
        public NotifyObjectCompleteResponse build() {
            return new NotifyObjectCompleteResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends BackupStorageResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, NotifyObjectCompleteResponse> {
        public Builder objectChecksum(String var1);

        public Builder objectChecksumAlgorithm(String var1);

        public Builder objectChecksumAlgorithm(SummaryChecksumAlgorithm var1);
    }
}

