/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.batch.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeJobQueuesRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<DescribeJobQueuesRequest.Builder, DescribeJobQueuesRequest> {
    private final List<String> jobQueues;

    private final Integer maxResults;

    private final String nextToken;

    private DescribeJobQueuesRequest(BuilderImpl builder) {
        this.jobQueues = builder.jobQueues;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * A list of up to 100 queue names or full queue Amazon Resource Name (ARN) entries.
     * </p>
     * 
     * @return A list of up to 100 queue names or full queue Amazon Resource Name (ARN) entries.
     */
    public List<String> jobQueues() {
        return jobQueues;
    }

    /**
     * <p>
     * The maximum number of results returned by <code>DescribeJobQueues</code> in paginated output. When this parameter
     * is used, <code>DescribeJobQueues</code> only returns <code>maxResults</code> results in a single page along with
     * a <code>nextToken</code> response element. The remaining results of the initial request can be seen by sending
     * another <code>DescribeJobQueues</code> request with the returned <code>nextToken</code> value. This value can be
     * between 1 and 100. If this parameter is not used, then <code>DescribeJobQueues</code> returns up to 100 results
     * and a <code>nextToken</code> value if applicable.
     * </p>
     * 
     * @return The maximum number of results returned by <code>DescribeJobQueues</code> in paginated output. When this
     *         parameter is used, <code>DescribeJobQueues</code> only returns <code>maxResults</code> results in a
     *         single page along with a <code>nextToken</code> response element. The remaining results of the initial
     *         request can be seen by sending another <code>DescribeJobQueues</code> request with the returned
     *         <code>nextToken</code> value. This value can be between 1 and 100. If this parameter is not used, then
     *         <code>DescribeJobQueues</code> returns up to 100 results and a <code>nextToken</code> value if
     *         applicable.
     */
    public Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The <code>nextToken</code> value returned from a previous paginated <code>DescribeJobQueues</code> request where
     * <code>maxResults</code> was used and the results exceeded the value of that parameter. Pagination continues from
     * the end of the previous results that returned the <code>nextToken</code> value. This value is <code>null</code>
     * when there are no more results to return.
     * </p>
     * <note>
     * <p>
     * This token should be treated as an opaque identifier that is only used to retrieve the next items in a list and
     * not for other programmatic purposes.
     * </p>
     * </note>
     * 
     * @return The <code>nextToken</code> value returned from a previous paginated <code>DescribeJobQueues</code>
     *         request where <code>maxResults</code> was used and the results exceeded the value of that parameter.
     *         Pagination continues from the end of the previous results that returned the <code>nextToken</code> value.
     *         This value is <code>null</code> when there are no more results to return.</p> <note>
     *         <p>
     *         This token should be treated as an opaque identifier that is only used to retrieve the next items in a
     *         list and not for other programmatic purposes.
     *         </p>
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((jobQueues() == null) ? 0 : jobQueues().hashCode());
        hashCode = 31 * hashCode + ((maxResults() == null) ? 0 : maxResults().hashCode());
        hashCode = 31 * hashCode + ((nextToken() == null) ? 0 : nextToken().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeJobQueuesRequest)) {
            return false;
        }
        DescribeJobQueuesRequest other = (DescribeJobQueuesRequest) obj;
        if (other.jobQueues() == null ^ this.jobQueues() == null) {
            return false;
        }
        if (other.jobQueues() != null && !other.jobQueues().equals(this.jobQueues())) {
            return false;
        }
        if (other.maxResults() == null ^ this.maxResults() == null) {
            return false;
        }
        if (other.maxResults() != null && !other.maxResults().equals(this.maxResults())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (jobQueues() != null) {
            sb.append("JobQueues: ").append(jobQueues()).append(",");
        }
        if (maxResults() != null) {
            sb.append("MaxResults: ").append(maxResults()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeJobQueuesRequest> {
        /**
         * <p>
         * A list of up to 100 queue names or full queue Amazon Resource Name (ARN) entries.
         * </p>
         * 
         * @param jobQueues
         *        A list of up to 100 queue names or full queue Amazon Resource Name (ARN) entries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobQueues(Collection<String> jobQueues);

        /**
         * <p>
         * A list of up to 100 queue names or full queue Amazon Resource Name (ARN) entries.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setJobQueues(java.util.Collection)} or {@link #withJobQueues(java.util.Collection)} if you want to
         * override the existing values.
         * </p>
         * 
         * @param jobQueues
         *        A list of up to 100 queue names or full queue Amazon Resource Name (ARN) entries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobQueues(String... jobQueues);

        /**
         * <p>
         * The maximum number of results returned by <code>DescribeJobQueues</code> in paginated output. When this
         * parameter is used, <code>DescribeJobQueues</code> only returns <code>maxResults</code> results in a single
         * page along with a <code>nextToken</code> response element. The remaining results of the initial request can
         * be seen by sending another <code>DescribeJobQueues</code> request with the returned <code>nextToken</code>
         * value. This value can be between 1 and 100. If this parameter is not used, then
         * <code>DescribeJobQueues</code> returns up to 100 results and a <code>nextToken</code> value if applicable.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results returned by <code>DescribeJobQueues</code> in paginated output. When
         *        this parameter is used, <code>DescribeJobQueues</code> only returns <code>maxResults</code> results in
         *        a single page along with a <code>nextToken</code> response element. The remaining results of the
         *        initial request can be seen by sending another <code>DescribeJobQueues</code> request with the
         *        returned <code>nextToken</code> value. This value can be between 1 and 100. If this parameter is not
         *        used, then <code>DescribeJobQueues</code> returns up to 100 results and a <code>nextToken</code> value
         *        if applicable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The <code>nextToken</code> value returned from a previous paginated <code>DescribeJobQueues</code> request
         * where <code>maxResults</code> was used and the results exceeded the value of that parameter. Pagination
         * continues from the end of the previous results that returned the <code>nextToken</code> value. This value is
         * <code>null</code> when there are no more results to return.
         * </p>
         * <note>
         * <p>
         * This token should be treated as an opaque identifier that is only used to retrieve the next items in a list
         * and not for other programmatic purposes.
         * </p>
         * </note>
         * 
         * @param nextToken
         *        The <code>nextToken</code> value returned from a previous paginated <code>DescribeJobQueues</code>
         *        request where <code>maxResults</code> was used and the results exceeded the value of that parameter.
         *        Pagination continues from the end of the previous results that returned the <code>nextToken</code>
         *        value. This value is <code>null</code> when there are no more results to return.</p> <note>
         *        <p>
         *        This token should be treated as an opaque identifier that is only used to retrieve the next items in a
         *        list and not for other programmatic purposes.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    private static final class BuilderImpl implements Builder {
        private List<String> jobQueues;

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeJobQueuesRequest model) {
            setJobQueues(model.jobQueues);
            setMaxResults(model.maxResults);
            setNextToken(model.nextToken);
        }

        public final Collection<String> getJobQueues() {
            return jobQueues;
        }

        @Override
        public final Builder jobQueues(Collection<String> jobQueues) {
            this.jobQueues = StringListCopier.copy(jobQueues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobQueues(String... jobQueues) {
            if (this.jobQueues == null) {
                this.jobQueues = new ArrayList<>(jobQueues.length);
            }
            for (String e : jobQueues) {
                this.jobQueues.add(e);
            }
            return this;
        }

        public final void setJobQueues(Collection<String> jobQueues) {
            this.jobQueues = StringListCopier.copy(jobQueues);
        }

        @SafeVarargs
        public final void setJobQueues(String... jobQueues) {
            if (this.jobQueues == null) {
                this.jobQueues = new ArrayList<>(jobQueues.length);
            }
            for (String e : jobQueues) {
                this.jobQueues.add(e);
            }
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeJobQueuesRequest build() {
            return new DescribeJobQueuesRequest(this);
        }
    }
}
