/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.batch.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeJobQueuesResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<DescribeJobQueuesResponse.Builder, DescribeJobQueuesResponse> {
    private final List<JobQueueDetail> jobQueues;

    private final String nextToken;

    private DescribeJobQueuesResponse(BuilderImpl builder) {
        this.jobQueues = builder.jobQueues;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The list of job queues.
     * </p>
     * 
     * @return The list of job queues.
     */
    public List<JobQueueDetail> jobQueues() {
        return jobQueues;
    }

    /**
     * <p>
     * The <code>nextToken</code> value to include in a future <code>DescribeJobQueues</code> request. When the results
     * of a <code>DescribeJobQueues</code> request exceed <code>maxResults</code>, this value can be used to retrieve
     * the next page of results. This value is <code>null</code> when there are no more results to return.
     * </p>
     * 
     * @return The <code>nextToken</code> value to include in a future <code>DescribeJobQueues</code> request. When the
     *         results of a <code>DescribeJobQueues</code> request exceed <code>maxResults</code>, this value can be
     *         used to retrieve the next page of results. This value is <code>null</code> when there are no more results
     *         to return.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((jobQueues() == null) ? 0 : jobQueues().hashCode());
        hashCode = 31 * hashCode + ((nextToken() == null) ? 0 : nextToken().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeJobQueuesResponse)) {
            return false;
        }
        DescribeJobQueuesResponse other = (DescribeJobQueuesResponse) obj;
        if (other.jobQueues() == null ^ this.jobQueues() == null) {
            return false;
        }
        if (other.jobQueues() != null && !other.jobQueues().equals(this.jobQueues())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (jobQueues() != null) {
            sb.append("JobQueues: ").append(jobQueues()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeJobQueuesResponse> {
        /**
         * <p>
         * The list of job queues.
         * </p>
         * 
         * @param jobQueues
         *        The list of job queues.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobQueues(Collection<JobQueueDetail> jobQueues);

        /**
         * <p>
         * The list of job queues.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setJobQueues(java.util.Collection)} or {@link #withJobQueues(java.util.Collection)} if you want to
         * override the existing values.
         * </p>
         * 
         * @param jobQueues
         *        The list of job queues.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobQueues(JobQueueDetail... jobQueues);

        /**
         * <p>
         * The <code>nextToken</code> value to include in a future <code>DescribeJobQueues</code> request. When the
         * results of a <code>DescribeJobQueues</code> request exceed <code>maxResults</code>, this value can be used to
         * retrieve the next page of results. This value is <code>null</code> when there are no more results to return.
         * </p>
         * 
         * @param nextToken
         *        The <code>nextToken</code> value to include in a future <code>DescribeJobQueues</code> request. When
         *        the results of a <code>DescribeJobQueues</code> request exceed <code>maxResults</code>, this value can
         *        be used to retrieve the next page of results. This value is <code>null</code> when there are no more
         *        results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    private static final class BuilderImpl implements Builder {
        private List<JobQueueDetail> jobQueues;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeJobQueuesResponse model) {
            setJobQueues(model.jobQueues);
            setNextToken(model.nextToken);
        }

        public final Collection<JobQueueDetail> getJobQueues() {
            return jobQueues;
        }

        @Override
        public final Builder jobQueues(Collection<JobQueueDetail> jobQueues) {
            this.jobQueues = JobQueueDetailListCopier.copy(jobQueues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobQueues(JobQueueDetail... jobQueues) {
            if (this.jobQueues == null) {
                this.jobQueues = new ArrayList<>(jobQueues.length);
            }
            for (JobQueueDetail e : jobQueues) {
                this.jobQueues.add(e);
            }
            return this;
        }

        public final void setJobQueues(Collection<JobQueueDetail> jobQueues) {
            this.jobQueues = JobQueueDetailListCopier.copy(jobQueues);
        }

        @SafeVarargs
        public final void setJobQueues(JobQueueDetail... jobQueues) {
            if (this.jobQueues == null) {
                this.jobQueues = new ArrayList<>(jobQueues.length);
            }
            for (JobQueueDetail e : jobQueues) {
                this.jobQueues.add(e);
            }
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeJobQueuesResponse build() {
            return new DescribeJobQueuesResponse(this);
        }
    }
}
