/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.batch.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeJobsRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<DescribeJobsRequest.Builder, DescribeJobsRequest> {
    private final List<String> jobs;

    private DescribeJobsRequest(BuilderImpl builder) {
        this.jobs = builder.jobs;
    }

    /**
     * <p>
     * A space-separated list of up to 100 job IDs.
     * </p>
     * 
     * @return A space-separated list of up to 100 job IDs.
     */
    public List<String> jobs() {
        return jobs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((jobs() == null) ? 0 : jobs().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeJobsRequest)) {
            return false;
        }
        DescribeJobsRequest other = (DescribeJobsRequest) obj;
        if (other.jobs() == null ^ this.jobs() == null) {
            return false;
        }
        if (other.jobs() != null && !other.jobs().equals(this.jobs())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (jobs() != null) {
            sb.append("Jobs: ").append(jobs()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeJobsRequest> {
        /**
         * <p>
         * A space-separated list of up to 100 job IDs.
         * </p>
         * 
         * @param jobs
         *        A space-separated list of up to 100 job IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobs(Collection<String> jobs);

        /**
         * <p>
         * A space-separated list of up to 100 job IDs.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setJobs(java.util.Collection)} or {@link #withJobs(java.util.Collection)} if you want to override the
         * existing values.
         * </p>
         * 
         * @param jobs
         *        A space-separated list of up to 100 job IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobs(String... jobs);
    }

    private static final class BuilderImpl implements Builder {
        private List<String> jobs;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeJobsRequest model) {
            setJobs(model.jobs);
        }

        public final Collection<String> getJobs() {
            return jobs;
        }

        @Override
        public final Builder jobs(Collection<String> jobs) {
            this.jobs = StringListCopier.copy(jobs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobs(String... jobs) {
            if (this.jobs == null) {
                this.jobs = new ArrayList<>(jobs.length);
            }
            for (String e : jobs) {
                this.jobs.add(e);
            }
            return this;
        }

        public final void setJobs(Collection<String> jobs) {
            this.jobs = StringListCopier.copy(jobs);
        }

        @SafeVarargs
        public final void setJobs(String... jobs) {
            if (this.jobs == null) {
                this.jobs = new ArrayList<>(jobs.length);
            }
            for (String e : jobs) {
                this.jobs.add(e);
            }
        }

        @Override
        public DescribeJobsRequest build() {
            return new DescribeJobsRequest(this);
        }
    }
}
