/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.batch.model;

import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.batch.transform.RetryStrategyMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The retry strategy associated with a job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class RetryStrategy implements StructuredPojo, ToCopyableBuilder<RetryStrategy.Builder, RetryStrategy> {
    private final Integer attempts;

    private RetryStrategy(BuilderImpl builder) {
        this.attempts = builder.attempts;
    }

    /**
     * <p>
     * The number of times to move a job to the <code>RUNNABLE</code> status. You may specify between 1 and 10 attempts.
     * If <code>attempts</code> is greater than one, the job is retried if it fails until it has moved to
     * <code>RUNNABLE</code> that many times.
     * </p>
     * 
     * @return The number of times to move a job to the <code>RUNNABLE</code> status. You may specify between 1 and 10
     *         attempts. If <code>attempts</code> is greater than one, the job is retried if it fails until it has moved
     *         to <code>RUNNABLE</code> that many times.
     */
    public Integer attempts() {
        return attempts;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((attempts() == null) ? 0 : attempts().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RetryStrategy)) {
            return false;
        }
        RetryStrategy other = (RetryStrategy) obj;
        if (other.attempts() == null ^ this.attempts() == null) {
            return false;
        }
        if (other.attempts() != null && !other.attempts().equals(this.attempts())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (attempts() != null) {
            sb.append("Attempts: ").append(attempts()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RetryStrategyMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, RetryStrategy> {
        /**
         * <p>
         * The number of times to move a job to the <code>RUNNABLE</code> status. You may specify between 1 and 10
         * attempts. If <code>attempts</code> is greater than one, the job is retried if it fails until it has moved to
         * <code>RUNNABLE</code> that many times.
         * </p>
         * 
         * @param attempts
         *        The number of times to move a job to the <code>RUNNABLE</code> status. You may specify between 1 and
         *        10 attempts. If <code>attempts</code> is greater than one, the job is retried if it fails until it has
         *        moved to <code>RUNNABLE</code> that many times.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attempts(Integer attempts);
    }

    private static final class BuilderImpl implements Builder {
        private Integer attempts;

        private BuilderImpl() {
        }

        private BuilderImpl(RetryStrategy model) {
            setAttempts(model.attempts);
        }

        public final Integer getAttempts() {
            return attempts;
        }

        @Override
        public final Builder attempts(Integer attempts) {
            this.attempts = attempts;
            return this;
        }

        public final void setAttempts(Integer attempts) {
            this.attempts = attempts;
        }

        @Override
        public RetryStrategy build() {
            return new RetryStrategy(this);
        }
    }
}
