/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.batch.transform;

import java.math.*;

import javax.annotation.Generated;

import software.amazon.awssdk.services.batch.model.*;
import software.amazon.awssdk.runtime.transform.SimpleTypeJsonUnmarshallers.*;
import software.amazon.awssdk.runtime.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * ComputeEnvironmentDetail JSON Unmarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class ComputeEnvironmentDetailUnmarshaller implements Unmarshaller<ComputeEnvironmentDetail, JsonUnmarshallerContext> {

    public ComputeEnvironmentDetail unmarshall(JsonUnmarshallerContext context) throws Exception {
        ComputeEnvironmentDetail.Builder computeEnvironmentDetailBuilder = ComputeEnvironmentDetail.builder();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return null;
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("computeEnvironmentName", targetDepth)) {
                    context.nextToken();
                    computeEnvironmentDetailBuilder.computeEnvironmentName(context.getUnmarshaller(String.class).unmarshall(
                            context));
                }
                if (context.testExpression("computeEnvironmentArn", targetDepth)) {
                    context.nextToken();
                    computeEnvironmentDetailBuilder.computeEnvironmentArn(context.getUnmarshaller(String.class).unmarshall(
                            context));
                }
                if (context.testExpression("ecsClusterArn", targetDepth)) {
                    context.nextToken();
                    computeEnvironmentDetailBuilder.ecsClusterArn(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("type", targetDepth)) {
                    context.nextToken();
                    computeEnvironmentDetailBuilder.type(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("state", targetDepth)) {
                    context.nextToken();
                    computeEnvironmentDetailBuilder.state(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("status", targetDepth)) {
                    context.nextToken();
                    computeEnvironmentDetailBuilder.status(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("statusReason", targetDepth)) {
                    context.nextToken();
                    computeEnvironmentDetailBuilder.statusReason(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("computeResources", targetDepth)) {
                    context.nextToken();
                    computeEnvironmentDetailBuilder.computeResources(ComputeResourceUnmarshaller.getInstance()
                            .unmarshall(context));
                }
                if (context.testExpression("serviceRole", targetDepth)) {
                    context.nextToken();
                    computeEnvironmentDetailBuilder.serviceRole(context.getUnmarshaller(String.class).unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null
                        || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return computeEnvironmentDetailBuilder.build();
    }

    private static ComputeEnvironmentDetailUnmarshaller INSTANCE;

    public static ComputeEnvironmentDetailUnmarshaller getInstance() {
        if (INSTANCE == null)
            INSTANCE = new ComputeEnvironmentDetailUnmarshaller();
        return INSTANCE;
    }
}