/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.batch.transform;

import java.math.*;

import javax.annotation.Generated;

import software.amazon.awssdk.services.batch.model.*;
import software.amazon.awssdk.runtime.transform.SimpleTypeJsonUnmarshallers.*;
import software.amazon.awssdk.runtime.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * JobQueueDetail JSON Unmarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class JobQueueDetailUnmarshaller implements Unmarshaller<JobQueueDetail, JsonUnmarshallerContext> {

    public JobQueueDetail unmarshall(JsonUnmarshallerContext context) throws Exception {
        JobQueueDetail.Builder jobQueueDetailBuilder = JobQueueDetail.builder();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return null;
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("jobQueueName", targetDepth)) {
                    context.nextToken();
                    jobQueueDetailBuilder.jobQueueName(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("jobQueueArn", targetDepth)) {
                    context.nextToken();
                    jobQueueDetailBuilder.jobQueueArn(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("state", targetDepth)) {
                    context.nextToken();
                    jobQueueDetailBuilder.state(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("status", targetDepth)) {
                    context.nextToken();
                    jobQueueDetailBuilder.status(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("statusReason", targetDepth)) {
                    context.nextToken();
                    jobQueueDetailBuilder.statusReason(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("priority", targetDepth)) {
                    context.nextToken();
                    jobQueueDetailBuilder.priority(context.getUnmarshaller(Integer.class).unmarshall(context));
                }
                if (context.testExpression("computeEnvironmentOrder", targetDepth)) {
                    context.nextToken();
                    jobQueueDetailBuilder.computeEnvironmentOrder(new ListUnmarshaller<ComputeEnvironmentOrder>(
                            ComputeEnvironmentOrderUnmarshaller.getInstance()).unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null
                        || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return jobQueueDetailBuilder.build();
    }

    private static JobQueueDetailUnmarshaller INSTANCE;

    public static JobQueueDetailUnmarshaller getInstance() {
        if (INSTANCE == null)
            INSTANCE = new JobQueueDetailUnmarshaller();
        return INSTANCE;
    }
}