/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.batch.model.AttemptDetail;
import software.amazon.awssdk.services.batch.model.AttemptDetailsCopier;
import software.amazon.awssdk.services.batch.model.ContainerDetail;
import software.amazon.awssdk.services.batch.model.JobDependency;
import software.amazon.awssdk.services.batch.model.JobDependencyListCopier;
import software.amazon.awssdk.services.batch.model.JobStatus;
import software.amazon.awssdk.services.batch.model.ParametersMapCopier;
import software.amazon.awssdk.services.batch.model.RetryStrategy;
import software.amazon.awssdk.services.batch.transform.JobDetailMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class JobDetail
implements StructuredPojo,
ToCopyableBuilder<Builder, JobDetail> {
    private final String jobName;
    private final String jobId;
    private final String jobQueue;
    private final String status;
    private final List<AttemptDetail> attempts;
    private final String statusReason;
    private final Long createdAt;
    private final RetryStrategy retryStrategy;
    private final Long startedAt;
    private final Long stoppedAt;
    private final List<JobDependency> dependsOn;
    private final String jobDefinition;
    private final Map<String, String> parameters;
    private final ContainerDetail container;

    private JobDetail(BuilderImpl builder) {
        this.jobName = builder.jobName;
        this.jobId = builder.jobId;
        this.jobQueue = builder.jobQueue;
        this.status = builder.status;
        this.attempts = builder.attempts;
        this.statusReason = builder.statusReason;
        this.createdAt = builder.createdAt;
        this.retryStrategy = builder.retryStrategy;
        this.startedAt = builder.startedAt;
        this.stoppedAt = builder.stoppedAt;
        this.dependsOn = builder.dependsOn;
        this.jobDefinition = builder.jobDefinition;
        this.parameters = builder.parameters;
        this.container = builder.container;
    }

    public String jobName() {
        return this.jobName;
    }

    public String jobId() {
        return this.jobId;
    }

    public String jobQueue() {
        return this.jobQueue;
    }

    public String status() {
        return this.status;
    }

    public List<AttemptDetail> attempts() {
        return this.attempts;
    }

    public String statusReason() {
        return this.statusReason;
    }

    public Long createdAt() {
        return this.createdAt;
    }

    public RetryStrategy retryStrategy() {
        return this.retryStrategy;
    }

    public Long startedAt() {
        return this.startedAt;
    }

    public Long stoppedAt() {
        return this.stoppedAt;
    }

    public List<JobDependency> dependsOn() {
        return this.dependsOn;
    }

    public String jobDefinition() {
        return this.jobDefinition;
    }

    public Map<String, String> parameters() {
        return this.parameters;
    }

    public ContainerDetail container() {
        return this.container;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.jobName() == null ? 0 : this.jobName().hashCode());
        hashCode = 31 * hashCode + (this.jobId() == null ? 0 : this.jobId().hashCode());
        hashCode = 31 * hashCode + (this.jobQueue() == null ? 0 : this.jobQueue().hashCode());
        hashCode = 31 * hashCode + (this.status() == null ? 0 : this.status().hashCode());
        hashCode = 31 * hashCode + (this.attempts() == null ? 0 : this.attempts().hashCode());
        hashCode = 31 * hashCode + (this.statusReason() == null ? 0 : this.statusReason().hashCode());
        hashCode = 31 * hashCode + (this.createdAt() == null ? 0 : this.createdAt().hashCode());
        hashCode = 31 * hashCode + (this.retryStrategy() == null ? 0 : this.retryStrategy().hashCode());
        hashCode = 31 * hashCode + (this.startedAt() == null ? 0 : this.startedAt().hashCode());
        hashCode = 31 * hashCode + (this.stoppedAt() == null ? 0 : this.stoppedAt().hashCode());
        hashCode = 31 * hashCode + (this.dependsOn() == null ? 0 : this.dependsOn().hashCode());
        hashCode = 31 * hashCode + (this.jobDefinition() == null ? 0 : this.jobDefinition().hashCode());
        hashCode = 31 * hashCode + (this.parameters() == null ? 0 : this.parameters().hashCode());
        hashCode = 31 * hashCode + (this.container() == null ? 0 : this.container().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobDetail)) {
            return false;
        }
        JobDetail other = (JobDetail)obj;
        if (other.jobName() == null ^ this.jobName() == null) {
            return false;
        }
        if (other.jobName() != null && !other.jobName().equals(this.jobName())) {
            return false;
        }
        if (other.jobId() == null ^ this.jobId() == null) {
            return false;
        }
        if (other.jobId() != null && !other.jobId().equals(this.jobId())) {
            return false;
        }
        if (other.jobQueue() == null ^ this.jobQueue() == null) {
            return false;
        }
        if (other.jobQueue() != null && !other.jobQueue().equals(this.jobQueue())) {
            return false;
        }
        if (other.status() == null ^ this.status() == null) {
            return false;
        }
        if (other.status() != null && !other.status().equals(this.status())) {
            return false;
        }
        if (other.attempts() == null ^ this.attempts() == null) {
            return false;
        }
        if (other.attempts() != null && !other.attempts().equals(this.attempts())) {
            return false;
        }
        if (other.statusReason() == null ^ this.statusReason() == null) {
            return false;
        }
        if (other.statusReason() != null && !other.statusReason().equals(this.statusReason())) {
            return false;
        }
        if (other.createdAt() == null ^ this.createdAt() == null) {
            return false;
        }
        if (other.createdAt() != null && !other.createdAt().equals(this.createdAt())) {
            return false;
        }
        if (other.retryStrategy() == null ^ this.retryStrategy() == null) {
            return false;
        }
        if (other.retryStrategy() != null && !other.retryStrategy().equals(this.retryStrategy())) {
            return false;
        }
        if (other.startedAt() == null ^ this.startedAt() == null) {
            return false;
        }
        if (other.startedAt() != null && !other.startedAt().equals(this.startedAt())) {
            return false;
        }
        if (other.stoppedAt() == null ^ this.stoppedAt() == null) {
            return false;
        }
        if (other.stoppedAt() != null && !other.stoppedAt().equals(this.stoppedAt())) {
            return false;
        }
        if (other.dependsOn() == null ^ this.dependsOn() == null) {
            return false;
        }
        if (other.dependsOn() != null && !other.dependsOn().equals(this.dependsOn())) {
            return false;
        }
        if (other.jobDefinition() == null ^ this.jobDefinition() == null) {
            return false;
        }
        if (other.jobDefinition() != null && !other.jobDefinition().equals(this.jobDefinition())) {
            return false;
        }
        if (other.parameters() == null ^ this.parameters() == null) {
            return false;
        }
        if (other.parameters() != null && !other.parameters().equals(this.parameters())) {
            return false;
        }
        if (other.container() == null ^ this.container() == null) {
            return false;
        }
        return other.container() == null || other.container().equals(this.container());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.jobName() != null) {
            sb.append("JobName: ").append(this.jobName()).append(",");
        }
        if (this.jobId() != null) {
            sb.append("JobId: ").append(this.jobId()).append(",");
        }
        if (this.jobQueue() != null) {
            sb.append("JobQueue: ").append(this.jobQueue()).append(",");
        }
        if (this.status() != null) {
            sb.append("Status: ").append(this.status()).append(",");
        }
        if (this.attempts() != null) {
            sb.append("Attempts: ").append(this.attempts()).append(",");
        }
        if (this.statusReason() != null) {
            sb.append("StatusReason: ").append(this.statusReason()).append(",");
        }
        if (this.createdAt() != null) {
            sb.append("CreatedAt: ").append(this.createdAt()).append(",");
        }
        if (this.retryStrategy() != null) {
            sb.append("RetryStrategy: ").append(this.retryStrategy()).append(",");
        }
        if (this.startedAt() != null) {
            sb.append("StartedAt: ").append(this.startedAt()).append(",");
        }
        if (this.stoppedAt() != null) {
            sb.append("StoppedAt: ").append(this.stoppedAt()).append(",");
        }
        if (this.dependsOn() != null) {
            sb.append("DependsOn: ").append(this.dependsOn()).append(",");
        }
        if (this.jobDefinition() != null) {
            sb.append("JobDefinition: ").append(this.jobDefinition()).append(",");
        }
        if (this.parameters() != null) {
            sb.append("Parameters: ").append(this.parameters()).append(",");
        }
        if (this.container() != null) {
            sb.append("Container: ").append(this.container()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        JobDetailMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String jobName;
        private String jobId;
        private String jobQueue;
        private String status;
        private List<AttemptDetail> attempts;
        private String statusReason;
        private Long createdAt;
        private RetryStrategy retryStrategy;
        private Long startedAt;
        private Long stoppedAt;
        private List<JobDependency> dependsOn;
        private String jobDefinition;
        private Map<String, String> parameters;
        private ContainerDetail container;

        private BuilderImpl() {
        }

        private BuilderImpl(JobDetail model) {
            this.setJobName(model.jobName);
            this.setJobId(model.jobId);
            this.setJobQueue(model.jobQueue);
            this.setStatus(model.status);
            this.setAttempts(model.attempts);
            this.setStatusReason(model.statusReason);
            this.setCreatedAt(model.createdAt);
            this.setRetryStrategy(model.retryStrategy);
            this.setStartedAt(model.startedAt);
            this.setStoppedAt(model.stoppedAt);
            this.setDependsOn(model.dependsOn);
            this.setJobDefinition(model.jobDefinition);
            this.setParameters(model.parameters);
            this.setContainer(model.container);
        }

        public final String getJobName() {
            return this.jobName;
        }

        @Override
        public final Builder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public final void setJobName(String jobName) {
            this.jobName = jobName;
        }

        public final String getJobId() {
            return this.jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        public final String getJobQueue() {
            return this.jobQueue;
        }

        @Override
        public final Builder jobQueue(String jobQueue) {
            this.jobQueue = jobQueue;
            return this;
        }

        public final void setJobQueue(String jobQueue) {
            this.jobQueue = jobQueue;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(JobStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final void setStatus(JobStatus status) {
            this.status(status.toString());
        }

        public final Collection<AttemptDetail> getAttempts() {
            return this.attempts;
        }

        @Override
        public final Builder attempts(Collection<AttemptDetail> attempts) {
            this.attempts = AttemptDetailsCopier.copy(attempts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attempts(AttemptDetail ... attempts) {
            if (this.attempts == null) {
                this.attempts = new ArrayList<AttemptDetail>(attempts.length);
            }
            for (AttemptDetail e : attempts) {
                this.attempts.add(e);
            }
            return this;
        }

        public final void setAttempts(Collection<AttemptDetail> attempts) {
            this.attempts = AttemptDetailsCopier.copy(attempts);
        }

        @SafeVarargs
        public final void setAttempts(AttemptDetail ... attempts) {
            if (this.attempts == null) {
                this.attempts = new ArrayList<AttemptDetail>(attempts.length);
            }
            for (AttemptDetail e : attempts) {
                this.attempts.add(e);
            }
        }

        public final String getStatusReason() {
            return this.statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        public final Long getCreatedAt() {
            return this.createdAt;
        }

        @Override
        public final Builder createdAt(Long createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(Long createdAt) {
            this.createdAt = createdAt;
        }

        public final RetryStrategy getRetryStrategy() {
            return this.retryStrategy;
        }

        @Override
        public final Builder retryStrategy(RetryStrategy retryStrategy) {
            this.retryStrategy = retryStrategy;
            return this;
        }

        public final void setRetryStrategy(RetryStrategy retryStrategy) {
            this.retryStrategy = retryStrategy;
        }

        public final Long getStartedAt() {
            return this.startedAt;
        }

        @Override
        public final Builder startedAt(Long startedAt) {
            this.startedAt = startedAt;
            return this;
        }

        public final void setStartedAt(Long startedAt) {
            this.startedAt = startedAt;
        }

        public final Long getStoppedAt() {
            return this.stoppedAt;
        }

        @Override
        public final Builder stoppedAt(Long stoppedAt) {
            this.stoppedAt = stoppedAt;
            return this;
        }

        public final void setStoppedAt(Long stoppedAt) {
            this.stoppedAt = stoppedAt;
        }

        public final Collection<JobDependency> getDependsOn() {
            return this.dependsOn;
        }

        @Override
        public final Builder dependsOn(Collection<JobDependency> dependsOn) {
            this.dependsOn = JobDependencyListCopier.copy(dependsOn);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dependsOn(JobDependency ... dependsOn) {
            if (this.dependsOn == null) {
                this.dependsOn = new ArrayList<JobDependency>(dependsOn.length);
            }
            for (JobDependency e : dependsOn) {
                this.dependsOn.add(e);
            }
            return this;
        }

        public final void setDependsOn(Collection<JobDependency> dependsOn) {
            this.dependsOn = JobDependencyListCopier.copy(dependsOn);
        }

        @SafeVarargs
        public final void setDependsOn(JobDependency ... dependsOn) {
            if (this.dependsOn == null) {
                this.dependsOn = new ArrayList<JobDependency>(dependsOn.length);
            }
            for (JobDependency e : dependsOn) {
                this.dependsOn.add(e);
            }
        }

        public final String getJobDefinition() {
            return this.jobDefinition;
        }

        @Override
        public final Builder jobDefinition(String jobDefinition) {
            this.jobDefinition = jobDefinition;
            return this;
        }

        public final void setJobDefinition(String jobDefinition) {
            this.jobDefinition = jobDefinition;
        }

        public final Map<String, String> getParameters() {
            return this.parameters;
        }

        @Override
        public final Builder parameters(Map<String, String> parameters) {
            this.parameters = ParametersMapCopier.copy(parameters);
            return this;
        }

        public final void setParameters(Map<String, String> parameters) {
            this.parameters = ParametersMapCopier.copy(parameters);
        }

        public final ContainerDetail getContainer() {
            return this.container;
        }

        @Override
        public final Builder container(ContainerDetail container) {
            this.container = container;
            return this;
        }

        public final void setContainer(ContainerDetail container) {
            this.container = container;
        }

        public JobDetail build() {
            return new JobDetail(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, JobDetail> {
        public Builder jobName(String var1);

        public Builder jobId(String var1);

        public Builder jobQueue(String var1);

        public Builder status(String var1);

        public Builder status(JobStatus var1);

        public Builder attempts(Collection<AttemptDetail> var1);

        public Builder attempts(AttemptDetail ... var1);

        public Builder statusReason(String var1);

        public Builder createdAt(Long var1);

        public Builder retryStrategy(RetryStrategy var1);

        public Builder startedAt(Long var1);

        public Builder stoppedAt(Long var1);

        public Builder dependsOn(Collection<JobDependency> var1);

        public Builder dependsOn(JobDependency ... var1);

        public Builder jobDefinition(String var1);

        public Builder parameters(Map<String, String> var1);

        public Builder container(ContainerDetail var1);
    }
}

