/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.batch.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DeregisterJobDefinitionRequest extends BatchRequest implements
        ToCopyableBuilder<DeregisterJobDefinitionRequest.Builder, DeregisterJobDefinitionRequest> {
    private final String jobDefinition;

    private DeregisterJobDefinitionRequest(BuilderImpl builder) {
        super(builder);
        this.jobDefinition = builder.jobDefinition;
    }

    /**
     * <p>
     * The name and revision (<code>name:revision</code>) or full Amazon Resource Name (ARN) of the job definition to
     * deregister.
     * </p>
     * 
     * @return The name and revision (<code>name:revision</code>) or full Amazon Resource Name (ARN) of the job
     *         definition to deregister.
     */
    public String jobDefinition() {
        return jobDefinition;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(jobDefinition());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeregisterJobDefinitionRequest)) {
            return false;
        }
        DeregisterJobDefinitionRequest other = (DeregisterJobDefinitionRequest) obj;
        return Objects.equals(jobDefinition(), other.jobDefinition());
    }

    @Override
    public String toString() {
        return ToString.builder("DeregisterJobDefinitionRequest").add("JobDefinition", jobDefinition()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "jobDefinition":
            return Optional.of(clazz.cast(jobDefinition()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends BatchRequest.Builder, CopyableBuilder<Builder, DeregisterJobDefinitionRequest> {
        /**
         * <p>
         * The name and revision (<code>name:revision</code>) or full Amazon Resource Name (ARN) of the job definition
         * to deregister.
         * </p>
         * 
         * @param jobDefinition
         *        The name and revision (<code>name:revision</code>) or full Amazon Resource Name (ARN) of the job
         *        definition to deregister.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobDefinition(String jobDefinition);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);

        @Override
        Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BatchRequest.BuilderImpl implements Builder {
        private String jobDefinition;

        private BuilderImpl() {
        }

        private BuilderImpl(DeregisterJobDefinitionRequest model) {
            super(model);
            jobDefinition(model.jobDefinition);
        }

        public final String getJobDefinition() {
            return jobDefinition;
        }

        @Override
        public final Builder jobDefinition(String jobDefinition) {
            this.jobDefinition = jobDefinition;
            return this;
        }

        public final void setJobDefinition(String jobDefinition) {
            this.jobDefinition = jobDefinition;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DeregisterJobDefinitionRequest build() {
            return new DeregisterJobDefinitionRequest(this);
        }
    }
}
