/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.batch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeJobQueuesResponse extends BatchResponse implements
        ToCopyableBuilder<DescribeJobQueuesResponse.Builder, DescribeJobQueuesResponse> {
    private final List<JobQueueDetail> jobQueues;

    private final String nextToken;

    private DescribeJobQueuesResponse(BuilderImpl builder) {
        super(builder);
        this.jobQueues = builder.jobQueues;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The list of job queues.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The list of job queues.
     */
    public List<JobQueueDetail> jobQueues() {
        return jobQueues;
    }

    /**
     * <p>
     * The <code>nextToken</code> value to include in a future <code>DescribeJobQueues</code> request. When the results
     * of a <code>DescribeJobQueues</code> request exceed <code>maxResults</code>, this value can be used to retrieve
     * the next page of results. This value is <code>null</code> when there are no more results to return.
     * </p>
     * 
     * @return The <code>nextToken</code> value to include in a future <code>DescribeJobQueues</code> request. When the
     *         results of a <code>DescribeJobQueues</code> request exceed <code>maxResults</code>, this value can be
     *         used to retrieve the next page of results. This value is <code>null</code> when there are no more results
     *         to return.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(jobQueues());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeJobQueuesResponse)) {
            return false;
        }
        DescribeJobQueuesResponse other = (DescribeJobQueuesResponse) obj;
        return Objects.equals(jobQueues(), other.jobQueues()) && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeJobQueuesResponse").add("JobQueues", jobQueues()).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "jobQueues":
            return Optional.of(clazz.cast(jobQueues()));
        case "nextToken":
            return Optional.of(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends BatchResponse.Builder, CopyableBuilder<Builder, DescribeJobQueuesResponse> {
        /**
         * <p>
         * The list of job queues.
         * </p>
         * 
         * @param jobQueues
         *        The list of job queues.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobQueues(Collection<JobQueueDetail> jobQueues);

        /**
         * <p>
         * The list of job queues.
         * </p>
         * 
         * @param jobQueues
         *        The list of job queues.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobQueues(JobQueueDetail... jobQueues);

        /**
         * <p>
         * The list of job queues.
         * </p>
         * This is a convenience that creates an instance of the {@link List<JobQueueDetail>.Builder} avoiding the need
         * to create one manually via {@link List<JobQueueDetail>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<JobQueueDetail>.Builder#build()} is called immediately and
         * its result is passed to {@link #jobQueues(List<JobQueueDetail>)}.
         * 
         * @param jobQueues
         *        a consumer that will call methods on {@link List<JobQueueDetail>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #jobQueues(List<JobQueueDetail>)
         */
        Builder jobQueues(Consumer<JobQueueDetail.Builder>... jobQueues);

        /**
         * <p>
         * The <code>nextToken</code> value to include in a future <code>DescribeJobQueues</code> request. When the
         * results of a <code>DescribeJobQueues</code> request exceed <code>maxResults</code>, this value can be used to
         * retrieve the next page of results. This value is <code>null</code> when there are no more results to return.
         * </p>
         * 
         * @param nextToken
         *        The <code>nextToken</code> value to include in a future <code>DescribeJobQueues</code> request. When
         *        the results of a <code>DescribeJobQueues</code> request exceed <code>maxResults</code>, this value can
         *        be used to retrieve the next page of results. This value is <code>null</code> when there are no more
         *        results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends BatchResponse.BuilderImpl implements Builder {
        private List<JobQueueDetail> jobQueues;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeJobQueuesResponse model) {
            super(model);
            jobQueues(model.jobQueues);
            nextToken(model.nextToken);
        }

        public final Collection<JobQueueDetail.Builder> getJobQueues() {
            return jobQueues != null ? jobQueues.stream().map(JobQueueDetail::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder jobQueues(Collection<JobQueueDetail> jobQueues) {
            this.jobQueues = JobQueueDetailListCopier.copy(jobQueues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobQueues(JobQueueDetail... jobQueues) {
            jobQueues(Arrays.asList(jobQueues));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobQueues(Consumer<JobQueueDetail.Builder>... jobQueues) {
            jobQueues(Stream.of(jobQueues).map(c -> JobQueueDetail.builder().apply(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setJobQueues(Collection<JobQueueDetail.BuilderImpl> jobQueues) {
            this.jobQueues = JobQueueDetailListCopier.copyFromBuilder(jobQueues);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeJobQueuesResponse build() {
            return new DescribeJobQueuesResponse(this);
        }
    }
}
