/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.batch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeJobsResponse extends BatchResponse implements
        ToCopyableBuilder<DescribeJobsResponse.Builder, DescribeJobsResponse> {
    private final List<JobDetail> jobs;

    private DescribeJobsResponse(BuilderImpl builder) {
        super(builder);
        this.jobs = builder.jobs;
    }

    /**
     * <p>
     * The list of jobs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The list of jobs.
     */
    public List<JobDetail> jobs() {
        return jobs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(jobs());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeJobsResponse)) {
            return false;
        }
        DescribeJobsResponse other = (DescribeJobsResponse) obj;
        return Objects.equals(jobs(), other.jobs());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeJobsResponse").add("Jobs", jobs()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "jobs":
            return Optional.of(clazz.cast(jobs()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends BatchResponse.Builder, CopyableBuilder<Builder, DescribeJobsResponse> {
        /**
         * <p>
         * The list of jobs.
         * </p>
         * 
         * @param jobs
         *        The list of jobs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobs(Collection<JobDetail> jobs);

        /**
         * <p>
         * The list of jobs.
         * </p>
         * 
         * @param jobs
         *        The list of jobs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobs(JobDetail... jobs);

        /**
         * <p>
         * The list of jobs.
         * </p>
         * This is a convenience that creates an instance of the {@link List<JobDetail>.Builder} avoiding the need to
         * create one manually via {@link List<JobDetail>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<JobDetail>.Builder#build()} is called immediately and its
         * result is passed to {@link #jobs(List<JobDetail>)}.
         * 
         * @param jobs
         *        a consumer that will call methods on {@link List<JobDetail>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #jobs(List<JobDetail>)
         */
        Builder jobs(Consumer<JobDetail.Builder>... jobs);
    }

    static final class BuilderImpl extends BatchResponse.BuilderImpl implements Builder {
        private List<JobDetail> jobs;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeJobsResponse model) {
            super(model);
            jobs(model.jobs);
        }

        public final Collection<JobDetail.Builder> getJobs() {
            return jobs != null ? jobs.stream().map(JobDetail::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder jobs(Collection<JobDetail> jobs) {
            this.jobs = JobDetailListCopier.copy(jobs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobs(JobDetail... jobs) {
            jobs(Arrays.asList(jobs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobs(Consumer<JobDetail.Builder>... jobs) {
            jobs(Stream.of(jobs).map(c -> JobDetail.builder().apply(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setJobs(Collection<JobDetail.BuilderImpl> jobs) {
            this.jobs = JobDetailListCopier.copyFromBuilder(jobs);
        }

        @Override
        public DescribeJobsResponse build() {
            return new DescribeJobsResponse(this);
        }
    }
}
