/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.batch.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class ListJobsRequest extends BatchRequest implements ToCopyableBuilder<ListJobsRequest.Builder, ListJobsRequest> {
    private final String jobQueue;

    private final String jobStatus;

    private final Integer maxResults;

    private final String nextToken;

    private ListJobsRequest(BuilderImpl builder) {
        super(builder);
        this.jobQueue = builder.jobQueue;
        this.jobStatus = builder.jobStatus;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The name or full Amazon Resource Name (ARN) of the job queue with which to list jobs.
     * </p>
     * 
     * @return The name or full Amazon Resource Name (ARN) of the job queue with which to list jobs.
     */
    public String jobQueue() {
        return jobQueue;
    }

    /**
     * <p>
     * The job status with which to filter jobs in the specified queue. If you do not specify a status, only
     * <code>RUNNING</code> jobs are returned.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #jobStatus} will
     * return {@link JobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #jobStatusAsString}.
     * </p>
     * 
     * @return The job status with which to filter jobs in the specified queue. If you do not specify a status, only
     *         <code>RUNNING</code> jobs are returned.
     * @see JobStatus
     */
    public JobStatus jobStatus() {
        return JobStatus.fromValue(jobStatus);
    }

    /**
     * <p>
     * The job status with which to filter jobs in the specified queue. If you do not specify a status, only
     * <code>RUNNING</code> jobs are returned.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #jobStatus} will
     * return {@link JobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #jobStatusAsString}.
     * </p>
     * 
     * @return The job status with which to filter jobs in the specified queue. If you do not specify a status, only
     *         <code>RUNNING</code> jobs are returned.
     * @see JobStatus
     */
    public String jobStatusAsString() {
        return jobStatus;
    }

    /**
     * <p>
     * The maximum number of results returned by <code>ListJobs</code> in paginated output. When this parameter is used,
     * <code>ListJobs</code> only returns <code>maxResults</code> results in a single page along with a
     * <code>nextToken</code> response element. The remaining results of the initial request can be seen by sending
     * another <code>ListJobs</code> request with the returned <code>nextToken</code> value. This value can be between 1
     * and 100. If this parameter is not used, then <code>ListJobs</code> returns up to 100 results and a
     * <code>nextToken</code> value if applicable.
     * </p>
     * 
     * @return The maximum number of results returned by <code>ListJobs</code> in paginated output. When this parameter
     *         is used, <code>ListJobs</code> only returns <code>maxResults</code> results in a single page along with a
     *         <code>nextToken</code> response element. The remaining results of the initial request can be seen by
     *         sending another <code>ListJobs</code> request with the returned <code>nextToken</code> value. This value
     *         can be between 1 and 100. If this parameter is not used, then <code>ListJobs</code> returns up to 100
     *         results and a <code>nextToken</code> value if applicable.
     */
    public Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The <code>nextToken</code> value returned from a previous paginated <code>ListJobs</code> request where
     * <code>maxResults</code> was used and the results exceeded the value of that parameter. Pagination continues from
     * the end of the previous results that returned the <code>nextToken</code> value. This value is <code>null</code>
     * when there are no more results to return.
     * </p>
     * <note>
     * <p>
     * This token should be treated as an opaque identifier that is only used to retrieve the next items in a list and
     * not for other programmatic purposes.
     * </p>
     * </note>
     * 
     * @return The <code>nextToken</code> value returned from a previous paginated <code>ListJobs</code> request where
     *         <code>maxResults</code> was used and the results exceeded the value of that parameter. Pagination
     *         continues from the end of the previous results that returned the <code>nextToken</code> value. This value
     *         is <code>null</code> when there are no more results to return.</p> <note>
     *         <p>
     *         This token should be treated as an opaque identifier that is only used to retrieve the next items in a
     *         list and not for other programmatic purposes.
     *         </p>
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(jobQueue());
        hashCode = 31 * hashCode + Objects.hashCode(jobStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListJobsRequest)) {
            return false;
        }
        ListJobsRequest other = (ListJobsRequest) obj;
        return Objects.equals(jobQueue(), other.jobQueue()) && Objects.equals(jobStatusAsString(), other.jobStatusAsString())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        return ToString.builder("ListJobsRequest").add("JobQueue", jobQueue()).add("JobStatus", jobStatusAsString())
                .add("MaxResults", maxResults()).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "jobQueue":
            return Optional.of(clazz.cast(jobQueue()));
        case "jobStatus":
            return Optional.of(clazz.cast(jobStatusAsString()));
        case "maxResults":
            return Optional.of(clazz.cast(maxResults()));
        case "nextToken":
            return Optional.of(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends BatchRequest.Builder, CopyableBuilder<Builder, ListJobsRequest> {
        /**
         * <p>
         * The name or full Amazon Resource Name (ARN) of the job queue with which to list jobs.
         * </p>
         * 
         * @param jobQueue
         *        The name or full Amazon Resource Name (ARN) of the job queue with which to list jobs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobQueue(String jobQueue);

        /**
         * <p>
         * The job status with which to filter jobs in the specified queue. If you do not specify a status, only
         * <code>RUNNING</code> jobs are returned.
         * </p>
         * 
         * @param jobStatus
         *        The job status with which to filter jobs in the specified queue. If you do not specify a status, only
         *        <code>RUNNING</code> jobs are returned.
         * @see JobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobStatus
         */
        Builder jobStatus(String jobStatus);

        /**
         * <p>
         * The job status with which to filter jobs in the specified queue. If you do not specify a status, only
         * <code>RUNNING</code> jobs are returned.
         * </p>
         * 
         * @param jobStatus
         *        The job status with which to filter jobs in the specified queue. If you do not specify a status, only
         *        <code>RUNNING</code> jobs are returned.
         * @see JobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobStatus
         */
        Builder jobStatus(JobStatus jobStatus);

        /**
         * <p>
         * The maximum number of results returned by <code>ListJobs</code> in paginated output. When this parameter is
         * used, <code>ListJobs</code> only returns <code>maxResults</code> results in a single page along with a
         * <code>nextToken</code> response element. The remaining results of the initial request can be seen by sending
         * another <code>ListJobs</code> request with the returned <code>nextToken</code> value. This value can be
         * between 1 and 100. If this parameter is not used, then <code>ListJobs</code> returns up to 100 results and a
         * <code>nextToken</code> value if applicable.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results returned by <code>ListJobs</code> in paginated output. When this
         *        parameter is used, <code>ListJobs</code> only returns <code>maxResults</code> results in a single page
         *        along with a <code>nextToken</code> response element. The remaining results of the initial request can
         *        be seen by sending another <code>ListJobs</code> request with the returned <code>nextToken</code>
         *        value. This value can be between 1 and 100. If this parameter is not used, then <code>ListJobs</code>
         *        returns up to 100 results and a <code>nextToken</code> value if applicable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The <code>nextToken</code> value returned from a previous paginated <code>ListJobs</code> request where
         * <code>maxResults</code> was used and the results exceeded the value of that parameter. Pagination continues
         * from the end of the previous results that returned the <code>nextToken</code> value. This value is
         * <code>null</code> when there are no more results to return.
         * </p>
         * <note>
         * <p>
         * This token should be treated as an opaque identifier that is only used to retrieve the next items in a list
         * and not for other programmatic purposes.
         * </p>
         * </note>
         * 
         * @param nextToken
         *        The <code>nextToken</code> value returned from a previous paginated <code>ListJobs</code> request
         *        where <code>maxResults</code> was used and the results exceeded the value of that parameter.
         *        Pagination continues from the end of the previous results that returned the <code>nextToken</code>
         *        value. This value is <code>null</code> when there are no more results to return.</p> <note>
         *        <p>
         *        This token should be treated as an opaque identifier that is only used to retrieve the next items in a
         *        list and not for other programmatic purposes.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);

        @Override
        Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BatchRequest.BuilderImpl implements Builder {
        private String jobQueue;

        private String jobStatus;

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListJobsRequest model) {
            super(model);
            jobQueue(model.jobQueue);
            jobStatus(model.jobStatus);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final String getJobQueue() {
            return jobQueue;
        }

        @Override
        public final Builder jobQueue(String jobQueue) {
            this.jobQueue = jobQueue;
            return this;
        }

        public final void setJobQueue(String jobQueue) {
            this.jobQueue = jobQueue;
        }

        public final String getJobStatus() {
            return jobStatus;
        }

        @Override
        public final Builder jobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
            return this;
        }

        @Override
        public final Builder jobStatus(JobStatus jobStatus) {
            this.jobStatus(jobStatus.toString());
            return this;
        }

        public final void setJobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public ListJobsRequest build() {
            return new ListJobsRequest(this);
        }
    }
}
