/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.batch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class SubmitJobRequest extends BatchRequest implements ToCopyableBuilder<SubmitJobRequest.Builder, SubmitJobRequest> {
    private final String jobName;

    private final String jobQueue;

    private final List<JobDependency> dependsOn;

    private final String jobDefinition;

    private final Map<String, String> parameters;

    private final ContainerOverrides containerOverrides;

    private final RetryStrategy retryStrategy;

    private SubmitJobRequest(BuilderImpl builder) {
        super(builder);
        this.jobName = builder.jobName;
        this.jobQueue = builder.jobQueue;
        this.dependsOn = builder.dependsOn;
        this.jobDefinition = builder.jobDefinition;
        this.parameters = builder.parameters;
        this.containerOverrides = builder.containerOverrides;
        this.retryStrategy = builder.retryStrategy;
    }

    /**
     * <p>
     * The name of the job. The first character must be alphanumeric, and up to 128 letters (uppercase and lowercase),
     * numbers, hyphens, and underscores are allowed.
     * </p>
     * 
     * @return The name of the job. The first character must be alphanumeric, and up to 128 letters (uppercase and
     *         lowercase), numbers, hyphens, and underscores are allowed.
     */
    public String jobName() {
        return jobName;
    }

    /**
     * <p>
     * The job queue into which the job will be submitted. You can specify either the name or the Amazon Resource Name
     * (ARN) of the queue.
     * </p>
     * 
     * @return The job queue into which the job will be submitted. You can specify either the name or the Amazon
     *         Resource Name (ARN) of the queue.
     */
    public String jobQueue() {
        return jobQueue;
    }

    /**
     * <p>
     * A list of job IDs on which this job depends. A job can depend upon a maximum of 20 jobs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of job IDs on which this job depends. A job can depend upon a maximum of 20 jobs.
     */
    public List<JobDependency> dependsOn() {
        return dependsOn;
    }

    /**
     * <p>
     * The job definition used by this job. This value can be either a <code>name:revision</code> or the Amazon Resource
     * Name (ARN) for the job definition.
     * </p>
     * 
     * @return The job definition used by this job. This value can be either a <code>name:revision</code> or the Amazon
     *         Resource Name (ARN) for the job definition.
     */
    public String jobDefinition() {
        return jobDefinition;
    }

    /**
     * <p>
     * Additional parameters passed to the job that replace parameter substitution placeholders that are set in the job
     * definition. Parameters are specified as a key and value pair mapping. Parameters in a <code>SubmitJob</code>
     * request override any corresponding parameter defaults from the job definition.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Additional parameters passed to the job that replace parameter substitution placeholders that are set in
     *         the job definition. Parameters are specified as a key and value pair mapping. Parameters in a
     *         <code>SubmitJob</code> request override any corresponding parameter defaults from the job definition.
     */
    public Map<String, String> parameters() {
        return parameters;
    }

    /**
     * <p>
     * A list of container overrides in JSON format that specify the name of a container in the specified job definition
     * and the overrides it should receive. You can override the default command for a container (that is specified in
     * the job definition or the Docker image) with a <code>command</code> override. You can also override existing
     * environment variables (that are specified in the job definition or Docker image) on a container or add new
     * environment variables to it with an <code>environment</code> override.
     * </p>
     * 
     * @return A list of container overrides in JSON format that specify the name of a container in the specified job
     *         definition and the overrides it should receive. You can override the default command for a container
     *         (that is specified in the job definition or the Docker image) with a <code>command</code> override. You
     *         can also override existing environment variables (that are specified in the job definition or Docker
     *         image) on a container or add new environment variables to it with an <code>environment</code> override.
     */
    public ContainerOverrides containerOverrides() {
        return containerOverrides;
    }

    /**
     * <p>
     * The retry strategy to use for failed jobs from this <a>SubmitJob</a> operation. When a retry strategy is
     * specified here, it overrides the retry strategy defined in the job definition.
     * </p>
     * 
     * @return The retry strategy to use for failed jobs from this <a>SubmitJob</a> operation. When a retry strategy is
     *         specified here, it overrides the retry strategy defined in the job definition.
     */
    public RetryStrategy retryStrategy() {
        return retryStrategy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(jobName());
        hashCode = 31 * hashCode + Objects.hashCode(jobQueue());
        hashCode = 31 * hashCode + Objects.hashCode(dependsOn());
        hashCode = 31 * hashCode + Objects.hashCode(jobDefinition());
        hashCode = 31 * hashCode + Objects.hashCode(parameters());
        hashCode = 31 * hashCode + Objects.hashCode(containerOverrides());
        hashCode = 31 * hashCode + Objects.hashCode(retryStrategy());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SubmitJobRequest)) {
            return false;
        }
        SubmitJobRequest other = (SubmitJobRequest) obj;
        return Objects.equals(jobName(), other.jobName()) && Objects.equals(jobQueue(), other.jobQueue())
                && Objects.equals(dependsOn(), other.dependsOn()) && Objects.equals(jobDefinition(), other.jobDefinition())
                && Objects.equals(parameters(), other.parameters())
                && Objects.equals(containerOverrides(), other.containerOverrides())
                && Objects.equals(retryStrategy(), other.retryStrategy());
    }

    @Override
    public String toString() {
        return ToString.builder("SubmitJobRequest").add("JobName", jobName()).add("JobQueue", jobQueue())
                .add("DependsOn", dependsOn()).add("JobDefinition", jobDefinition()).add("Parameters", parameters())
                .add("ContainerOverrides", containerOverrides()).add("RetryStrategy", retryStrategy()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "jobName":
            return Optional.of(clazz.cast(jobName()));
        case "jobQueue":
            return Optional.of(clazz.cast(jobQueue()));
        case "dependsOn":
            return Optional.of(clazz.cast(dependsOn()));
        case "jobDefinition":
            return Optional.of(clazz.cast(jobDefinition()));
        case "parameters":
            return Optional.of(clazz.cast(parameters()));
        case "containerOverrides":
            return Optional.of(clazz.cast(containerOverrides()));
        case "retryStrategy":
            return Optional.of(clazz.cast(retryStrategy()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends BatchRequest.Builder, CopyableBuilder<Builder, SubmitJobRequest> {
        /**
         * <p>
         * The name of the job. The first character must be alphanumeric, and up to 128 letters (uppercase and
         * lowercase), numbers, hyphens, and underscores are allowed.
         * </p>
         * 
         * @param jobName
         *        The name of the job. The first character must be alphanumeric, and up to 128 letters (uppercase and
         *        lowercase), numbers, hyphens, and underscores are allowed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobName(String jobName);

        /**
         * <p>
         * The job queue into which the job will be submitted. You can specify either the name or the Amazon Resource
         * Name (ARN) of the queue.
         * </p>
         * 
         * @param jobQueue
         *        The job queue into which the job will be submitted. You can specify either the name or the Amazon
         *        Resource Name (ARN) of the queue.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobQueue(String jobQueue);

        /**
         * <p>
         * A list of job IDs on which this job depends. A job can depend upon a maximum of 20 jobs.
         * </p>
         * 
         * @param dependsOn
         *        A list of job IDs on which this job depends. A job can depend upon a maximum of 20 jobs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dependsOn(Collection<JobDependency> dependsOn);

        /**
         * <p>
         * A list of job IDs on which this job depends. A job can depend upon a maximum of 20 jobs.
         * </p>
         * 
         * @param dependsOn
         *        A list of job IDs on which this job depends. A job can depend upon a maximum of 20 jobs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dependsOn(JobDependency... dependsOn);

        /**
         * <p>
         * A list of job IDs on which this job depends. A job can depend upon a maximum of 20 jobs.
         * </p>
         * This is a convenience that creates an instance of the {@link List<JobDependency>.Builder} avoiding the need
         * to create one manually via {@link List<JobDependency>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<JobDependency>.Builder#build()} is called immediately and
         * its result is passed to {@link #dependsOn(List<JobDependency>)}.
         * 
         * @param dependsOn
         *        a consumer that will call methods on {@link List<JobDependency>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dependsOn(List<JobDependency>)
         */
        Builder dependsOn(Consumer<JobDependency.Builder>... dependsOn);

        /**
         * <p>
         * The job definition used by this job. This value can be either a <code>name:revision</code> or the Amazon
         * Resource Name (ARN) for the job definition.
         * </p>
         * 
         * @param jobDefinition
         *        The job definition used by this job. This value can be either a <code>name:revision</code> or the
         *        Amazon Resource Name (ARN) for the job definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobDefinition(String jobDefinition);

        /**
         * <p>
         * Additional parameters passed to the job that replace parameter substitution placeholders that are set in the
         * job definition. Parameters are specified as a key and value pair mapping. Parameters in a
         * <code>SubmitJob</code> request override any corresponding parameter defaults from the job definition.
         * </p>
         * 
         * @param parameters
         *        Additional parameters passed to the job that replace parameter substitution placeholders that are set
         *        in the job definition. Parameters are specified as a key and value pair mapping. Parameters in a
         *        <code>SubmitJob</code> request override any corresponding parameter defaults from the job definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(Map<String, String> parameters);

        /**
         * <p>
         * A list of container overrides in JSON format that specify the name of a container in the specified job
         * definition and the overrides it should receive. You can override the default command for a container (that is
         * specified in the job definition or the Docker image) with a <code>command</code> override. You can also
         * override existing environment variables (that are specified in the job definition or Docker image) on a
         * container or add new environment variables to it with an <code>environment</code> override.
         * </p>
         * 
         * @param containerOverrides
         *        A list of container overrides in JSON format that specify the name of a container in the specified job
         *        definition and the overrides it should receive. You can override the default command for a container
         *        (that is specified in the job definition or the Docker image) with a <code>command</code> override.
         *        You can also override existing environment variables (that are specified in the job definition or
         *        Docker image) on a container or add new environment variables to it with an <code>environment</code>
         *        override.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containerOverrides(ContainerOverrides containerOverrides);

        /**
         * <p>
         * A list of container overrides in JSON format that specify the name of a container in the specified job
         * definition and the overrides it should receive. You can override the default command for a container (that is
         * specified in the job definition or the Docker image) with a <code>command</code> override. You can also
         * override existing environment variables (that are specified in the job definition or Docker image) on a
         * container or add new environment variables to it with an <code>environment</code> override.
         * </p>
         * This is a convenience that creates an instance of the {@link ContainerOverrides.Builder} avoiding the need to
         * create one manually via {@link ContainerOverrides#builder()}.
         *
         * When the {@link Consumer} completes, {@link ContainerOverrides.Builder#build()} is called immediately and its
         * result is passed to {@link #containerOverrides(ContainerOverrides)}.
         * 
         * @param containerOverrides
         *        a consumer that will call methods on {@link ContainerOverrides.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #containerOverrides(ContainerOverrides)
         */
        default Builder containerOverrides(Consumer<ContainerOverrides.Builder> containerOverrides) {
            return containerOverrides(ContainerOverrides.builder().apply(containerOverrides).build());
        }

        /**
         * <p>
         * The retry strategy to use for failed jobs from this <a>SubmitJob</a> operation. When a retry strategy is
         * specified here, it overrides the retry strategy defined in the job definition.
         * </p>
         * 
         * @param retryStrategy
         *        The retry strategy to use for failed jobs from this <a>SubmitJob</a> operation. When a retry strategy
         *        is specified here, it overrides the retry strategy defined in the job definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retryStrategy(RetryStrategy retryStrategy);

        /**
         * <p>
         * The retry strategy to use for failed jobs from this <a>SubmitJob</a> operation. When a retry strategy is
         * specified here, it overrides the retry strategy defined in the job definition.
         * </p>
         * This is a convenience that creates an instance of the {@link RetryStrategy.Builder} avoiding the need to
         * create one manually via {@link RetryStrategy#builder()}.
         *
         * When the {@link Consumer} completes, {@link RetryStrategy.Builder#build()} is called immediately and its
         * result is passed to {@link #retryStrategy(RetryStrategy)}.
         * 
         * @param retryStrategy
         *        a consumer that will call methods on {@link RetryStrategy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #retryStrategy(RetryStrategy)
         */
        default Builder retryStrategy(Consumer<RetryStrategy.Builder> retryStrategy) {
            return retryStrategy(RetryStrategy.builder().apply(retryStrategy).build());
        }

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);

        @Override
        Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BatchRequest.BuilderImpl implements Builder {
        private String jobName;

        private String jobQueue;

        private List<JobDependency> dependsOn;

        private String jobDefinition;

        private Map<String, String> parameters;

        private ContainerOverrides containerOverrides;

        private RetryStrategy retryStrategy;

        private BuilderImpl() {
        }

        private BuilderImpl(SubmitJobRequest model) {
            super(model);
            jobName(model.jobName);
            jobQueue(model.jobQueue);
            dependsOn(model.dependsOn);
            jobDefinition(model.jobDefinition);
            parameters(model.parameters);
            containerOverrides(model.containerOverrides);
            retryStrategy(model.retryStrategy);
        }

        public final String getJobName() {
            return jobName;
        }

        @Override
        public final Builder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public final void setJobName(String jobName) {
            this.jobName = jobName;
        }

        public final String getJobQueue() {
            return jobQueue;
        }

        @Override
        public final Builder jobQueue(String jobQueue) {
            this.jobQueue = jobQueue;
            return this;
        }

        public final void setJobQueue(String jobQueue) {
            this.jobQueue = jobQueue;
        }

        public final Collection<JobDependency.Builder> getDependsOn() {
            return dependsOn != null ? dependsOn.stream().map(JobDependency::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder dependsOn(Collection<JobDependency> dependsOn) {
            this.dependsOn = JobDependencyListCopier.copy(dependsOn);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dependsOn(JobDependency... dependsOn) {
            dependsOn(Arrays.asList(dependsOn));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dependsOn(Consumer<JobDependency.Builder>... dependsOn) {
            dependsOn(Stream.of(dependsOn).map(c -> JobDependency.builder().apply(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDependsOn(Collection<JobDependency.BuilderImpl> dependsOn) {
            this.dependsOn = JobDependencyListCopier.copyFromBuilder(dependsOn);
        }

        public final String getJobDefinition() {
            return jobDefinition;
        }

        @Override
        public final Builder jobDefinition(String jobDefinition) {
            this.jobDefinition = jobDefinition;
            return this;
        }

        public final void setJobDefinition(String jobDefinition) {
            this.jobDefinition = jobDefinition;
        }

        public final Map<String, String> getParameters() {
            return parameters;
        }

        @Override
        public final Builder parameters(Map<String, String> parameters) {
            this.parameters = ParametersMapCopier.copy(parameters);
            return this;
        }

        public final void setParameters(Map<String, String> parameters) {
            this.parameters = ParametersMapCopier.copy(parameters);
        }

        public final ContainerOverrides.Builder getContainerOverrides() {
            return containerOverrides != null ? containerOverrides.toBuilder() : null;
        }

        @Override
        public final Builder containerOverrides(ContainerOverrides containerOverrides) {
            this.containerOverrides = containerOverrides;
            return this;
        }

        public final void setContainerOverrides(ContainerOverrides.BuilderImpl containerOverrides) {
            this.containerOverrides = containerOverrides != null ? containerOverrides.build() : null;
        }

        public final RetryStrategy.Builder getRetryStrategy() {
            return retryStrategy != null ? retryStrategy.toBuilder() : null;
        }

        @Override
        public final Builder retryStrategy(RetryStrategy retryStrategy) {
            this.retryStrategy = retryStrategy;
            return this;
        }

        public final void setRetryStrategy(RetryStrategy.BuilderImpl retryStrategy) {
            this.retryStrategy = retryStrategy != null ? retryStrategy.build() : null;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public SubmitJobRequest build() {
            return new SubmitJobRequest(this);
        }
    }
}
