/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.batch.transform;

import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.batch.model.AttemptContainerDetail;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link AttemptContainerDetail} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class AttemptContainerDetailMarshaller {
    private static final MarshallingInfo<String> CONTAINERINSTANCEARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("containerInstanceArn").isBinary(false).build();

    private static final MarshallingInfo<String> TASKARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("taskArn").isBinary(false).build();

    private static final MarshallingInfo<Integer> EXITCODE_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("exitCode").isBinary(false).build();

    private static final MarshallingInfo<String> REASON_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("reason").isBinary(false).build();

    private static final MarshallingInfo<String> LOGSTREAMNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("logStreamName").isBinary(false).build();

    private static final AttemptContainerDetailMarshaller INSTANCE = new AttemptContainerDetailMarshaller();

    private AttemptContainerDetailMarshaller() {
    }

    public static AttemptContainerDetailMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(AttemptContainerDetail attemptContainerDetail, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(attemptContainerDetail, "attemptContainerDetail");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(attemptContainerDetail.containerInstanceArn(), CONTAINERINSTANCEARN_BINDING);
            protocolMarshaller.marshall(attemptContainerDetail.taskArn(), TASKARN_BINDING);
            protocolMarshaller.marshall(attemptContainerDetail.exitCode(), EXITCODE_BINDING);
            protocolMarshaller.marshall(attemptContainerDetail.reason(), REASON_BINDING);
            protocolMarshaller.marshall(attemptContainerDetail.logStreamName(), LOGSTREAMNAME_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}
