/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.batch.transform;

import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.batch.model.ComputeResourceUpdate;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link ComputeResourceUpdate} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class ComputeResourceUpdateMarshaller {
    private static final MarshallingInfo<Integer> MINVCPUS_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("minvCpus").isBinary(false).build();

    private static final MarshallingInfo<Integer> MAXVCPUS_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("maxvCpus").isBinary(false).build();

    private static final MarshallingInfo<Integer> DESIREDVCPUS_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("desiredvCpus").isBinary(false).build();

    private static final ComputeResourceUpdateMarshaller INSTANCE = new ComputeResourceUpdateMarshaller();

    private ComputeResourceUpdateMarshaller() {
    }

    public static ComputeResourceUpdateMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(ComputeResourceUpdate computeResourceUpdate, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(computeResourceUpdate, "computeResourceUpdate");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(computeResourceUpdate.minvCpus(), MINVCPUS_BINDING);
            protocolMarshaller.marshall(computeResourceUpdate.maxvCpus(), MAXVCPUS_BINDING);
            protocolMarshaller.marshall(computeResourceUpdate.desiredvCpus(), DESIREDVCPUS_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}
