/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.model;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.batch.model.BatchRequest;
import software.amazon.awssdk.services.batch.model.ContainerProperties;
import software.amazon.awssdk.services.batch.model.JobDefinitionType;
import software.amazon.awssdk.services.batch.model.ParametersMapCopier;
import software.amazon.awssdk.services.batch.model.RetryStrategy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class RegisterJobDefinitionRequest
extends BatchRequest
implements ToCopyableBuilder<Builder, RegisterJobDefinitionRequest> {
    private final String jobDefinitionName;
    private final String type;
    private final Map<String, String> parameters;
    private final ContainerProperties containerProperties;
    private final RetryStrategy retryStrategy;

    private RegisterJobDefinitionRequest(BuilderImpl builder) {
        super(builder);
        this.jobDefinitionName = builder.jobDefinitionName;
        this.type = builder.type;
        this.parameters = builder.parameters;
        this.containerProperties = builder.containerProperties;
        this.retryStrategy = builder.retryStrategy;
    }

    public String jobDefinitionName() {
        return this.jobDefinitionName;
    }

    public JobDefinitionType type() {
        return JobDefinitionType.fromValue(this.type);
    }

    public String typeAsString() {
        return this.type;
    }

    public Map<String, String> parameters() {
        return this.parameters;
    }

    public ContainerProperties containerProperties() {
        return this.containerProperties;
    }

    public RetryStrategy retryStrategy() {
        return this.retryStrategy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.jobDefinitionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.parameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.containerProperties());
        hashCode = 31 * hashCode + Objects.hashCode(this.retryStrategy());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterJobDefinitionRequest)) {
            return false;
        }
        RegisterJobDefinitionRequest other = (RegisterJobDefinitionRequest)((Object)obj);
        return Objects.equals(this.jobDefinitionName(), other.jobDefinitionName()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.parameters(), other.parameters()) && Objects.equals(this.containerProperties(), other.containerProperties()) && Objects.equals(this.retryStrategy(), other.retryStrategy());
    }

    public String toString() {
        return ToString.builder((String)"RegisterJobDefinitionRequest").add("JobDefinitionName", (Object)this.jobDefinitionName()).add("Type", (Object)this.typeAsString()).add("Parameters", this.parameters()).add("ContainerProperties", (Object)this.containerProperties()).add("RetryStrategy", (Object)this.retryStrategy()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "jobDefinitionName": {
                return Optional.of(clazz.cast(this.jobDefinitionName()));
            }
            case "type": {
                return Optional.of(clazz.cast(this.typeAsString()));
            }
            case "parameters": {
                return Optional.of(clazz.cast(this.parameters()));
            }
            case "containerProperties": {
                return Optional.of(clazz.cast(this.containerProperties()));
            }
            case "retryStrategy": {
                return Optional.of(clazz.cast(this.retryStrategy()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends BatchRequest.BuilderImpl
    implements Builder {
        private String jobDefinitionName;
        private String type;
        private Map<String, String> parameters;
        private ContainerProperties containerProperties;
        private RetryStrategy retryStrategy;

        private BuilderImpl() {
        }

        private BuilderImpl(RegisterJobDefinitionRequest model) {
            super(model);
            this.jobDefinitionName(model.jobDefinitionName);
            this.type(model.type);
            this.parameters(model.parameters);
            this.containerProperties(model.containerProperties);
            this.retryStrategy(model.retryStrategy);
        }

        public final String getJobDefinitionName() {
            return this.jobDefinitionName;
        }

        @Override
        public final Builder jobDefinitionName(String jobDefinitionName) {
            this.jobDefinitionName = jobDefinitionName;
            return this;
        }

        public final void setJobDefinitionName(String jobDefinitionName) {
            this.jobDefinitionName = jobDefinitionName;
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(JobDefinitionType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final Map<String, String> getParameters() {
            return this.parameters;
        }

        @Override
        public final Builder parameters(Map<String, String> parameters) {
            this.parameters = ParametersMapCopier.copy(parameters);
            return this;
        }

        public final void setParameters(Map<String, String> parameters) {
            this.parameters = ParametersMapCopier.copy(parameters);
        }

        public final ContainerProperties.Builder getContainerProperties() {
            return this.containerProperties != null ? this.containerProperties.toBuilder() : null;
        }

        @Override
        public final Builder containerProperties(ContainerProperties containerProperties) {
            this.containerProperties = containerProperties;
            return this;
        }

        public final void setContainerProperties(ContainerProperties.BuilderImpl containerProperties) {
            this.containerProperties = containerProperties != null ? containerProperties.build() : null;
        }

        public final RetryStrategy.Builder getRetryStrategy() {
            return this.retryStrategy != null ? this.retryStrategy.toBuilder() : null;
        }

        @Override
        public final Builder retryStrategy(RetryStrategy retryStrategy) {
            this.retryStrategy = retryStrategy;
            return this;
        }

        public final void setRetryStrategy(RetryStrategy.BuilderImpl retryStrategy) {
            this.retryStrategy = retryStrategy != null ? retryStrategy.build() : null;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public RegisterJobDefinitionRequest build() {
            return new RegisterJobDefinitionRequest(this);
        }
    }

    public static interface Builder
    extends BatchRequest.Builder,
    CopyableBuilder<Builder, RegisterJobDefinitionRequest> {
        public Builder jobDefinitionName(String var1);

        public Builder type(String var1);

        public Builder type(JobDefinitionType var1);

        public Builder parameters(Map<String, String> var1);

        public Builder containerProperties(ContainerProperties var1);

        default public Builder containerProperties(Consumer<ContainerProperties.Builder> containerProperties) {
            return this.containerProperties((ContainerProperties)((ContainerProperties.Builder)ContainerProperties.builder().apply(containerProperties)).build());
        }

        public Builder retryStrategy(RetryStrategy var1);

        default public Builder retryStrategy(Consumer<RetryStrategy.Builder> retryStrategy) {
            return this.retryStrategy((RetryStrategy)((RetryStrategy.Builder)RetryStrategy.builder().apply(retryStrategy)).build());
        }

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

