/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.batch.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.batch.transform.ArrayPropertiesSummaryMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object representing the array properties of a job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ArrayPropertiesSummary implements StructuredPojo,
        ToCopyableBuilder<ArrayPropertiesSummary.Builder, ArrayPropertiesSummary> {
    private final Integer size;

    private final Integer index;

    private ArrayPropertiesSummary(BuilderImpl builder) {
        this.size = builder.size;
        this.index = builder.index;
    }

    /**
     * <p>
     * The size of the array job. This parameter is returned for parent array jobs.
     * </p>
     * 
     * @return The size of the array job. This parameter is returned for parent array jobs.
     */
    public Integer size() {
        return size;
    }

    /**
     * <p>
     * The job index within the array that is associated with this job. This parameter is returned for children of array
     * jobs.
     * </p>
     * 
     * @return The job index within the array that is associated with this job. This parameter is returned for children
     *         of array jobs.
     */
    public Integer index() {
        return index;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(size());
        hashCode = 31 * hashCode + Objects.hashCode(index());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ArrayPropertiesSummary)) {
            return false;
        }
        ArrayPropertiesSummary other = (ArrayPropertiesSummary) obj;
        return Objects.equals(size(), other.size()) && Objects.equals(index(), other.index());
    }

    @Override
    public String toString() {
        return ToString.builder("ArrayPropertiesSummary").add("Size", size()).add("Index", index()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "size":
            return Optional.ofNullable(clazz.cast(size()));
        case "index":
            return Optional.ofNullable(clazz.cast(index()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ArrayPropertiesSummaryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, ArrayPropertiesSummary> {
        /**
         * <p>
         * The size of the array job. This parameter is returned for parent array jobs.
         * </p>
         * 
         * @param size
         *        The size of the array job. This parameter is returned for parent array jobs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder size(Integer size);

        /**
         * <p>
         * The job index within the array that is associated with this job. This parameter is returned for children of
         * array jobs.
         * </p>
         * 
         * @param index
         *        The job index within the array that is associated with this job. This parameter is returned for
         *        children of array jobs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder index(Integer index);
    }

    static final class BuilderImpl implements Builder {
        private Integer size;

        private Integer index;

        private BuilderImpl() {
        }

        private BuilderImpl(ArrayPropertiesSummary model) {
            size(model.size);
            index(model.index);
        }

        public final Integer getSize() {
            return size;
        }

        @Override
        public final Builder size(Integer size) {
            this.size = size;
            return this;
        }

        public final void setSize(Integer size) {
            this.size = size;
        }

        public final Integer getIndex() {
            return index;
        }

        @Override
        public final Builder index(Integer index) {
            this.index = index;
            return this;
        }

        public final void setIndex(Integer index) {
            this.index = index;
        }

        @Override
        public ArrayPropertiesSummary build() {
            return new ArrayPropertiesSummary(this);
        }
    }
}
