/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.batch.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.batch.transform.JobDependencyMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object representing an AWS Batch job dependency.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class JobDependency implements StructuredPojo, ToCopyableBuilder<JobDependency.Builder, JobDependency> {
    private final String jobId;

    private final String type;

    private JobDependency(BuilderImpl builder) {
        this.jobId = builder.jobId;
        this.type = builder.type;
    }

    /**
     * <p>
     * The job ID of the AWS Batch job associated with this dependency.
     * </p>
     * 
     * @return The job ID of the AWS Batch job associated with this dependency.
     */
    public String jobId() {
        return jobId;
    }

    /**
     * <p>
     * The type of the job dependency.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ArrayJobDependency#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the job dependency.
     * @see ArrayJobDependency
     */
    public ArrayJobDependency type() {
        return ArrayJobDependency.fromValue(type);
    }

    /**
     * <p>
     * The type of the job dependency.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ArrayJobDependency#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the job dependency.
     * @see ArrayJobDependency
     */
    public String typeAsString() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(jobId());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobDependency)) {
            return false;
        }
        JobDependency other = (JobDependency) obj;
        return Objects.equals(jobId(), other.jobId()) && Objects.equals(typeAsString(), other.typeAsString());
    }

    @Override
    public String toString() {
        return ToString.builder("JobDependency").add("JobId", jobId()).add("Type", typeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "jobId":
            return Optional.ofNullable(clazz.cast(jobId()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        JobDependencyMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, JobDependency> {
        /**
         * <p>
         * The job ID of the AWS Batch job associated with this dependency.
         * </p>
         * 
         * @param jobId
         *        The job ID of the AWS Batch job associated with this dependency.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobId(String jobId);

        /**
         * <p>
         * The type of the job dependency.
         * </p>
         * 
         * @param type
         *        The type of the job dependency.
         * @see ArrayJobDependency
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ArrayJobDependency
         */
        Builder type(String type);

        /**
         * <p>
         * The type of the job dependency.
         * </p>
         * 
         * @param type
         *        The type of the job dependency.
         * @see ArrayJobDependency
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ArrayJobDependency
         */
        Builder type(ArrayJobDependency type);
    }

    static final class BuilderImpl implements Builder {
        private String jobId;

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(JobDependency model) {
            jobId(model.jobId);
            type(model.type);
        }

        public final String getJobId() {
            return jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        public final String getType() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ArrayJobDependency type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public JobDependency build() {
            return new JobDependency(this);
        }
    }
}
