/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.batch.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.batch.transform.KeyValuePairMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A key-value pair object.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class KeyValuePair implements StructuredPojo, ToCopyableBuilder<KeyValuePair.Builder, KeyValuePair> {
    private final String name;

    private final String value;

    private KeyValuePair(BuilderImpl builder) {
        this.name = builder.name;
        this.value = builder.value;
    }

    /**
     * <p>
     * The name of the key-value pair. For environment variables, this is the name of the environment variable.
     * </p>
     * 
     * @return The name of the key-value pair. For environment variables, this is the name of the environment variable.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The value of the key-value pair. For environment variables, this is the value of the environment variable.
     * </p>
     * 
     * @return The value of the key-value pair. For environment variables, this is the value of the environment
     *         variable.
     */
    public String value() {
        return value;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KeyValuePair)) {
            return false;
        }
        KeyValuePair other = (KeyValuePair) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(value(), other.value());
    }

    @Override
    public String toString() {
        return ToString.builder("KeyValuePair").add("Name", name()).add("Value", value()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "value":
            return Optional.ofNullable(clazz.cast(value()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        KeyValuePairMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, KeyValuePair> {
        /**
         * <p>
         * The name of the key-value pair. For environment variables, this is the name of the environment variable.
         * </p>
         * 
         * @param name
         *        The name of the key-value pair. For environment variables, this is the name of the environment
         *        variable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The value of the key-value pair. For environment variables, this is the value of the environment variable.
         * </p>
         * 
         * @param value
         *        The value of the key-value pair. For environment variables, this is the value of the environment
         *        variable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(String value);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String value;

        private BuilderImpl() {
        }

        private BuilderImpl(KeyValuePair model) {
            name(model.name);
            value(model.value);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getValue() {
            return value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        @Override
        public KeyValuePair build() {
            return new KeyValuePair(this);
        }
    }
}
