/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.batch.model;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RegisterJobDefinitionRequest extends BatchRequest implements
        ToCopyableBuilder<RegisterJobDefinitionRequest.Builder, RegisterJobDefinitionRequest> {
    private final String jobDefinitionName;

    private final String type;

    private final Map<String, String> parameters;

    private final ContainerProperties containerProperties;

    private final RetryStrategy retryStrategy;

    private final JobTimeout timeout;

    private RegisterJobDefinitionRequest(BuilderImpl builder) {
        super(builder);
        this.jobDefinitionName = builder.jobDefinitionName;
        this.type = builder.type;
        this.parameters = builder.parameters;
        this.containerProperties = builder.containerProperties;
        this.retryStrategy = builder.retryStrategy;
        this.timeout = builder.timeout;
    }

    /**
     * <p>
     * The name of the job definition to register. Up to 128 letters (uppercase and lowercase), numbers, hyphens, and
     * underscores are allowed.
     * </p>
     * 
     * @return The name of the job definition to register. Up to 128 letters (uppercase and lowercase), numbers,
     *         hyphens, and underscores are allowed.
     */
    public String jobDefinitionName() {
        return jobDefinitionName;
    }

    /**
     * <p>
     * The type of job definition.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link JobDefinitionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of job definition.
     * @see JobDefinitionType
     */
    public JobDefinitionType type() {
        return JobDefinitionType.fromValue(type);
    }

    /**
     * <p>
     * The type of job definition.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link JobDefinitionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of job definition.
     * @see JobDefinitionType
     */
    public String typeAsString() {
        return type;
    }

    /**
     * <p>
     * Default parameter substitution placeholders to set in the job definition. Parameters are specified as a key-value
     * pair mapping. Parameters in a <code>SubmitJob</code> request override any corresponding parameter defaults from
     * the job definition.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Default parameter substitution placeholders to set in the job definition. Parameters are specified as a
     *         key-value pair mapping. Parameters in a <code>SubmitJob</code> request override any corresponding
     *         parameter defaults from the job definition.
     */
    public Map<String, String> parameters() {
        return parameters;
    }

    /**
     * <p>
     * An object with various properties specific for container-based jobs. This parameter is required if the
     * <code>type</code> parameter is <code>container</code>.
     * </p>
     * 
     * @return An object with various properties specific for container-based jobs. This parameter is required if the
     *         <code>type</code> parameter is <code>container</code>.
     */
    public ContainerProperties containerProperties() {
        return containerProperties;
    }

    /**
     * <p>
     * The retry strategy to use for failed jobs that are submitted with this job definition. Any retry strategy that is
     * specified during a <a>SubmitJob</a> operation overrides the retry strategy defined here. If a job is terminated
     * due to a timeout, it is not retried.
     * </p>
     * 
     * @return The retry strategy to use for failed jobs that are submitted with this job definition. Any retry strategy
     *         that is specified during a <a>SubmitJob</a> operation overrides the retry strategy defined here. If a job
     *         is terminated due to a timeout, it is not retried.
     */
    public RetryStrategy retryStrategy() {
        return retryStrategy;
    }

    /**
     * <p>
     * The timeout configuration for jobs that are submitted with this job definition, after which AWS Batch terminates
     * your jobs if they have not finished. If a job is terminated due to a timeout, it is not retried. The minimum
     * value for the timeout is 60 seconds. Any timeout configuration that is specified during a <a>SubmitJob</a>
     * operation overrides the timeout configuration defined here. For more information, see <a
     * href="http://docs.aws.amazon.com/AmazonECS/latest/developerguide/job_timeouts.html">Job Timeouts</a> in the
     * <i>Amazon Elastic Container Service Developer Guide</i>.
     * </p>
     * 
     * @return The timeout configuration for jobs that are submitted with this job definition, after which AWS Batch
     *         terminates your jobs if they have not finished. If a job is terminated due to a timeout, it is not
     *         retried. The minimum value for the timeout is 60 seconds. Any timeout configuration that is specified
     *         during a <a>SubmitJob</a> operation overrides the timeout configuration defined here. For more
     *         information, see <a
     *         href="http://docs.aws.amazon.com/AmazonECS/latest/developerguide/job_timeouts.html">Job Timeouts</a> in
     *         the <i>Amazon Elastic Container Service Developer Guide</i>.
     */
    public JobTimeout timeout() {
        return timeout;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(jobDefinitionName());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(parameters());
        hashCode = 31 * hashCode + Objects.hashCode(containerProperties());
        hashCode = 31 * hashCode + Objects.hashCode(retryStrategy());
        hashCode = 31 * hashCode + Objects.hashCode(timeout());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterJobDefinitionRequest)) {
            return false;
        }
        RegisterJobDefinitionRequest other = (RegisterJobDefinitionRequest) obj;
        return Objects.equals(jobDefinitionName(), other.jobDefinitionName())
                && Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(parameters(), other.parameters())
                && Objects.equals(containerProperties(), other.containerProperties())
                && Objects.equals(retryStrategy(), other.retryStrategy()) && Objects.equals(timeout(), other.timeout());
    }

    @Override
    public String toString() {
        return ToString.builder("RegisterJobDefinitionRequest").add("JobDefinitionName", jobDefinitionName())
                .add("Type", typeAsString()).add("Parameters", parameters()).add("ContainerProperties", containerProperties())
                .add("RetryStrategy", retryStrategy()).add("Timeout", timeout()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "jobDefinitionName":
            return Optional.ofNullable(clazz.cast(jobDefinitionName()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "parameters":
            return Optional.ofNullable(clazz.cast(parameters()));
        case "containerProperties":
            return Optional.ofNullable(clazz.cast(containerProperties()));
        case "retryStrategy":
            return Optional.ofNullable(clazz.cast(retryStrategy()));
        case "timeout":
            return Optional.ofNullable(clazz.cast(timeout()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends BatchRequest.Builder, CopyableBuilder<Builder, RegisterJobDefinitionRequest> {
        /**
         * <p>
         * The name of the job definition to register. Up to 128 letters (uppercase and lowercase), numbers, hyphens,
         * and underscores are allowed.
         * </p>
         * 
         * @param jobDefinitionName
         *        The name of the job definition to register. Up to 128 letters (uppercase and lowercase), numbers,
         *        hyphens, and underscores are allowed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobDefinitionName(String jobDefinitionName);

        /**
         * <p>
         * The type of job definition.
         * </p>
         * 
         * @param type
         *        The type of job definition.
         * @see JobDefinitionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobDefinitionType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of job definition.
         * </p>
         * 
         * @param type
         *        The type of job definition.
         * @see JobDefinitionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobDefinitionType
         */
        Builder type(JobDefinitionType type);

        /**
         * <p>
         * Default parameter substitution placeholders to set in the job definition. Parameters are specified as a
         * key-value pair mapping. Parameters in a <code>SubmitJob</code> request override any corresponding parameter
         * defaults from the job definition.
         * </p>
         * 
         * @param parameters
         *        Default parameter substitution placeholders to set in the job definition. Parameters are specified as
         *        a key-value pair mapping. Parameters in a <code>SubmitJob</code> request override any corresponding
         *        parameter defaults from the job definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(Map<String, String> parameters);

        /**
         * <p>
         * An object with various properties specific for container-based jobs. This parameter is required if the
         * <code>type</code> parameter is <code>container</code>.
         * </p>
         * 
         * @param containerProperties
         *        An object with various properties specific for container-based jobs. This parameter is required if the
         *        <code>type</code> parameter is <code>container</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containerProperties(ContainerProperties containerProperties);

        /**
         * <p>
         * An object with various properties specific for container-based jobs. This parameter is required if the
         * <code>type</code> parameter is <code>container</code>.
         * </p>
         * This is a convenience that creates an instance of the {@link ContainerProperties.Builder} avoiding the need
         * to create one manually via {@link ContainerProperties#builder()}.
         *
         * When the {@link Consumer} completes, {@link ContainerProperties.Builder#build()} is called immediately and
         * its result is passed to {@link #containerProperties(ContainerProperties)}.
         * 
         * @param containerProperties
         *        a consumer that will call methods on {@link ContainerProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #containerProperties(ContainerProperties)
         */
        default Builder containerProperties(Consumer<ContainerProperties.Builder> containerProperties) {
            return containerProperties(ContainerProperties.builder().applyMutation(containerProperties).build());
        }

        /**
         * <p>
         * The retry strategy to use for failed jobs that are submitted with this job definition. Any retry strategy
         * that is specified during a <a>SubmitJob</a> operation overrides the retry strategy defined here. If a job is
         * terminated due to a timeout, it is not retried.
         * </p>
         * 
         * @param retryStrategy
         *        The retry strategy to use for failed jobs that are submitted with this job definition. Any retry
         *        strategy that is specified during a <a>SubmitJob</a> operation overrides the retry strategy defined
         *        here. If a job is terminated due to a timeout, it is not retried.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retryStrategy(RetryStrategy retryStrategy);

        /**
         * <p>
         * The retry strategy to use for failed jobs that are submitted with this job definition. Any retry strategy
         * that is specified during a <a>SubmitJob</a> operation overrides the retry strategy defined here. If a job is
         * terminated due to a timeout, it is not retried.
         * </p>
         * This is a convenience that creates an instance of the {@link RetryStrategy.Builder} avoiding the need to
         * create one manually via {@link RetryStrategy#builder()}.
         *
         * When the {@link Consumer} completes, {@link RetryStrategy.Builder#build()} is called immediately and its
         * result is passed to {@link #retryStrategy(RetryStrategy)}.
         * 
         * @param retryStrategy
         *        a consumer that will call methods on {@link RetryStrategy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #retryStrategy(RetryStrategy)
         */
        default Builder retryStrategy(Consumer<RetryStrategy.Builder> retryStrategy) {
            return retryStrategy(RetryStrategy.builder().applyMutation(retryStrategy).build());
        }

        /**
         * <p>
         * The timeout configuration for jobs that are submitted with this job definition, after which AWS Batch
         * terminates your jobs if they have not finished. If a job is terminated due to a timeout, it is not retried.
         * The minimum value for the timeout is 60 seconds. Any timeout configuration that is specified during a
         * <a>SubmitJob</a> operation overrides the timeout configuration defined here. For more information, see <a
         * href="http://docs.aws.amazon.com/AmazonECS/latest/developerguide/job_timeouts.html">Job Timeouts</a> in the
         * <i>Amazon Elastic Container Service Developer Guide</i>.
         * </p>
         * 
         * @param timeout
         *        The timeout configuration for jobs that are submitted with this job definition, after which AWS Batch
         *        terminates your jobs if they have not finished. If a job is terminated due to a timeout, it is not
         *        retried. The minimum value for the timeout is 60 seconds. Any timeout configuration that is specified
         *        during a <a>SubmitJob</a> operation overrides the timeout configuration defined here. For more
         *        information, see <a
         *        href="http://docs.aws.amazon.com/AmazonECS/latest/developerguide/job_timeouts.html">Job Timeouts</a>
         *        in the <i>Amazon Elastic Container Service Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeout(JobTimeout timeout);

        /**
         * <p>
         * The timeout configuration for jobs that are submitted with this job definition, after which AWS Batch
         * terminates your jobs if they have not finished. If a job is terminated due to a timeout, it is not retried.
         * The minimum value for the timeout is 60 seconds. Any timeout configuration that is specified during a
         * <a>SubmitJob</a> operation overrides the timeout configuration defined here. For more information, see <a
         * href="http://docs.aws.amazon.com/AmazonECS/latest/developerguide/job_timeouts.html">Job Timeouts</a> in the
         * <i>Amazon Elastic Container Service Developer Guide</i>.
         * </p>
         * This is a convenience that creates an instance of the {@link JobTimeout.Builder} avoiding the need to create
         * one manually via {@link JobTimeout#builder()}.
         *
         * When the {@link Consumer} completes, {@link JobTimeout.Builder#build()} is called immediately and its result
         * is passed to {@link #timeout(JobTimeout)}.
         * 
         * @param timeout
         *        a consumer that will call methods on {@link JobTimeout.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #timeout(JobTimeout)
         */
        default Builder timeout(Consumer<JobTimeout.Builder> timeout) {
            return timeout(JobTimeout.builder().applyMutation(timeout).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BatchRequest.BuilderImpl implements Builder {
        private String jobDefinitionName;

        private String type;

        private Map<String, String> parameters = DefaultSdkAutoConstructMap.getInstance();

        private ContainerProperties containerProperties;

        private RetryStrategy retryStrategy;

        private JobTimeout timeout;

        private BuilderImpl() {
        }

        private BuilderImpl(RegisterJobDefinitionRequest model) {
            super(model);
            jobDefinitionName(model.jobDefinitionName);
            type(model.type);
            parameters(model.parameters);
            containerProperties(model.containerProperties);
            retryStrategy(model.retryStrategy);
            timeout(model.timeout);
        }

        public final String getJobDefinitionName() {
            return jobDefinitionName;
        }

        @Override
        public final Builder jobDefinitionName(String jobDefinitionName) {
            this.jobDefinitionName = jobDefinitionName;
            return this;
        }

        public final void setJobDefinitionName(String jobDefinitionName) {
            this.jobDefinitionName = jobDefinitionName;
        }

        public final String getType() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(JobDefinitionType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final Map<String, String> getParameters() {
            return parameters;
        }

        @Override
        public final Builder parameters(Map<String, String> parameters) {
            this.parameters = ParametersMapCopier.copy(parameters);
            return this;
        }

        public final void setParameters(Map<String, String> parameters) {
            this.parameters = ParametersMapCopier.copy(parameters);
        }

        public final ContainerProperties.Builder getContainerProperties() {
            return containerProperties != null ? containerProperties.toBuilder() : null;
        }

        @Override
        public final Builder containerProperties(ContainerProperties containerProperties) {
            this.containerProperties = containerProperties;
            return this;
        }

        public final void setContainerProperties(ContainerProperties.BuilderImpl containerProperties) {
            this.containerProperties = containerProperties != null ? containerProperties.build() : null;
        }

        public final RetryStrategy.Builder getRetryStrategy() {
            return retryStrategy != null ? retryStrategy.toBuilder() : null;
        }

        @Override
        public final Builder retryStrategy(RetryStrategy retryStrategy) {
            this.retryStrategy = retryStrategy;
            return this;
        }

        public final void setRetryStrategy(RetryStrategy.BuilderImpl retryStrategy) {
            this.retryStrategy = retryStrategy != null ? retryStrategy.build() : null;
        }

        public final JobTimeout.Builder getTimeout() {
            return timeout != null ? timeout.toBuilder() : null;
        }

        @Override
        public final Builder timeout(JobTimeout timeout) {
            this.timeout = timeout;
            return this;
        }

        public final void setTimeout(JobTimeout.BuilderImpl timeout) {
            this.timeout = timeout != null ? timeout.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RegisterJobDefinitionRequest build() {
            return new RegisterJobDefinitionRequest(this);
        }
    }
}
