/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.batch.transform;

import java.util.Map;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.batch.model.ArrayPropertiesDetail;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link ArrayPropertiesDetail} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class ArrayPropertiesDetailMarshaller {
    private static final MarshallingInfo<Map> STATUSSUMMARY_BINDING = MarshallingInfo.builder(MarshallingType.MAP)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("statusSummary").isBinary(false).build();

    private static final MarshallingInfo<Integer> SIZE_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("size").isBinary(false).build();

    private static final MarshallingInfo<Integer> INDEX_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("index").isBinary(false).build();

    private static final ArrayPropertiesDetailMarshaller INSTANCE = new ArrayPropertiesDetailMarshaller();

    private ArrayPropertiesDetailMarshaller() {
    }

    public static ArrayPropertiesDetailMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(ArrayPropertiesDetail arrayPropertiesDetail, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(arrayPropertiesDetail, "arrayPropertiesDetail");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(arrayPropertiesDetail.statusSummary(), STATUSSUMMARY_BINDING);
            protocolMarshaller.marshall(arrayPropertiesDetail.size(), SIZE_BINDING);
            protocolMarshaller.marshall(arrayPropertiesDetail.index(), INDEX_BINDING);
        } catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause(e).build();
        }
    }
}
