/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.batch.transform;

import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.batch.model.ContainerDetail;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link ContainerDetail} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class ContainerDetailMarshaller {
    private static final MarshallingInfo<String> IMAGE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("image").isBinary(false).build();

    private static final MarshallingInfo<Integer> VCPUS_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("vcpus").isBinary(false).build();

    private static final MarshallingInfo<Integer> MEMORY_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("memory").isBinary(false).build();

    private static final MarshallingInfo<List> COMMAND_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("command").isBinary(false).build();

    private static final MarshallingInfo<String> JOBROLEARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("jobRoleArn").isBinary(false).build();

    private static final MarshallingInfo<List> VOLUMES_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("volumes").isBinary(false).build();

    private static final MarshallingInfo<List> ENVIRONMENT_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("environment").isBinary(false).build();

    private static final MarshallingInfo<List> MOUNTPOINTS_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("mountPoints").isBinary(false).build();

    private static final MarshallingInfo<Boolean> READONLYROOTFILESYSTEM_BINDING = MarshallingInfo
            .builder(MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("readonlyRootFilesystem").isBinary(false).build();

    private static final MarshallingInfo<List> ULIMITS_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ulimits").isBinary(false).build();

    private static final MarshallingInfo<Boolean> PRIVILEGED_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("privileged").isBinary(false).build();

    private static final MarshallingInfo<String> USER_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("user").isBinary(false).build();

    private static final MarshallingInfo<Integer> EXITCODE_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("exitCode").isBinary(false).build();

    private static final MarshallingInfo<String> REASON_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("reason").isBinary(false).build();

    private static final MarshallingInfo<String> CONTAINERINSTANCEARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("containerInstanceArn").isBinary(false).build();

    private static final MarshallingInfo<String> TASKARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("taskArn").isBinary(false).build();

    private static final MarshallingInfo<String> LOGSTREAMNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("logStreamName").isBinary(false).build();

    private static final ContainerDetailMarshaller INSTANCE = new ContainerDetailMarshaller();

    private ContainerDetailMarshaller() {
    }

    public static ContainerDetailMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(ContainerDetail containerDetail, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(containerDetail, "containerDetail");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(containerDetail.image(), IMAGE_BINDING);
            protocolMarshaller.marshall(containerDetail.vcpus(), VCPUS_BINDING);
            protocolMarshaller.marshall(containerDetail.memory(), MEMORY_BINDING);
            protocolMarshaller.marshall(containerDetail.command(), COMMAND_BINDING);
            protocolMarshaller.marshall(containerDetail.jobRoleArn(), JOBROLEARN_BINDING);
            protocolMarshaller.marshall(containerDetail.volumes(), VOLUMES_BINDING);
            protocolMarshaller.marshall(containerDetail.environment(), ENVIRONMENT_BINDING);
            protocolMarshaller.marshall(containerDetail.mountPoints(), MOUNTPOINTS_BINDING);
            protocolMarshaller.marshall(containerDetail.readonlyRootFilesystem(), READONLYROOTFILESYSTEM_BINDING);
            protocolMarshaller.marshall(containerDetail.ulimits(), ULIMITS_BINDING);
            protocolMarshaller.marshall(containerDetail.privileged(), PRIVILEGED_BINDING);
            protocolMarshaller.marshall(containerDetail.user(), USER_BINDING);
            protocolMarshaller.marshall(containerDetail.exitCode(), EXITCODE_BINDING);
            protocolMarshaller.marshall(containerDetail.reason(), REASON_BINDING);
            protocolMarshaller.marshall(containerDetail.containerInstanceArn(), CONTAINERINSTANCEARN_BINDING);
            protocolMarshaller.marshall(containerDetail.taskArn(), TASKARN_BINDING);
            protocolMarshaller.marshall(containerDetail.logStreamName(), LOGSTREAMNAME_BINDING);
        } catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause(e).build();
        }
    }
}
