/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.batch.transform;

import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.batch.model.DescribeJobDefinitionsRequest;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link DescribeJobDefinitionsRequest} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class DescribeJobDefinitionsRequestModelMarshaller {
    private static final MarshallingInfo<List> JOBDEFINITIONS_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("jobDefinitions").isBinary(false).build();

    private static final MarshallingInfo<Integer> MAXRESULTS_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("maxResults").isBinary(false).build();

    private static final MarshallingInfo<String> JOBDEFINITIONNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("jobDefinitionName").isBinary(false).build();

    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("status").isBinary(false).build();

    private static final MarshallingInfo<String> NEXTTOKEN_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("nextToken").isBinary(false).build();

    private static final DescribeJobDefinitionsRequestModelMarshaller INSTANCE = new DescribeJobDefinitionsRequestModelMarshaller();

    private DescribeJobDefinitionsRequestModelMarshaller() {
    }

    public static DescribeJobDefinitionsRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(DescribeJobDefinitionsRequest describeJobDefinitionsRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(describeJobDefinitionsRequest, "describeJobDefinitionsRequest");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(describeJobDefinitionsRequest.jobDefinitions(), JOBDEFINITIONS_BINDING);
            protocolMarshaller.marshall(describeJobDefinitionsRequest.maxResults(), MAXRESULTS_BINDING);
            protocolMarshaller.marshall(describeJobDefinitionsRequest.jobDefinitionName(), JOBDEFINITIONNAME_BINDING);
            protocolMarshaller.marshall(describeJobDefinitionsRequest.status(), STATUS_BINDING);
            protocolMarshaller.marshall(describeJobDefinitionsRequest.nextToken(), NEXTTOKEN_BINDING);
        } catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause(e).build();
        }
    }
}
