/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.batch.transform;

import java.math.*;

import javax.annotation.Generated;

import software.amazon.awssdk.services.batch.model.*;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeJsonUnmarshallers.*;
import software.amazon.awssdk.core.runtime.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * JobDetail JSON Unmarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class JobDetailUnmarshaller implements Unmarshaller<JobDetail, JsonUnmarshallerContext> {

    public JobDetail unmarshall(JsonUnmarshallerContext context) throws Exception {
        JobDetail.Builder jobDetailBuilder = JobDetail.builder();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return null;
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("jobName", targetDepth)) {
                    context.nextToken();
                    jobDetailBuilder.jobName(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("jobId", targetDepth)) {
                    context.nextToken();
                    jobDetailBuilder.jobId(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("jobQueue", targetDepth)) {
                    context.nextToken();
                    jobDetailBuilder.jobQueue(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("status", targetDepth)) {
                    context.nextToken();
                    jobDetailBuilder.status(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("attempts", targetDepth)) {
                    context.nextToken();
                    jobDetailBuilder.attempts(new ListUnmarshaller<AttemptDetail>(AttemptDetailUnmarshaller.getInstance())
                            .unmarshall(context));
                }
                if (context.testExpression("statusReason", targetDepth)) {
                    context.nextToken();
                    jobDetailBuilder.statusReason(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("createdAt", targetDepth)) {
                    context.nextToken();
                    jobDetailBuilder.createdAt(context.getUnmarshaller(Long.class).unmarshall(context));
                }
                if (context.testExpression("retryStrategy", targetDepth)) {
                    context.nextToken();
                    jobDetailBuilder.retryStrategy(RetryStrategyUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("startedAt", targetDepth)) {
                    context.nextToken();
                    jobDetailBuilder.startedAt(context.getUnmarshaller(Long.class).unmarshall(context));
                }
                if (context.testExpression("stoppedAt", targetDepth)) {
                    context.nextToken();
                    jobDetailBuilder.stoppedAt(context.getUnmarshaller(Long.class).unmarshall(context));
                }
                if (context.testExpression("dependsOn", targetDepth)) {
                    context.nextToken();
                    jobDetailBuilder.dependsOn(new ListUnmarshaller<JobDependency>(JobDependencyUnmarshaller.getInstance())
                            .unmarshall(context));
                }
                if (context.testExpression("jobDefinition", targetDepth)) {
                    context.nextToken();
                    jobDetailBuilder.jobDefinition(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("parameters", targetDepth)) {
                    context.nextToken();
                    jobDetailBuilder.parameters(new MapUnmarshaller<String, String>(context.getUnmarshaller(String.class),
                            context.getUnmarshaller(String.class)).unmarshall(context));
                }
                if (context.testExpression("container", targetDepth)) {
                    context.nextToken();
                    jobDetailBuilder.container(ContainerDetailUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("arrayProperties", targetDepth)) {
                    context.nextToken();
                    jobDetailBuilder.arrayProperties(ArrayPropertiesDetailUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("timeout", targetDepth)) {
                    context.nextToken();
                    jobDetailBuilder.timeout(JobTimeoutUnmarshaller.getInstance().unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null
                        || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return jobDetailBuilder.build();
    }

    private static final JobDetailUnmarshaller INSTANCE = new JobDetailUnmarshaller();

    public static JobDetailUnmarshaller getInstance() {
        return INSTANCE;
    }
}
